/*
 * Decompiled with CFR 0.152.
 */
package cn.hollycloud.iplatform.common.utils;

import cn.hollycloud.iplatform.common.annotation.TreeChildren;
import cn.hollycloud.iplatform.common.annotation.TreeId;
import cn.hollycloud.iplatform.common.annotation.TreeLeaf;
import cn.hollycloud.iplatform.common.annotation.TreeName;
import cn.hollycloud.iplatform.common.annotation.TreeParentId;
import cn.hollycloud.iplatform.common.bean.TreeBean;
import cn.hollycloud.iplatform.common.exception.ServiceFailException;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSONArray;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class TreeUtils {
    private static final List DEFAULT_ROOT_IDS = Arrays.asList(null, 0, 0L);

    private static <T> List<TreeBean<T>> parseTree(List<T> list, Field idField, Field parentIdField, Field displayField, List rootIds) {
        if (CollectionUtil.isEmpty((Collection)rootIds)) {
            rootIds = DEFAULT_ROOT_IDS;
        }
        ArrayList<TreeBean<T>> tree = new ArrayList<TreeBean<T>>();
        List<TreeBean> treeBeans = TreeUtils.handleTree(list, idField, parentIdField, displayField);
        for (TreeBean treeBean : treeBeans) {
            if (!rootIds.contains(treeBean.getParentId())) continue;
            tree.add(treeBean);
        }
        return tree;
    }

    public static <T> List<TreeBean<T>> parseTree(List<T> list, Class<T> clazz) {
        return TreeUtils.parseTree(list, clazz, null);
    }

    public static <T> List<TreeBean<T>> parseTree(List<T> list, Class<T> clazz, List rootIds) {
        Field[] fields = ReflectUtil.getFields(clazz);
        Field idField = null;
        Field parentIdField = null;
        Field displayField = null;
        for (Field field : fields) {
            if (field.getAnnotation(TreeId.class) != null) {
                field.setAccessible(true);
                idField = field;
                continue;
            }
            if (field.getAnnotation(TreeParentId.class) != null) {
                field.setAccessible(true);
                parentIdField = field;
                continue;
            }
            if (field.getAnnotation(TreeName.class) == null) continue;
            field.setAccessible(true);
            displayField = field;
        }
        if (idField == null) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230TreeId\u6ce8\u89e3");
        }
        if (parentIdField == null) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230TreeParentId\u6ce8\u89e3");
        }
        if (displayField == null) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230TreeName\u6ce8\u89e3");
        }
        return TreeUtils.parseTree(list, idField, parentIdField, displayField, rootIds);
    }

    private static List<TreeBean> handleTree(List list, Field idField, Field parentIdField, Field displayField) {
        try {
            Object object;
            int i;
            ArrayList<TreeBean> tree = new ArrayList<TreeBean>();
            HashMap map = new HashMap();
            for (i = 0; i < list.size(); ++i) {
                object = list.get(i);
                TreeBean<Object> treeBean = new TreeBean<Object>();
                Object id = idField.get(object);
                if (id == null) continue;
                treeBean.setId(id);
                Object name = displayField.get(object);
                if (name == null) continue;
                treeBean.setDisplayName(name);
                Object parentId = parentIdField.get(object);
                if (parentId != null) {
                    treeBean.setParentId(parentId);
                }
                treeBean.setNativeObject(object);
                treeBean.setDisplayName(name);
                map.put(id, treeBean);
                tree.add(treeBean);
            }
            for (i = 0; i < tree.size(); ++i) {
                TreeBean parentNode;
                object = (TreeBean)tree.get(i);
                Object parentId = ((TreeBean)object).getParentId();
                if (parentId == null || (parentNode = (TreeBean)map.get(parentId)) == null) continue;
                List<TreeBean> children = parentNode.getChildren();
                children.add((TreeBean)object);
                parentNode.setIsLeaf(false);
            }
            return tree;
        }
        catch (Exception e) {
            throw new ServiceFailException("\u89e3\u6790\u6811\u51fa\u9519", (Throwable)e);
        }
    }

    private static List<TreeBean> mountTree(List parentList, Field idField, Field parentIdField, Field displayField, List childList, Field childIdField, Field childParentIdField, Field childDisplayField, List rootIds) {
        try {
            int i;
            if (CollectionUtil.isEmpty((Collection)rootIds)) {
                rootIds = DEFAULT_ROOT_IDS;
            }
            ArrayList<TreeBean> tree = new ArrayList<TreeBean>();
            List<TreeBean> treeBeans = TreeUtils.handleTree(parentList, idField, parentIdField, displayField);
            HashMap<Object, TreeBean> map = new HashMap<Object, TreeBean>();
            for (i = 0; i < treeBeans.size(); ++i) {
                TreeBean treeBean = treeBeans.get(i);
                if (rootIds.contains(treeBean.getParentId())) {
                    tree.add(treeBean);
                }
                map.put(treeBean.getId(), treeBean);
            }
            for (i = 0; i < childList.size(); ++i) {
                Object childNode = childList.get(i);
                TreeBean treeBean = new TreeBean();
                treeBean.setType(1);
                treeBean.setIsLeaf(true);
                Object id = childIdField.get(childNode);
                if (id == null) continue;
                treeBean.setId(id);
                Object name = childDisplayField.get(childNode);
                if (name == null) continue;
                treeBean.setDisplayName(name);
                treeBean.setNativeObject(childNode);
                Object parentId = childParentIdField.get(childNode);
                if (parentId == null) {
                    tree.add(treeBean);
                    continue;
                }
                treeBean.setParentId(parentId);
                TreeBean parentNode = (TreeBean)map.get(parentId);
                if (parentNode == null) continue;
                parentNode.setIsLeaf(false);
                List<TreeBean> children = parentNode.getChildren();
                children.add(treeBean);
            }
            return tree;
        }
        catch (Exception e) {
            throw new ServiceFailException(e);
        }
    }

    public static List<TreeBean> mountTree(List parentList, Class parentClass, List childList, Class childClass) {
        return TreeUtils.mountTree(parentList, parentClass, childList, childClass, null);
    }

    public static List<TreeBean> mountTree(List parentList, Class parentClass, List childList, Class childClass, List rootIds) {
        Field[] fields = ReflectUtil.getFields((Class)parentClass);
        Field idField = null;
        Field parentIdField = null;
        Field displayField = null;
        for (Field field : fields) {
            if (field.getAnnotation(TreeId.class) != null) {
                field.setAccessible(true);
                idField = field;
                continue;
            }
            if (field.getAnnotation(TreeParentId.class) != null) {
                field.setAccessible(true);
                parentIdField = field;
                continue;
            }
            if (field.getAnnotation(TreeName.class) == null) continue;
            field.setAccessible(true);
            displayField = field;
        }
        if (idField == null) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230TreeId\u6ce8\u89e3");
        }
        if (parentIdField == null) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230TreeParentId\u6ce8\u89e3");
        }
        if (displayField == null) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230TreeName\u6ce8\u89e3");
        }
        fields = ReflectUtil.getFields((Class)childClass);
        Field childIdField = null;
        Field childParentIdField = null;
        Field childDisplayField = null;
        for (Field field : fields) {
            if (field.getAnnotation(TreeId.class) != null) {
                field.setAccessible(true);
                childIdField = field;
                continue;
            }
            if (field.getAnnotation(TreeParentId.class) != null) {
                field.setAccessible(true);
                childParentIdField = field;
                continue;
            }
            if (field.getAnnotation(TreeName.class) == null) continue;
            field.setAccessible(true);
            childDisplayField = field;
        }
        if (childIdField == null) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230\u5b50\u8282\u70b9TreeId\u6ce8\u89e3");
        }
        if (childParentIdField == null) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230\u5b50\u8282\u70b9TreeParentId\u6ce8\u89e3");
        }
        if (childDisplayField == null) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230\u5b50\u8282\u70b9TreeName\u6ce8\u89e3");
        }
        return TreeUtils.mountTree(parentList, idField, parentIdField, displayField, childList, childIdField, childParentIdField, childDisplayField, rootIds);
    }

    public static <T> List<T> parseStandardTree(List<T> list, Class<T> clazz) {
        return TreeUtils.parseStandardTree(list, clazz, null);
    }

    public static <T> List<T> parseStandardTree(List<T> list, Class<T> clazz, List rootIds) {
        Field[] fields = ReflectUtil.getFields(clazz);
        Field idField = null;
        Field parentIdField = null;
        Field childrenField = null;
        Field leafField = null;
        for (Field field : fields) {
            if (field.getAnnotation(TreeId.class) != null) {
                field.setAccessible(true);
                idField = field;
                continue;
            }
            if (field.getAnnotation(TreeParentId.class) != null) {
                field.setAccessible(true);
                parentIdField = field;
                continue;
            }
            if (field.getAnnotation(TreeChildren.class) != null) {
                field.setAccessible(true);
                if (!Collection.class.isAssignableFrom(field.getType())) {
                    throw new ServiceFailException("TreeChildren\u5bf9\u5e94\u7c7b\u578b\u5fc5\u987b\u662f\u5bb9\u5668\u7c7b");
                }
                childrenField = field;
                continue;
            }
            if (field.getAnnotation(TreeLeaf.class) == null) continue;
            if (field.getType() != Boolean.class) {
                throw new ServiceFailException("TreeLeaf\u5bf9\u5e94\u7c7b\u578b\u5fc5\u987b\u662fBoolean");
            }
            field.setAccessible(true);
            leafField = field;
        }
        if (idField == null) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230TreeId\u6ce8\u89e3");
        }
        if (parentIdField == null) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230TreeParentId\u6ce8\u89e3");
        }
        if (childrenField == null) {
            throw new ServiceFailException("\u6ca1\u6709\u627e\u5230TreeChildren\u6ce8\u89e3");
        }
        return TreeUtils.parseStandardTree(list, idField, parentIdField, childrenField, leafField, rootIds);
    }

    private static <T> List<T> parseStandardTree(List<T> list, Field idField, Field parentIdField, Field childrenField, Field leafField, List rootIds) {
        try {
            if (CollectionUtil.isEmpty((Collection)rootIds)) {
                rootIds = DEFAULT_ROOT_IDS;
            }
            ArrayList<T> tree = new ArrayList<T>();
            List<T> treeBeans = TreeUtils.handleStandardTree(list, idField, parentIdField, childrenField, leafField);
            for (T treeBean : treeBeans) {
                if (!rootIds.contains(parentIdField.get(treeBean))) continue;
                tree.add(treeBean);
            }
            return tree;
        }
        catch (Exception e) {
            throw new ServiceFailException("\u89e3\u6790\u6811\u51fa\u9519", (Throwable)e);
        }
    }

    private static <T> List<T> handleStandardTree(List<T> list, Field idField, Field parentIdField, Field childrenField, Field leafField) throws IllegalAccessException {
        Object object;
        int i;
        ArrayList<T> tree = new ArrayList<T>();
        HashMap<Object, T> map = new HashMap<Object, T>();
        for (i = 0; i < list.size(); ++i) {
            Object id;
            object = list.get(i);
            if (leafField != null) {
                leafField.set(object, true);
            }
            if ((id = idField.get(object)) == null) continue;
            map.put(id, object);
            tree.add(object);
        }
        for (i = 0; i < tree.size(); ++i) {
            Object parentNode;
            object = tree.get(i);
            Object parentId = parentIdField.get(object);
            if (parentId == null || (parentNode = map.get(parentId)) == null) continue;
            Collection children = (Collection)childrenField.get(parentNode);
            if (children == null) {
                children = new JSONArray();
                childrenField.set(parentNode, children);
            }
            children.add(object);
            if (leafField == null) continue;
            leafField.set(parentNode, false);
        }
        return tree;
    }
}

