/*
 * Decompiled with CFR 0.152.
 */
package cn.hssnow.quartz;

import cn.hssnow.quartz.support.JobOption;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;

public class JobManager {
    private static final String JOB_KEY = "job_instance";
    private static Scheduler scheduler = SchedulerInstance.SCHEDULER;

    public static void addJob(Job job) throws SchedulerException {
        JobOption option = job.getClass().getAnnotation(JobOption.class);
        String name = option.name();
        String group = option.group().isEmpty() ? name : option.group();
        String desc = option.desc();
        String cron = option.cron();
        JobDetail jobDetail = JobBuilder.newJob(JobProxy.class).withDescription(desc).withIdentity(name, group).build();
        Trigger trigger = TriggerBuilder.newTrigger().withDescription(desc).withIdentity(name, group).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
        jobDetail.getJobDataMap().put(JOB_KEY, (Object)job);
        scheduler.scheduleJob(jobDetail, trigger);
        scheduler.start();
    }

    public static void destroy(Job job) throws SchedulerException {
        JobOption option = job.getClass().getAnnotation(JobOption.class);
        String name = option.name();
        String group = option.group().isEmpty() ? name : option.group();
        scheduler.deleteJob(new JobKey(name, group));
    }

    public static void pause(Job job) throws SchedulerException {
        JobOption option = job.getClass().getAnnotation(JobOption.class);
        String name = option.name();
        String group = option.group().isEmpty() ? name : option.group();
        scheduler.pauseJob(new JobKey(name, group));
    }

    public static void resume(Job job) throws SchedulerException {
        JobOption option = job.getClass().getAnnotation(JobOption.class);
        String name = option.name();
        String group = option.group().isEmpty() ? name : option.group();
        scheduler.resumeJob(new JobKey(name, group));
    }

    public static void execute(Job job) throws SchedulerException {
        JobOption option = job.getClass().getAnnotation(JobOption.class);
        String name = option.name();
        String group = option.group().isEmpty() ? name : option.group();
        scheduler.triggerJob(JobKey.jobKey((String)name, (String)group));
    }

    public static Set<Job> queryAllJobInstances() throws SchedulerException {
        HashSet<Job> jobInstances = new HashSet<Job>();
        Set jobKeys = scheduler.getJobKeys(GroupMatcher.anyJobGroup());
        for (JobKey jobKey : jobKeys) {
            JobDetail jobDetail = scheduler.getJobDetail(jobKey);
            Object o = jobDetail.getJobDataMap().get((Object)JOB_KEY);
            jobInstances.add((Job)o);
        }
        return jobInstances;
    }

    public static Set<Job> queryExecutingJobInstances() throws SchedulerException {
        HashSet<Job> jobInstances = new HashSet<Job>();
        List executionContexts = scheduler.getCurrentlyExecutingJobs();
        for (JobExecutionContext executionContext : executionContexts) {
            Object o = executionContext.getJobDetail().getJobDataMap().get((Object)JOB_KEY);
            jobInstances.add((Job)o);
        }
        return jobInstances;
    }

    private static class SchedulerInstance {
        public static final Scheduler SCHEDULER = SchedulerInstance.scheduler();

        private SchedulerInstance() {
        }

        private static Scheduler scheduler() {
            try {
                return new StdSchedulerFactory().getScheduler();
            }
            catch (SchedulerException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class JobProxy
    implements Job {
        public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
            Object job = jobExecutionContext.getMergedJobDataMap().get((Object)JobManager.JOB_KEY);
            if (job != null) {
                ((Job)job).execute(jobExecutionContext);
            }
        }
    }
}

