/*
 * Decompiled with CFR 0.152.
 */
package cn.hssnow.quartz.utils;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassUtil {
    private static final String CLASS_SUFFIX = ".class";
    private static final String CLASS_FILE_PREFIX = File.separator + "classes" + File.separator;
    private static final String PACKAGE_SEPARATOR = ".";

    public static List<String> getClasses(String packageName) {
        return ClassUtil.getClasses(packageName, true);
    }

    public static List<String> getClasses(String packageName, boolean scanChildPackage) {
        ArrayList<String> result = new ArrayList<String>();
        String path = packageName.replace(PACKAGE_SEPARATOR, "/");
        URL url = Thread.currentThread().getContextClassLoader().getResource(path);
        if (url != null) {
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                result.addAll(ClassUtil.getClassesInFile(new File(url.getPath()), scanChildPackage));
            } else if ("jar".equals(protocol)) {
                JarFile jarFile = null;
                try {
                    jarFile = ((JarURLConnection)url.openConnection()).getJarFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (jarFile != null) {
                    result.addAll(ClassUtil.getClassesInJar(jarFile, packageName, scanChildPackage));
                }
            }
        }
        return result;
    }

    private static List<String> getClassesInFile(File file, boolean flag) {
        ArrayList<String> result = new ArrayList<String>();
        if (!file.exists()) {
            return result;
        }
        LinkedList<File> files = new LinkedList<File>();
        files.push(file);
        while (!files.isEmpty()) {
            File[] fs;
            File f = (File)files.pop();
            if (f.isFile()) {
                String clazzName;
                String path = f.getPath();
                if (!path.endsWith(CLASS_SUFFIX) || (clazzName = (path = path.replace(CLASS_SUFFIX, "")).substring(path.indexOf(CLASS_FILE_PREFIX) + CLASS_FILE_PREFIX.length()).replace(File.separator, PACKAGE_SEPARATOR)).contains("$")) continue;
                result.add(clazzName);
                continue;
            }
            if (!f.isDirectory() || !flag && f != file || (fs = f.listFiles()) == null) continue;
            Collections.addAll(files, fs);
        }
        return result;
    }

    private static List<String> getClassesInJar(JarFile jarFile, String packageName, boolean flag) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String name = jarEntry.getName();
            if (!name.endsWith(CLASS_SUFFIX)) continue;
            name = name.replace(CLASS_SUFFIX, "").replace("/", PACKAGE_SEPARATOR);
            if (flag) {
                if (!name.startsWith(packageName) || name.contains("$")) continue;
                result.add(name);
                continue;
            }
            if (!packageName.equals(name.substring(0, name.lastIndexOf(PACKAGE_SEPARATOR))) || name.contains("$")) continue;
            result.add(name);
        }
        return result;
    }
}

