/*
 * Decompiled with CFR 0.152.
 */
package cn.huangxulin.githook.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StreamUtils;

public class GitHookService
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(GitHookService.class);
    private static final String CLASS_PATH_SUFFIX = "/target/classes/";

    public void run(String ... args) {
        ClassPathResource resource = new ClassPathResource("git-hooks");
        if (!resource.exists()) {
            log.warn("[Git hook] - ClassPath/git-hooks \u8def\u5f84\u4e0b\u672a\u53d1\u73b0 git hook \u811a\u672c");
            return;
        }
        File[] hookFiles = null;
        try {
            File hookDir = resource.getFile();
            if (hookDir.exists() && hookDir.isDirectory()) {
                hookFiles = hookDir.listFiles();
            }
        }
        catch (Exception ignored) {
            log.warn("[Git hook] - ClassPath/git-hooks \u8def\u5f84\u4e0b\u672a\u53d1\u73b0 git hook \u811a\u672c");
            return;
        }
        if (hookFiles == null || hookFiles.length == 0) {
            log.warn("[Git hook] - ClassPath/git-hooks \u8def\u5f84\u4e0b\u672a\u53d1\u73b0 git hook \u811a\u672c");
            return;
        }
        URL url = Thread.currentThread().getContextClassLoader().getResource("");
        String classPath = Objects.requireNonNull(url).getPath();
        if (!classPath.endsWith(CLASS_PATH_SUFFIX)) {
            log.warn("[Git hook] - ClassPath \u8def\u5f84\u68c0\u67e5\u5931\u8d25");
            return;
        }
        File hookDir = this.getHookDir(classPath.substring(0, classPath.length() - 15));
        if (hookDir == null) {
            log.warn("[Git hook] - git hook \u914d\u7f6e\u6587\u4ef6\u5b58\u50a8\u4f4d\u7f6e\u68c0\u67e5\u5931\u8d25");
            return;
        }
        for (File hookFile : hookFiles) {
            String fileName = hookFile.getName();
            File targetFile = new File(hookDir, fileName);
            try (FileInputStream in = new FileInputStream(hookFile);
                 FileOutputStream out = new FileOutputStream(targetFile);){
                StreamUtils.copy((InputStream)in, (OutputStream)out);
            }
            catch (IOException ignored) {
                log.error("[Git hook] - git hook \u914d\u7f6e\u6587\u4ef6\u521d\u59cb\u5316\u5931\u8d25");
            }
            if (!targetFile.setExecutable(true, false)) continue;
            log.warn("[Git hook] - git hook \u811a\u672c\u6587\u4ef6\uff1a" + targetFile.getName() + " \u8bbe\u7f6e\u53ef\u6267\u884c\u6743\u9650\u5931\u8d25");
        }
    }

    private File getHookDir(String workDir) {
        if (workDir == null) {
            return null;
        }
        File hookDir = new File(workDir, ".git/hooks");
        if (!hookDir.exists() || !hookDir.isDirectory()) {
            File targetDir = new File(workDir);
            if (targetDir.exists()) {
                return this.getHookDir(targetDir.getParent());
            }
            return null;
        }
        return hookDir;
    }
}

