/*
 * Decompiled with CFR 0.152.
 */
package cn.huangxulin.githook.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StreamUtils;

public class GitHookService
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(GitHookService.class);
    private static final String CLASS_PATH_SUFFIX = "/target/classes/";

    public void run(String ... args) {
        ClassPathResource resource = new ClassPathResource("git-hooks");
        if (!resource.exists()) {
            log.warn("git hook script not found in classpath/git-hooks");
            return;
        }
        File[] hookFiles = null;
        try {
            File hookDir = resource.getFile();
            if (hookDir.exists() && hookDir.isDirectory()) {
                hookFiles = hookDir.listFiles();
            }
        }
        catch (Exception ignored) {
            log.warn("git hook script not found in classpath/git-hooks");
            return;
        }
        if (hookFiles == null || hookFiles.length == 0) {
            log.warn("git hook script not found in classpath/git-hooks");
            return;
        }
        URL url = Thread.currentThread().getContextClassLoader().getResource("");
        String classPath = Objects.requireNonNull(url).getPath();
        if (!classPath.endsWith(CLASS_PATH_SUFFIX)) {
            log.warn("git hook classpath check failed");
            return;
        }
        File hookDir = this.getHookDir(classPath.substring(0, classPath.length() - 15));
        if (hookDir == null) {
            log.warn("git hook profile storage location check failed");
            return;
        }
        for (File hookFile : hookFiles) {
            String fileName = hookFile.getName();
            File targetFile = new File(hookDir, fileName);
            try (FileInputStream in = new FileInputStream(hookFile);
                 FileOutputStream out = new FileOutputStream(targetFile);){
                StreamUtils.copy((InputStream)in, (OutputStream)out);
            }
            catch (IOException ignored) {
                log.error("git hook profile init failed");
            }
            if (!targetFile.setExecutable(true, false)) continue;
            log.info("git hook script: {} executable permission cannot be set", (Object)targetFile.getName());
        }
    }

    private File getHookDir(String workDir) {
        if (workDir == null) {
            return null;
        }
        File hookDir = new File(workDir, ".git/hooks");
        if (!hookDir.exists() || !hookDir.isDirectory()) {
            File targetDir = new File(workDir);
            if (targetDir.exists()) {
                return this.getHookDir(targetDir.getParent());
            }
            return null;
        }
        return hookDir;
    }
}

