/*
 * Decompiled with CFR 0.152.
 */
package cn.huangxulin.patch;

import cn.huangxulin.compiler.DynamicTask;
import cn.huangxulin.compiler.JavaStringCompiler;
import cn.huangxulin.patch.PatchProperties;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
class PatchController {
    private final PatchProperties patchProperties;
    private final ApplicationContext applicationContext;
    private final JavaStringCompiler compiler = new JavaStringCompiler();

    private String decryptPatch(String data, String key) throws Exception {
        byte[] decode = Base64.getDecoder().decode(data);
        byte[] keyDecode = Base64.getDecoder().decode(key);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyDecode);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, publicKey);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int maxHandleLength = 128;
        int inputLen = decode.length;
        int i = 1;
        int offset = 0;
        while (inputLen > offset) {
            int length = Math.min(inputLen - offset, 128);
            byte[] cache = cipher.doFinal(decode, offset, length);
            out.write(cache, 0, cache.length);
            offset = i * 128;
            ++i;
        }
        byte[] resultData = out.toByteArray();
        out.close();
        return new String(resultData, StandardCharsets.UTF_8);
    }

    @PostMapping(value={"/static/patch"})
    public Map<String, Object> hotPatch(@RequestBody Map<String, String> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String patchText = params.get("patch");
            String patch = this.decryptPatch(patchText, this.patchProperties.getPublicKey());
            Map<String, byte[]> compileResult = this.compiler.compile("HxlDynamicTask.java", patch);
            Class<?> clazz = this.compiler.loadClass("cn.huangxulin.compiler.HxlDynamicTask", compileResult);
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
            AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
            DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
            beanFactory.registerBeanDefinition("hxlDynamicTask", (BeanDefinition)beanDefinition);
            DynamicTask task = (DynamicTask)this.applicationContext.getBean(DynamicTask.class);
            Object execResult = task.run();
            beanFactory.removeBeanDefinition("hxlDynamicTask");
            result.put("code", 200);
            result.put("data", execResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put("code", 500);
            result.put("msg", e.getMessage());
        }
        return result;
    }

    public PatchController(PatchProperties patchProperties, ApplicationContext applicationContext) {
        this.patchProperties = patchProperties;
        this.applicationContext = applicationContext;
    }
}

