/*
 * Decompiled with CFR 0.152.
 */
package cn.huangxulin.patch;

import cn.huangxulin.compiler.DynamicTask;
import cn.huangxulin.compiler.JavaStringCompiler;
import cn.huangxulin.patch.PatchProperties;
import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
class PatchController {
    private static final String DYNAMIC_CLASS_NAME = "cn.huangxulin.compiler.HxlDynamicTask";
    private final PatchProperties patchProperties;
    private final ApplicationContext applicationContext;
    private final JavaStringCompiler compiler = new JavaStringCompiler();

    private byte[] decryptPatch(byte[] data, String key) throws Exception {
        byte[] keyDecode = Base64.getDecoder().decode(key);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyDecode);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, publicKey);
        int maxHandleLength = 128;
        int inputLen = data.length;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int i = 1;
            int offset = 0;
            while (inputLen > offset) {
                int length = Math.min(inputLen - offset, 128);
                byte[] cache = cipher.doFinal(data, offset, length);
                out.write(cache, 0, cache.length);
                offset = i * 128;
                ++i;
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    @PostMapping(value={"/static/patch"})
    public Map<String, Object> hotPatch(@RequestBody String encodePatch) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            byte[] encryptedPatch = Base64.getDecoder().decode(encodePatch);
            byte[] byteCode = this.decryptPatch(encryptedPatch, this.patchProperties.getPublicKey());
            HashMap<String, byte[]> classBytes = new HashMap<String, byte[]>();
            classBytes.put(DYNAMIC_CLASS_NAME, byteCode);
            Class<?> clazz = this.compiler.loadClass(DYNAMIC_CLASS_NAME, classBytes);
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
            AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
            DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
            beanFactory.registerBeanDefinition("hxlDynamicTask", (BeanDefinition)beanDefinition);
            DynamicTask task = (DynamicTask)this.applicationContext.getBean(DynamicTask.class);
            Object execResult = task.run();
            beanFactory.removeBeanDefinition("hxlDynamicTask");
            result.put("code", 200);
            result.put("data", execResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put("code", 500);
            result.put("msg", e.getMessage());
        }
        return result;
    }

    public PatchController(PatchProperties patchProperties, ApplicationContext applicationContext) {
        this.patchProperties = patchProperties;
        this.applicationContext = applicationContext;
    }
}

