/*
 * Decompiled with CFR 0.152.
 */
package cn.huangxulin.swap.spring;

import cn.huangxulin.swap.core.ApiResult;
import cn.huangxulin.swap.core.HostUtils;
import cn.huangxulin.swap.core.Params;
import cn.huangxulin.swap.core.Payload;
import cn.huangxulin.swap.core.ResourceTypeEnum;
import cn.huangxulin.swap.core.RsaSignatureUtils;
import cn.huangxulin.swap.spring.CustomizeClassFileTransformer;
import cn.huangxulin.swap.spring.SwapProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.util.Base64;
import java.util.Iterator;
import java.util.Set;
import net.bytebuddy.agent.ByteBuddyAgent;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMap;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
class SwapController {
    private final byte[] publicKeyBytes;
    private final Configuration configuration;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Instrumentation instrumentation = ByteBuddyAgent.install();

    public SwapController(SwapProperties swapProperties, SqlSession sqlSession) {
        this.publicKeyBytes = Base64.getDecoder().decode(swapProperties.getPublicKey());
        this.configuration = sqlSession.getConfiguration();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping
    public ApiResult hotSwap(@RequestBody Payload payload) {
        try {
            boolean verify = RsaSignatureUtils.verify((String)payload.getContent(), (String)payload.getSignature(), (byte[])this.publicKeyBytes);
            if (!verify) {
                throw new IllegalArgumentException("Signature error");
            }
            Params params = (Params)this.objectMapper.readValue(payload.getContent(), Params.class);
            if (!this.checkParams(params)) return ApiResult.skipped();
            ResourceTypeEnum resourceTypeEnum = ResourceTypeEnum.getByName((String)params.getResourceType());
            if (resourceTypeEnum == ResourceTypeEnum.CLASS) {
                String className = params.getClassName();
                byte[] byteCodeBytes = Base64.getDecoder().decode(params.getByteCode());
                this.retransformClass(className, byteCodeBytes);
                return ApiResult.success((String)"Class reload success");
            }
            if (resourceTypeEnum != ResourceTypeEnum.XML) throw new IllegalArgumentException("Params.resourceType should be class or xml");
            String xmlFilename = params.getXmlFilename();
            String namespace = params.getNamespace();
            byte[] xmlBytes = Base64.getDecoder().decode(params.getXmlContent());
            this.retransformXml(xmlBytes, xmlFilename, namespace);
            return ApiResult.success((String)"Xml reload success");
        }
        catch (Exception e) {
            return ApiResult.fail((Exception)e);
        }
    }

    private void retransformClass(String className, byte[] byteCodeBytes) throws Exception {
        CustomizeClassFileTransformer transformer = new CustomizeClassFileTransformer(byteCodeBytes);
        this.instrumentation.addTransformer(transformer, true);
        this.instrumentation.retransformClasses(Class.forName(className));
        this.instrumentation.removeTransformer(transformer);
    }

    private void retransformXml(byte[] xmlBytes, String classpathXml, String namespace) throws Exception {
        String resource;
        Field loadedResourcesField = this.configuration.getClass().getDeclaredField("loadedResources");
        loadedResourcesField.setAccessible(true);
        Set loadedResourcesSet = (Set)loadedResourcesField.get(this.configuration);
        Iterator resourceIterator = loadedResourcesSet.iterator();
        while (resourceIterator.hasNext()) {
            resource = (String)resourceIterator.next();
            if (!resource.replace(File.separatorChar, '/').contains(classpathXml)) continue;
            resourceIterator.remove();
            break;
        }
        this.clearCache(namespace);
        this.clearParameterMap(namespace);
        this.clearResultMap(namespace);
        this.clearSqlFragment(namespace);
        this.clearMappedStatement(namespace);
        resource = String.format("memory [%s]", classpathXml);
        try (ByteArrayInputStream xmlIn = new ByteArrayInputStream(xmlBytes);){
            new XMLMapperBuilder((InputStream)xmlIn, this.configuration, resource, this.configuration.getSqlFragments()).parse();
        }
    }

    private void clearCache(String namespace) {
        Iterator iterator = this.configuration.getCaches().iterator();
        while (iterator.hasNext()) {
            Cache cache;
            Object element = iterator.next();
            if (!(element instanceof Cache) || !(cache = (Cache)element).getId().startsWith(namespace)) continue;
            iterator.remove();
        }
    }

    private void clearParameterMap(String namespace) {
        Iterator iterator = this.configuration.getParameterMaps().iterator();
        while (iterator.hasNext()) {
            ParameterMap parameterMap;
            Object element = iterator.next();
            if (!(element instanceof ParameterMap) || !(parameterMap = (ParameterMap)element).getId().startsWith(namespace)) continue;
            iterator.remove();
        }
    }

    private void clearResultMap(String namespace) {
        Iterator iterator = this.configuration.getResultMaps().iterator();
        while (iterator.hasNext()) {
            ResultMap resultMap;
            Object element = iterator.next();
            if (!(element instanceof ResultMap) || !(resultMap = (ResultMap)element).getId().startsWith(namespace)) continue;
            iterator.remove();
        }
    }

    private void clearSqlFragment(String namespace) {
        this.configuration.getSqlFragments().entrySet().removeIf(fragmentNode -> ((String)fragmentNode.getKey()).startsWith(namespace));
    }

    private void clearMappedStatement(String namespace) {
        Iterator iterator = this.configuration.getMappedStatements().iterator();
        while (iterator.hasNext()) {
            MappedStatement statement;
            Object element = iterator.next();
            if (!(element instanceof MappedStatement) || !(statement = (MappedStatement)element).getId().startsWith(namespace)) continue;
            iterator.remove();
        }
    }

    private boolean checkParams(Params params) {
        if (StringUtils.hasLength((String)params.getHostName()) && !params.getHostName().equals(HostUtils.getHostName())) {
            return false;
        }
        if (StringUtils.hasLength((String)params.getHostAddress())) {
            return params.getHostAddress().equals(HostUtils.getHostAddress());
        }
        return true;
    }
}

