/*
 * Decompiled with CFR 0.152.
 */
package cn.huangxulin.swap.spring;

import cn.huangxulin.swap.spring.SwapController;
import cn.huangxulin.swap.spring.SwapProperties;
import java.lang.reflect.Method;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

class SwapRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    private static final String SWAP_METHOD_NAME = "hotSwap";
    private final SwapProperties swapProperties;

    public SwapRequestMappingHandlerMapping(SwapProperties swapProperties) {
        this.swapProperties = swapProperties;
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo info = super.getMappingForMethod(method, handlerType);
        if (handlerType == SwapController.class && SWAP_METHOD_NAME.equals(method.getName()) && info != null) {
            return RequestMappingInfo.paths((String[])new String[]{this.swapProperties.getPath()}).build().combine(info);
        }
        return info;
    }
}

