/*
 * Decompiled with CFR 0.152.
 */
package cn.iaimi.freeimgtools.tools;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.iaimi.freeimgtools.common.ErrorCode;
import cn.iaimi.freeimgtools.exception.BizException;
import cn.iaimi.freeimgtools.model.config.FreeImgConfig;
import cn.iaimi.freeimgtools.model.domain.Image;
import cn.iaimi.freeimgtools.model.dto.UploadImgRes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.springframework.web.multipart.MultipartFile;

public class FreeImgCrudTool {
    @Resource
    private FreeImgConfig freeImgConfig;
    private static final String ERROR_STR = "\u6587\u4ef6\u53c2\u6570 || \u6d41 \u4e3a\u7a7a";

    public UploadImgRes uploadImage(File file) {
        if (file == null) {
            throw new BizException(ErrorCode.PARAMS_ERROR, ERROR_STR);
        }
        String basePath = System.getProperty("user.dir");
        File localFile = new File(basePath + "/temp_image.jpg");
        try {
            FileUtils.copyFile((File)file, (File)localFile);
        }
        catch (IOException e) {
            throw new BizException(ErrorCode.SYSTEM_ERROR, e.getMessage());
        }
        return this.getUploadImgRes(file);
    }

    public UploadImgRes uploadImage(MultipartFile multipartFile) {
        if (multipartFile == null) {
            throw new BizException(ErrorCode.PARAMS_ERROR, ERROR_STR);
        }
        String basePath = System.getProperty("user.dir");
        File localFile = new File(basePath + "/" + multipartFile.getOriginalFilename());
        try {
            multipartFile.transferTo(localFile);
        }
        catch (IOException e) {
            throw new BizException(ErrorCode.SYSTEM_ERROR, e.getMessage());
        }
        return this.getUploadImgRes(localFile);
    }

    public UploadImgRes uploadImage(InputStream inputStream) {
        if (inputStream == null) {
            throw new BizException(ErrorCode.PARAMS_ERROR, ERROR_STR);
        }
        String basePath = System.getProperty("user.dir");
        File localFile = new File(basePath + "/temp_image.jpg");
        try {
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)localFile);
        }
        catch (IOException e) {
            throw new BizException(ErrorCode.SYSTEM_ERROR, e.getMessage());
        }
        return this.getUploadImgRes(localFile);
    }

    private UploadImgRes getUploadImgRes(File localFile) {
        HashMap<String, Comparable<File>> paramMap = new HashMap<String, Comparable<File>>();
        paramMap.put("file", localFile);
        paramMap.put("permission", Integer.valueOf(0));
        if (this.freeImgConfig.FREEIMG_ALBUM_ID != null) {
            paramMap.put("album_id", this.freeImgConfig.FREEIMG_ALBUM_ID);
        }
        String body = ((HttpRequest)HttpRequest.post((String)this.freeImgConfig.UPLOAD_IMAGE_URL).header("Authorization", this.freeImgConfig.FREEIMG_TOKEN)).form(paramMap).execute().body();
        boolean delete = localFile.delete();
        if (!delete) {
            throw new BizException(ErrorCode.SYSTEM_ERROR, "\u5220\u9664\u4e34\u65f6\u56fe\u7247\u5931\u8d25");
        }
        Gson gson = new GsonBuilder().setLenient().enableComplexMapKeySerialization().serializeNulls().setPrettyPrinting().disableHtmlEscaping().create();
        return (UploadImgRes)gson.fromJson(body, UploadImgRes.class);
    }

    public boolean deleteImg(String deleteUrl) {
        HttpResponse res = ((HttpRequest)HttpRequest.get((String)deleteUrl).header("Authorization", this.freeImgConfig.FREEIMG_TOKEN)).execute();
        return res.isOk();
    }

    @Deprecated
    public boolean deleteImg(Image image) {
        String key = image.imgKey();
        String deleteUrl = "https://www.freeimg.cn/images/" + key;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("key", key);
        HttpResponse res = ((HttpRequest)HttpRequest.delete((String)deleteUrl).header("Authorization", this.freeImgConfig.FREEIMG_TOKEN)).form(paramMap).execute();
        if (res.isOk() || res.getStatus() == 302) {
            System.out.println(res.body());
            JSONObject obj = JSONUtil.parseObj((String)res.body());
            return obj.getBool((Object)"status");
        }
        return false;
    }
}

