/*
 * Decompiled with CFR 0.152.
 */
package cn.iaimi.openaisdk;

import cn.iaimi.openaisdk.aisender.Exchanger;
import cn.iaimi.openaisdk.aisender.Sender;
import cn.iaimi.openaisdk.aisender.impl.ExchangerImpl;
import cn.iaimi.openaisdk.aisender.impl.SenderImpl;
import cn.iaimi.openaisdk.api.OpenAiApi;
import cn.iaimi.openaisdk.exception.BusinessException;
import cn.iaimi.openaisdk.model.dto.ai.ConfigInfo;
import cn.iaimi.openaisdk.model.dto.ai.Message;
import java.util.List;

public class AiFactory {
    private String openAiApiKey;
    private String url = "https://api.openai.com/v1/chat/completions";
    private String proxyHost;
    private Integer proxyPort;
    private String model = "gpt-3.5-turbo";
    private int msgMaxSize = 20;
    private OpenAiApi openAiApi;

    public AiFactory(String openAiApiKey, OpenAiApi openAiApi) {
        this.openAiApiKey = openAiApiKey;
        this.openAiApi = openAiApi;
    }

    public AiFactory withUrl(String url) {
        this.url = url;
        return this;
    }

    public AiFactory withProxy(String proxyHost, Integer proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        return this;
    }

    public AiFactory withModel(String model) {
        this.model = model;
        return this;
    }

    public AiFactory withMsgMaxSize(int msgMaxSize) {
        this.msgMaxSize = msgMaxSize;
        return this;
    }

    public Sender createSender() {
        ConfigInfo configInfo = this.createConfigInfo();
        return new SenderImpl(configInfo, this.openAiApi);
    }

    public Exchanger createExchanger() {
        ConfigInfo configInfo = this.createConfigInfo();
        return new ExchangerImpl(this.msgMaxSize, configInfo, this.openAiApi);
    }

    private ConfigInfo createConfigInfo() {
        return new ConfigInfo(this.openAiApiKey, this.url, this.proxyHost, this.proxyPort, this.model);
    }

    public static void main(String[] args) {
        String openAiApiKey = "sk-xxxxxxxx";
        OpenAiApi openAiApi = new OpenAiApi();
        AiFactory aiFactory = new AiFactory(openAiApiKey, openAiApi).withUrl("https://api.openai.com/v1/chat/completions").withProxy("127.0.0.1", 7890).withModel("gpt-3.5-turbo").withMsgMaxSize(30);
        Sender sender = aiFactory.createSender();
        Exchanger exchanger = aiFactory.createExchanger();
        try {
            Message chat = sender.toChat("\u4f60\u597d\uff0c\u8fd9\u662f\u4e00\u6761\u6d4b\u8bd5\u6d88\u606f");
            System.out.println(chat);
            Message chatPresets = sender.toChatPresets("\u4f60\u597d\uff0c\u8bf7\u544a\u8bc9\u6211\u4f60\u662f\u8c01", "\u4f60\u7684\u540d\u5b57\u53eb\u5c0f\u667a\uff0c\u662f\u4e00\u540d\u65e0\u6240\u4e0d\u77e5\u7684\u667a\u8005");
            System.out.println(chatPresets);
            Message res = exchanger.talk("\u8bf7\u4f60\u8bb0\u4f4f task = 123");
            System.out.println(res);
            res = exchanger.talk("task \u7684\u503c \u662f\u591a\u5c11\uff0c\u56de\u7b54\u6211");
            System.out.println(res);
            long startTime = System.currentTimeMillis();
            exchanger.setPreSetMsg("\u4f60\u73b0\u5728\u662f\u4e00\u4f4d\u7ed8\u56fe\u4e13\u5bb6\uff0c\u4f60\u6700\u64c5\u957f\u7684\u4e8b\u60c5\u5c31\u662f\u7ed8\u753b");
            Message talk = exchanger.talk("\u544a\u8bc9\u6211\uff0c\u4f60\u6700\u64c5\u957f\u7684\u4e8b\u60c5");
            System.out.println(talk);
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - startTime;
            System.out.println("Elapsed Time: " + elapsedTime / 1000L + " seconds");
            talk = exchanger.talk("\u4ecb\u7ecd\u4e00\u4e0b\u4f60\u81ea\u5df1");
            System.out.println(talk);
            List<Message> msgs = exchanger.getMsgs();
            System.out.println("msgs: " + msgs);
            Message lastAnswer = exchanger.getLastAnswer();
            System.out.println("lastAnswer: " + lastAnswer);
            exchanger.clearMsg();
            Message talk1 = exchanger.talk("\u4f60\u597d\uff0c\u4ecb\u7ecd\u4e00\u4e0b\u4f60\u81ea\u5df1");
            System.out.println(talk1);
            List<Message> msgs1 = exchanger.getMsgs();
            System.out.println(msgs1);
            System.out.println(msgs1.size());
            exchanger.clearPreSet();
        }
        catch (BusinessException be) {
            throw new RuntimeException(be);
        }
    }
}

