/*
 * Decompiled with CFR 0.152.
 */
package cn.iaimi.openaisdk;

import cn.iaimi.openaisdk.aisender.Exchanger;
import cn.iaimi.openaisdk.aisender.Sender;
import cn.iaimi.openaisdk.aisender.impl.ExchangerImpl;
import cn.iaimi.openaisdk.aisender.impl.SenderImpl;
import cn.iaimi.openaisdk.api.OpenAiApi;
import cn.iaimi.openaisdk.model.dto.ai.ConfigInfo;
import javax.annotation.Resource;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(value="chatai.open-ai")
@ComponentScan
public class OpenAiSdkConfig {
    private String openAiApiKey;
    private String url = "https://api.openai.com/v1/chat/completions";
    private String proxyHost;
    private Integer proxyPort;
    private String model = "gpt-3.5-turbo";
    private int msgMaxSize = 20;
    @Resource
    private OpenAiApi openAiApi;

    @Bean
    public Sender openAiSender() {
        return new SenderImpl(this.getConfigInfo(), this.openAiApi);
    }

    @Bean
    public Exchanger openAiExchanger() {
        return new ExchangerImpl(this.msgMaxSize, this.getConfigInfo());
    }

    private ConfigInfo getConfigInfo() {
        return new ConfigInfo(this.openAiApiKey, this.url, this.proxyHost, this.proxyPort, this.model);
    }

    public String getOpenAiApiKey() {
        return this.openAiApiKey;
    }

    public String getUrl() {
        return this.url;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public String getModel() {
        return this.model;
    }

    public int getMsgMaxSize() {
        return this.msgMaxSize;
    }

    public OpenAiApi getOpenAiApi() {
        return this.openAiApi;
    }

    public void setOpenAiApiKey(String openAiApiKey) {
        this.openAiApiKey = openAiApiKey;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setMsgMaxSize(int msgMaxSize) {
        this.msgMaxSize = msgMaxSize;
    }

    public void setOpenAiApi(OpenAiApi openAiApi) {
        this.openAiApi = openAiApi;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenAiSdkConfig)) {
            return false;
        }
        OpenAiSdkConfig other = (OpenAiSdkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMsgMaxSize() != other.getMsgMaxSize()) {
            return false;
        }
        Integer this$proxyPort = this.getProxyPort();
        Integer other$proxyPort = other.getProxyPort();
        if (this$proxyPort == null ? other$proxyPort != null : !((Object)this$proxyPort).equals(other$proxyPort)) {
            return false;
        }
        String this$openAiApiKey = this.getOpenAiApiKey();
        String other$openAiApiKey = other.getOpenAiApiKey();
        if (this$openAiApiKey == null ? other$openAiApiKey != null : !this$openAiApiKey.equals(other$openAiApiKey)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$proxyHost = this.getProxyHost();
        String other$proxyHost = other.getProxyHost();
        if (this$proxyHost == null ? other$proxyHost != null : !this$proxyHost.equals(other$proxyHost)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        OpenAiApi this$openAiApi = this.getOpenAiApi();
        OpenAiApi other$openAiApi = other.getOpenAiApi();
        return !(this$openAiApi == null ? other$openAiApi != null : !this$openAiApi.equals(other$openAiApi));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenAiSdkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMsgMaxSize();
        Integer $proxyPort = this.getProxyPort();
        result = result * 59 + ($proxyPort == null ? 43 : ((Object)$proxyPort).hashCode());
        String $openAiApiKey = this.getOpenAiApiKey();
        result = result * 59 + ($openAiApiKey == null ? 43 : $openAiApiKey.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $proxyHost = this.getProxyHost();
        result = result * 59 + ($proxyHost == null ? 43 : $proxyHost.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        OpenAiApi $openAiApi = this.getOpenAiApi();
        result = result * 59 + ($openAiApi == null ? 43 : $openAiApi.hashCode());
        return result;
    }

    public String toString() {
        return "OpenAiSdkConfig(openAiApiKey=" + this.getOpenAiApiKey() + ", url=" + this.getUrl() + ", proxyHost=" + this.getProxyHost() + ", proxyPort=" + this.getProxyPort() + ", model=" + this.getModel() + ", msgMaxSize=" + this.getMsgMaxSize() + ", openAiApi=" + this.getOpenAiApi() + ")";
    }
}

