/*
 * Decompiled with CFR 0.152.
 */
package cn.iaimi.openaisdk.aisender.alibaba.impl;

import cn.iaimi.openaisdk.AliChatAiSdkConfig;
import cn.iaimi.openaisdk.aisender.alibaba.ChatClient;
import cn.iaimi.openaisdk.common.BaseResData;
import cn.iaimi.openaisdk.common.ErrorCode;
import cn.iaimi.openaisdk.exception.BusinessException;
import cn.iaimi.openaisdk.manager.MsgManager;
import cn.iaimi.openaisdk.model.enums.ModelType;
import com.alibaba.dashscope.aigc.generation.Generation;
import com.alibaba.dashscope.aigc.generation.GenerationParam;
import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.generation.GenerationUsage;
import com.alibaba.dashscope.aigc.generation.models.QwenParam;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.common.Message;
import com.alibaba.dashscope.common.Role;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.utils.Constants;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

public class ChatClientImpl
implements ChatClient {
    protected Generation gen;
    protected MsgManager msgManager;
    protected static Map<String, ModelType> modelMap = new HashMap<String, ModelType>();
    protected int maxMsgSize;
    @Resource
    private AliChatAiSdkConfig aliChatAiSdkConfig;

    @Override
    public ChatClient setPresets(String systemMsg) {
        if (null != systemMsg) {
            Message msg = Message.builder().role(Role.SYSTEM.getValue()).content(systemMsg).build();
            this.msgManager.add(msg);
        }
        return this;
    }

    @Override
    public void add(String userMsg) {
        if (null != userMsg) {
            Message msg = Message.builder().role(Role.USER.getValue()).content(userMsg).build();
            this.msgManager.add(msg);
        }
    }

    @Override
    public ChatClient createClient(boolean isHistory) {
        Constants.apiKey = this.aliChatAiSdkConfig.getApiKey();
        this.gen = new Generation();
        if (isHistory) {
            // empty if block
        }
        this.msgManager = new MsgManager(this.aliChatAiSdkConfig.getMsgMaxSize());
        return this;
    }

    @Override
    public BaseResData<Message, GenerationUsage> chat(String message) {
        return this.doChat(message, null, false);
    }

    @Override
    public BaseResData<List<Message>, GenerationUsage> chat(List<Message> messages) {
        return this.doChat(messages);
    }

    @Override
    public BaseResData<Message, GenerationUsage> chatPresets(String message, String systemSets) {
        return this.doChat(message, systemSets, false);
    }

    @Override
    public List<Message> addPresets(List<Message> messages, String systemSet) {
        Message systemMsg = Message.builder().role(Role.SYSTEM.getValue()).content(systemSet).build();
        messages.add(systemMsg);
        return messages;
    }

    @Override
    public List<Message> addUser(List<Message> messages, String userMsg) {
        Message msg = Message.builder().role(Role.USER.getValue()).content(userMsg).build();
        messages.add(msg);
        return messages;
    }

    public BaseResData<Message, GenerationUsage> doChat(String message, String systemSets, boolean isHistory) {
        if (null != systemSets) {
            Message systemMsg = Message.builder().role(Role.SYSTEM.getValue()).content(systemSets).build();
            this.msgManager.add(systemMsg);
        }
        Message msg = Message.builder().role(Role.USER.getValue()).content(message).build();
        this.msgManager.add(msg);
        QwenParam param = ((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)QwenParam.builder().model(modelMap.getOrDefault(this.aliChatAiSdkConfig.getUseModel(), ModelType.QWEN_MAX).getValue())).messages(this.msgManager.get())).resultFormat(GenerationParam.ResultFormat.MESSAGE)).topP(this.aliChatAiSdkConfig.getTopP())).enableSearch(this.aliChatAiSdkConfig.getEnableSearch())).build();
        try {
            GenerationResult result = this.gen.call((HalfDuplexServiceParam)param);
            this.msgManager.add(result);
            Message msgByRes = this.msgManager.getMsgByRes(result);
            BaseResData<Message, GenerationUsage> baseResData = new BaseResData<Message, GenerationUsage>(msgByRes, result.getUsage());
            return baseResData;
        }
        catch (NoApiKeyException e) {
            throw new BusinessException(ErrorCode.NO_API_KEY, e.getMessage());
        }
        catch (InputRequiredException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (!isHistory) {
                this.msgManager.clearMsg();
            }
        }
    }

    private BaseResData<List<Message>, GenerationUsage> doChat(List<Message> messages) {
        QwenParam param = ((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)QwenParam.builder().model(modelMap.getOrDefault(this.aliChatAiSdkConfig.getUseModel(), ModelType.QWEN_MAX).getValue())).messages(messages)).resultFormat(GenerationParam.ResultFormat.MESSAGE)).topP(this.aliChatAiSdkConfig.getTopP())).enableSearch(this.aliChatAiSdkConfig.getEnableSearch())).build();
        try {
            GenerationResult result = this.gen.call((HalfDuplexServiceParam)param);
            this.msgManager.add(result);
            Message msgByRes = this.msgManager.getMsgByRes(result);
            messages.add(msgByRes);
            return new BaseResData<List<Message>, GenerationUsage>(messages, result.getUsage());
        }
        catch (NoApiKeyException e) {
            throw new BusinessException(ErrorCode.NO_API_KEY, e.getMessage());
        }
        catch (InputRequiredException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        modelMap.put("qwen-v1", ModelType.QWEN_V1);
        modelMap.put("qwen-turbo", ModelType.QWEN_TURBO);
        modelMap.put("bailian-v1", ModelType.BAILIAN_V1);
        modelMap.put("dolly-12b-v2", ModelType.DOLLY_12B_V2);
        modelMap.put("qwen-plus", ModelType.QWEN_PLUS);
        modelMap.put("qwen-max", ModelType.QWEN_MAX);
    }
}

