/*
 * Decompiled with CFR 0.152.
 */
package cn.iaimi.openaisdk.aisender.openai.impl;

import cn.iaimi.openaisdk.aisender.openai.Exchanger;
import cn.iaimi.openaisdk.api.OpenAiApi;
import cn.iaimi.openaisdk.common.BaseResData;
import cn.iaimi.openaisdk.common.BaseResponse;
import cn.iaimi.openaisdk.common.ErrorCode;
import cn.iaimi.openaisdk.exception.BusinessException;
import cn.iaimi.openaisdk.model.dto.ai.ConfigInfo;
import cn.iaimi.openaisdk.model.dto.ai.CreateChatCompletionRequest;
import cn.iaimi.openaisdk.model.dto.ai.CreateChatCompletionResponse;
import cn.iaimi.openaisdk.model.dto.ai.Message;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;

public class ExchangerImpl
implements Exchanger {
    private Deque<Message> msgDeque;
    private int maxMsgSize;
    private ConfigInfo configInfo;
    private Message preSetMsg;
    @Resource
    private OpenAiApi openAiApi;

    public ExchangerImpl(int maxMsgSize, ConfigInfo configInfo) {
        this.msgDeque = new LinkedList<Message>();
        this.maxMsgSize = maxMsgSize;
        this.configInfo = configInfo;
    }

    public ExchangerImpl(int maxMsgSize, ConfigInfo configInfo, OpenAiApi openAiApi) {
        this.msgDeque = new LinkedList<Message>();
        this.maxMsgSize = maxMsgSize;
        this.configInfo = configInfo;
        this.openAiApi = openAiApi;
    }

    @Override
    public BaseResData<Message, CreateChatCompletionResponse.UsageBean> chat(String message) {
        if (this.preSetMsg != null) {
            this.msgDeque.addFirst(this.preSetMsg);
        }
        this.msgDeque.addLast(new Message("user", message));
        BaseResponse<CreateChatCompletionResponse> response = this.doChat();
        if (this.preSetMsg != null) {
            this.msgDeque.removeFirst();
        }
        List<CreateChatCompletionResponse.ChoicesBean> choices = response.getData().getChoices();
        CreateChatCompletionResponse.ChoicesBean.MessageBean replyMsg = choices.get(choices.size() - 1).getMessage();
        return new BaseResData<Message, CreateChatCompletionResponse.UsageBean>(replyMsg, response.getData().getUsage());
    }

    @Override
    public BaseResData<Message, CreateChatCompletionResponse.UsageBean> chat() {
        BaseResponse<CreateChatCompletionResponse> response = this.doChat();
        List<CreateChatCompletionResponse.ChoicesBean> choices = response.getData().getChoices();
        CreateChatCompletionResponse.ChoicesBean.MessageBean replyMsg = choices.get(choices.size() - 1).getMessage();
        Message message = new Message(replyMsg.getRole(), replyMsg.getContent());
        return new BaseResData<Message, CreateChatCompletionResponse.UsageBean>(message, response.getData().getUsage());
    }

    private BaseResponse<CreateChatCompletionResponse> doChat() {
        if (this.msgDeque.size() == 0) {
            throw new BusinessException(ErrorCode.OPERATION_ERROR, "\u6d88\u606f\u5217\u8868\u4e3a\u7a7a");
        }
        CreateChatCompletionRequest request = new CreateChatCompletionRequest();
        request.setMessages(new ArrayList<Message>(this.msgDeque));
        BaseResponse<CreateChatCompletionResponse> response = this.openAiApi.createChatCompletion(request, this.configInfo);
        if (response.getCode() != 0) {
            throw new BusinessException(ErrorCode.CHAT_ERROR, response.getMessage());
        }
        List<CreateChatCompletionResponse.ChoicesBean> choices = response.getData().getChoices();
        this.msgDeque.addLast(choices.get(choices.size() - 1).getMessage());
        while (this.msgDeque.size() > this.maxMsgSize) {
            this.removeFirstMsgs(2);
        }
        return response;
    }

    @Override
    public List<Message> getMsgs() {
        return new ArrayList<Message>(this.msgDeque);
    }

    @Override
    public void setMsgs(List<Message> msgs) {
        this.msgDeque = new ArrayDeque<Message>(msgs.size());
        msgs.forEach(msg -> this.msgDeque.offerLast((Message)msg));
    }

    @Override
    public Message getLastAnswer() {
        return this.msgDeque.isEmpty() ? null : this.msgDeque.getLast();
    }

    @Override
    public boolean removeLastMsgs(int itemNums) {
        boolean flag = true;
        while (itemNums-- > 0) {
            if (this.msgDeque.isEmpty()) {
                flag = false;
                break;
            }
            this.msgDeque.removeLast();
        }
        return flag;
    }

    @Override
    public boolean removeFirstMsgs(int itemNums) {
        boolean flag = true;
        while (itemNums-- > 0) {
            if (this.msgDeque.isEmpty()) {
                flag = false;
                break;
            }
            this.msgDeque.removeFirst();
        }
        return flag;
    }

    @Override
    public void clearMsg() {
        this.msgDeque.clear();
    }

    @Override
    public void setPreSetMsg(String preSetMsg) {
        this.preSetMsg = new Message("system", preSetMsg);
    }

    @Override
    public void addFirstMsg(String msg) {
        this.msgDeque.offerFirst(new Message("user", msg));
    }

    @Override
    public void addLastMsg(String msg) {
        this.msgDeque.offerLast(new Message("user", msg));
    }

    @Override
    public void clearPreSet() {
        this.preSetMsg = null;
    }

    @Override
    public void setMaxMsgSize(int maxMsgSize) {
        this.maxMsgSize = maxMsgSize;
    }

    public ExchangerImpl() {
    }
}

