/*
 * Decompiled with CFR 0.152.
 */
package cn.iaimi.openaisdk.aisender.openai.impl;

import cn.iaimi.openaisdk.aisender.openai.Sender;
import cn.iaimi.openaisdk.api.OpenAiApi;
import cn.iaimi.openaisdk.common.BaseResData;
import cn.iaimi.openaisdk.common.BaseResponse;
import cn.iaimi.openaisdk.common.ErrorCode;
import cn.iaimi.openaisdk.exception.BusinessException;
import cn.iaimi.openaisdk.model.dto.ai.ConfigInfo;
import cn.iaimi.openaisdk.model.dto.ai.CreateChatCompletionRequest;
import cn.iaimi.openaisdk.model.dto.ai.CreateChatCompletionResponse;
import cn.iaimi.openaisdk.model.dto.ai.Message;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Resource;

public class SenderImpl
implements Sender {
    private ConfigInfo configInfo;
    @Resource
    private OpenAiApi openAiApi;

    @Override
    public BaseResData<Message, CreateChatCompletionResponse.UsageBean> chat(String message) {
        CreateChatCompletionRequest request = new CreateChatCompletionRequest();
        request.setMessages(Arrays.asList(new Message("user", message)));
        BaseResponse<CreateChatCompletionResponse> chatCompletion = this.openAiApi.createChatCompletion(request, this.configInfo);
        if (chatCompletion.getCode() != 0) {
            throw new BusinessException(ErrorCode.CHAT_ERROR, chatCompletion.getMessage());
        }
        CreateChatCompletionResponse completionData = chatCompletion.getData();
        CreateChatCompletionResponse.ChoicesBean.MessageBean messageBean = completionData.getChoices().get(0).getMessage();
        CreateChatCompletionResponse.UsageBean usageBean = completionData.getUsage();
        return new BaseResData<Message, CreateChatCompletionResponse.UsageBean>(messageBean, usageBean);
    }

    @Override
    public BaseResData<Message, CreateChatCompletionResponse.UsageBean> chatPresets(String message, String systemSets) {
        ArrayList<Message> messageList = new ArrayList<Message>();
        messageList.add(new Message("system", systemSets));
        messageList.add(new Message("user", message));
        CreateChatCompletionRequest request = new CreateChatCompletionRequest();
        request.setMessages(messageList);
        BaseResponse<CreateChatCompletionResponse> chatCompletion = this.openAiApi.createChatCompletion(request, this.configInfo);
        if (chatCompletion.getCode() != 0) {
            throw new BusinessException(ErrorCode.CHAT_ERROR, chatCompletion.getMessage());
        }
        CreateChatCompletionResponse completionData = chatCompletion.getData();
        CreateChatCompletionResponse.ChoicesBean.MessageBean messageBean = completionData.getChoices().get(0).getMessage();
        CreateChatCompletionResponse.UsageBean usageBean = completionData.getUsage();
        return new BaseResData<Message, CreateChatCompletionResponse.UsageBean>(messageBean, usageBean);
    }

    public SenderImpl() {
    }

    public SenderImpl(ConfigInfo configInfo, OpenAiApi openAiApi) {
        this.configInfo = configInfo;
        this.openAiApi = openAiApi;
    }
}

