/*
 * Decompiled with CFR 0.152.
 */
package cn.iaimi.openaisdk.model.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public enum ModelType {
    QWEN_V1("qwen-v1", "qwen-v1"),
    QWEN_TURBO("\u901a\u4e49\u5343\u95ee-Turbo", "qwen-turbo"),
    BAILIAN_V1("\u767e\u70bc-v1", "bailian-v1"),
    DOLLY_12B_V2("dolly-12b-v2", "dolly-12b-v2"),
    QWEN_PLUS_V1("\u901a\u4e49\u5343\u95ee-plus-v1", "qwen-plus-v1"),
    QWEN_PLUS("\u901a\u4e49\u5343\u95ee-Plus", "qwen-plus"),
    QWEN_MAX("\u901a\u4e49\u5343\u95ee-Max", "qwen-max");

    private final String name;
    private final String value;

    private ModelType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static List<String> getValues() {
        return Arrays.stream(ModelType.values()).map(item -> item.value).collect(Collectors.toList());
    }

    public static ModelType getEnumByValue(String value) {
        if (ObjectUtils.isEmpty((Object)value)) {
            return null;
        }
        for (ModelType anEnum : ModelType.values()) {
            if (!anEnum.value.equals(value)) continue;
            return anEnum;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }
}

