/*
 * Decompiled with CFR 0.152.
 */
package cn.iaimi.openaisdk.aisender.alibaba.impl;

import cn.iaimi.openaisdk.aisender.alibaba.ChatRecordClient;
import cn.iaimi.openaisdk.aisender.alibaba.impl.ChatClientImpl;
import cn.iaimi.openaisdk.common.ErrorCode;
import cn.iaimi.openaisdk.exception.BusinessException;
import com.aliyun.broadscope.bailian.sdk.models.CompletionsRequest;
import com.aliyun.broadscope.bailian.sdk.models.CompletionsResponse;
import java.util.ArrayList;
import java.util.List;

public class ChatClientContinuousImpl
extends ChatClientImpl
implements ChatRecordClient {
    @Override
    public ChatRecordClient createClient(boolean isHistory) {
        return (ChatRecordClient)super.createClient(isHistory);
    }

    @Override
    public String chat(String message) {
        this.request = this.request.setPrompt(message).setHistory(new ArrayList());
        CompletionsResponse response = this.client.completions(this.request);
        if (!response.isSuccess().booleanValue()) {
            String error = "completions Error requestId: " + response.getRequestId() + " code: " + response.getCode() + " msg: " + response.getMessage();
            throw new BusinessException(ErrorCode.CHAT_ERROR, error);
        }
        String botAnswer = response.getData().getText();
        this.history.addLast(new CompletionsRequest.ChatQaPair(message, botAnswer));
        while (this.history.size() > this.maxMsgSize) {
            this.history.removeFirst();
        }
        return botAnswer;
    }

    @Override
    public List<CompletionsRequest.ChatQaPair> getMsgs() {
        return new ArrayList<CompletionsRequest.ChatQaPair>(this.history);
    }

    @Override
    public CompletionsRequest.ChatQaPair getLastAnswer() {
        return (CompletionsRequest.ChatQaPair)this.history.getLast();
    }

    @Override
    public boolean removeLastMsgs(int itemNums) {
        boolean flag = true;
        while (itemNums-- > 0) {
            if (this.history.isEmpty()) {
                flag = false;
                break;
            }
            this.history.removeLast();
        }
        return flag;
    }

    @Override
    public boolean removeFirstMsgs(int itemNums) {
        boolean flag = true;
        while (itemNums-- > 0) {
            if (this.history.isEmpty()) {
                flag = false;
                break;
            }
            this.history.removeFirst();
        }
        return flag;
    }

    @Override
    public void clearMsg() {
        this.history.clear();
    }
}

