/*
 * Decompiled with CFR 0.152.
 */
package cn.iaimi.openaisdk.aisender.alibaba.impl;

import cn.hutool.core.util.IdUtil;
import cn.iaimi.openaisdk.AliChatAiSdkConfig;
import cn.iaimi.openaisdk.aisender.alibaba.ChatClient;
import cn.iaimi.openaisdk.common.ErrorCode;
import cn.iaimi.openaisdk.exception.BusinessException;
import com.aliyun.broadscope.bailian.sdk.AccessTokenClient;
import com.aliyun.broadscope.bailian.sdk.ApplicationClient;
import com.aliyun.broadscope.bailian.sdk.models.CompletionsRequest;
import com.aliyun.broadscope.bailian.sdk.models.CompletionsResponse;
import java.util.Deque;
import java.util.LinkedList;
import javax.annotation.Resource;

public class ChatClientImpl
implements ChatClient {
    protected ApplicationClient client;
    protected CompletionsRequest request;
    protected int maxMsgSize;
    protected Deque<CompletionsRequest.ChatQaPair> history;
    @Resource
    private AliChatAiSdkConfig aliChatAiSdkConfig;
    @Resource
    private AccessTokenClient accessTokenClient;

    @Override
    public ChatClient createClient(boolean isHistory) {
        this.client = ApplicationClient.builder().token(this.accessTokenClient.getToken()).build();
        this.request = new CompletionsRequest().setAppId(this.aliChatAiSdkConfig.getAppId());
        if (isHistory) {
            this.request = this.request.setSessionId(IdUtil.simpleUUID());
            this.history = new LinkedList<CompletionsRequest.ChatQaPair>();
            this.maxMsgSize = this.aliChatAiSdkConfig.getMsgMaxSize();
        }
        return this;
    }

    @Override
    public String chat(String message) {
        this.request = this.request.setPrompt(message);
        CompletionsResponse response = this.client.completions(this.request);
        if (!response.isSuccess().booleanValue()) {
            String error = "completions Error requestId: " + response.getRequestId() + " code: " + response.getCode() + " msg: " + response.getMessage();
            throw new BusinessException(ErrorCode.CHAT_ERROR, error);
        }
        return response.getData().getText();
    }
}

