/*
 * Decompiled with CFR 0.152.
 */
package cn.iaimi.openaisdk.api;

import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONUtil;
import cn.iaimi.openaisdk.common.BaseResponse;
import cn.iaimi.openaisdk.common.ErrorCode;
import cn.iaimi.openaisdk.common.ResultUtils;
import cn.iaimi.openaisdk.common.ThrowUtils;
import cn.iaimi.openaisdk.model.dto.ai.ConfigInfo;
import cn.iaimi.openaisdk.model.dto.ai.CreateChatCompletionRequest;
import cn.iaimi.openaisdk.model.dto.ai.CreateChatCompletionResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class OpenAiApi {
    public BaseResponse<CreateChatCompletionResponse> createChatCompletion(CreateChatCompletionRequest request, ConfigInfo configInfo) {
        String openAiApiKey = configInfo.getOpenAiApiKey();
        String url = configInfo.getUrl();
        String proxyHost = configInfo.getProxyHost();
        Integer proxyPort = configInfo.getProxyPort();
        String model = configInfo.getAiModel();
        request.setModel(model);
        ThrowUtils.throwIf(StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{openAiApiKey, url}), ErrorCode.PARAMS_ERROR);
        ThrowUtils.throwIf(proxyPort == null, ErrorCode.PARAMS_ERROR);
        CreateChatCompletionResponse response = OpenAiApi.getResponse(request, url, proxyHost, proxyPort, openAiApiKey);
        if (response.getError() != null) {
            return ResultUtils.error(ErrorCode.CHAT_ERROR, response.getError().getCode());
        }
        return ResultUtils.success(response);
    }

    private static CreateChatCompletionResponse getResponse(CreateChatCompletionRequest request, String url, String proxyHost, Integer proxyPort, String openAiApiKey) {
        String result = null;
        String json = JSONUtil.toJsonStr((Object)request);
        result = proxyHost == null || proxyPort == null ? ((HttpRequest)HttpRequest.post((String)url).header("Authorization", "Bearer " + openAiApiKey)).body(json).execute().body() : ((HttpRequest)HttpRequest.post((String)url).setHttpProxy(proxyHost, proxyPort.intValue()).header("Authorization", "Bearer " + openAiApiKey)).body(json).execute().body();
        return (CreateChatCompletionResponse)JSONUtil.toBean((String)result, CreateChatCompletionResponse.class);
    }
}

