/*
 * Decompiled with CFR 0.152.
 */
package cn.iaimi.clov614.cloverapisdk.client;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import cn.iaimi.clov614.cloverapisdk.model.User;
import cn.iaimi.clov614.cloverapisdk.utils.SignUtils;
import java.util.HashMap;
import java.util.Map;

public class CloverApiClient {
    private String accessKey;
    private String secretKey;
    private String serverUrl;

    public CloverApiClient(String accessKey, String secretKey, String serverUrl) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.serverUrl = serverUrl;
    }

    private Map<String, String> getHeaderMap(String body) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("accessKey", this.accessKey);
        hashMap.put("nonce", RandomUtil.randomNumbers((int)4));
        hashMap.put("body", body);
        hashMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        hashMap.put("sign", SignUtils.genSign(body, this.secretKey));
        return hashMap;
    }

    public String getNameByGet(String name) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("name", name);
        String result = HttpUtil.get((String)(this.serverUrl + "/api/name/"), paramMap);
        System.out.println(result);
        return result;
    }

    public String getNameByPost(String name) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("name", name);
        String result = HttpUtil.post((String)(this.serverUrl + "/api/name/"), paramMap);
        System.out.println(result);
        return result;
    }

    public String getUserNameByPost(User user) {
        String json = JSONUtil.toJsonStr((Object)user);
        HttpResponse httpResponse = ((HttpRequest)HttpRequest.post((String)(this.serverUrl + "/api/name/user")).addHeaders(this.getHeaderMap(json))).body(json).execute();
        System.out.println(httpResponse.getStatus());
        String result = httpResponse.body();
        System.out.println(result);
        return result;
    }
}

