/*
 * Decompiled with CFR 0.152.
 */
package cn.isliu.core.client;

import cn.isliu.core.client.FeishuClient;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.lark.oapi.core.utils.Jsons;
import java.io.IOException;
import java.util.HashMap;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class FeishuApiClient {
    protected final FeishuClient feishuClient;
    protected final OkHttpClient httpClient;
    protected final Gson gson;
    protected static final String BASE_URL = "https://open.feishu.cn/open-apis";
    protected static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");

    public FeishuApiClient(FeishuClient feishuClient) {
        this.feishuClient = feishuClient;
        this.httpClient = feishuClient.getHttpClient();
        this.gson = Jsons.DEFAULT;
    }

    protected String getTenantAccessToken() throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", this.feishuClient.getAppId());
        params.put("app_secret", this.feishuClient.getAppSecret());
        RequestBody body = RequestBody.create((String)this.gson.toJson(params), (MediaType)JSON_MEDIA_TYPE);
        Request request = new Request.Builder().url("https://open.feishu.cn/open-apis/auth/v3/tenant_access_token/internal").post(body).build();
        Throwable throwable = null;
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful() || response.body() == null) {
                throw new IOException("Failed to get tenant access token: " + response);
            }
            JsonObject jsonResponse = (JsonObject)this.gson.fromJson(response.body().string(), JsonObject.class);
            if (jsonResponse.has("tenant_access_token")) {
                String string = jsonResponse.get("tenant_access_token").getAsString();
                return string;
            }
            try {
                throw new IOException("Invalid token response: " + jsonResponse);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected Request.Builder createAuthenticatedRequest(String url, String method, RequestBody body) throws IOException {
        String token = this.getTenantAccessToken();
        return new Request.Builder().url(url).header("Authorization", "Bearer " + token).header("Content-Type", "application/json; charset=utf-8").method(method, body);
    }

    protected <T> T executeRequest(Request request, Class<T> responseClass) throws IOException {
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful() || response.body() == null) {
                throw new IOException("Request failed: " + response);
            }
            String responseBody = response.body().string();
            Object object = this.gson.fromJson(responseBody, responseClass);
            return (T)object;
        }
    }
}

