/*
 * Decompiled with CFR 0.152.
 */
package cn.isliu.core.client;

import cn.isliu.core.service.CustomCellService;
import cn.isliu.core.service.CustomDataValidationService;
import cn.isliu.core.service.CustomDimensionService;
import cn.isliu.core.service.CustomProtectedDimensionService;
import cn.isliu.core.service.CustomSheetService;
import cn.isliu.core.service.CustomValueService;
import com.lark.oapi.Client;
import com.lark.oapi.core.enums.AppType;
import com.lark.oapi.service.drive.DriveService;
import com.lark.oapi.service.sheets.SheetsService;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;

public class FeishuClient {
    private final Client officialClient;
    private final OkHttpClient httpClient;
    private final String appId;
    private final String appSecret;
    private volatile CustomSheetService customSheetService;
    private volatile CustomDimensionService customDimensionService;
    private volatile CustomCellService customCellService;
    private volatile CustomValueService customValueService;
    private volatile CustomDataValidationService customDataValidationService;
    private volatile CustomProtectedDimensionService customProtectedDimensionService;

    private FeishuClient(String appId, String appSecret, Client officialClient, OkHttpClient httpClient) {
        this.appId = appId;
        this.appSecret = appSecret;
        this.officialClient = officialClient;
        this.httpClient = httpClient;
    }

    public static Builder newBuilder(String appId, String appSecret) {
        return new Builder(appId, appSecret);
    }

    public SheetsService sheets() {
        return this.officialClient.sheets();
    }

    public DriveService drive() {
        return this.officialClient.drive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomSheetService customSheets() {
        if (this.customSheetService == null) {
            FeishuClient feishuClient = this;
            synchronized (feishuClient) {
                if (this.customSheetService == null) {
                    this.customSheetService = new CustomSheetService(this);
                }
            }
        }
        return this.customSheetService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomDimensionService customDimensions() {
        if (this.customDimensionService == null) {
            FeishuClient feishuClient = this;
            synchronized (feishuClient) {
                if (this.customDimensionService == null) {
                    this.customDimensionService = new CustomDimensionService(this);
                }
            }
        }
        return this.customDimensionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomCellService customCells() {
        if (this.customCellService == null) {
            FeishuClient feishuClient = this;
            synchronized (feishuClient) {
                if (this.customCellService == null) {
                    this.customCellService = new CustomCellService(this);
                }
            }
        }
        return this.customCellService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomValueService customValues() {
        if (this.customValueService == null) {
            FeishuClient feishuClient = this;
            synchronized (feishuClient) {
                if (this.customValueService == null) {
                    this.customValueService = new CustomValueService(this);
                }
            }
        }
        return this.customValueService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomDataValidationService customDataValidations() {
        if (this.customDataValidationService == null) {
            FeishuClient feishuClient = this;
            synchronized (feishuClient) {
                if (this.customDataValidationService == null) {
                    this.customDataValidationService = new CustomDataValidationService(this);
                }
            }
        }
        return this.customDataValidationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomProtectedDimensionService customProtectedDimensions() {
        if (this.customProtectedDimensionService == null) {
            FeishuClient feishuClient = this;
            synchronized (feishuClient) {
                if (this.customProtectedDimensionService == null) {
                    this.customProtectedDimensionService = new CustomProtectedDimensionService(this);
                }
            }
        }
        return this.customProtectedDimensionService;
    }

    public Client getOfficialClient() {
        return this.officialClient;
    }

    OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public static class Builder {
        private final String appId;
        private final String appSecret;
        private OkHttpClient.Builder httpClientBuilder;
        private AppType appType = AppType.SELF_BUILT;
        private boolean logReqAtDebug = false;

        private Builder(String appId, String appSecret) {
            this.appId = appId;
            this.appSecret = appSecret;
            this.httpClientBuilder = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.MINUTES).readTimeout(10L, TimeUnit.MINUTES).writeTimeout(10L, TimeUnit.MINUTES).connectionPool(new ConnectionPool(5, 5L, TimeUnit.MINUTES));
        }

        public Builder httpClient(OkHttpClient.Builder builder) {
            this.httpClientBuilder = builder;
            return this;
        }

        public Builder appType(AppType appType) {
            this.appType = appType;
            return this;
        }

        public Builder logReqAtDebug(boolean logReqAtDebug) {
            this.logReqAtDebug = logReqAtDebug;
            return this;
        }

        public FeishuClient build() {
            Client officialClient = Client.newBuilder((String)this.appId, (String)this.appSecret).appType(this.appType).logReqAtDebug(this.logReqAtDebug).build();
            OkHttpClient httpClient = this.httpClientBuilder.build();
            return new FeishuClient(this.appId, this.appSecret, officialClient, httpClient);
        }
    }
}

