/*
 * Decompiled with CFR 0.152.
 */
package cn.isliu.core.converters;

import cn.isliu.core.converters.FieldValueProcess;
import cn.isliu.core.utils.FileUtil;
import cn.isliu.core.utils.FsApiUtil;
import cn.isliu.core.utils.FsClientUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileUrlProcess
implements FieldValueProcess<String> {
    private static final Logger log = Logger.getLogger(FileUrlProcess.class.getName());

    @Override
    public String process(Object value) {
        if (value instanceof String) {
            return value.toString();
        }
        ArrayList<String> fileUrls = new ArrayList<String>();
        if (value instanceof JsonArray) {
            JsonArray arr = (JsonArray)value;
            for (int i = 0; i < arr.size(); ++i) {
                JsonElement jsonElement = arr.get(i);
                if (!jsonElement.isJsonObject()) continue;
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                String url = this.getUrlByTextFile(jsonObject);
                fileUrls.add(url);
            }
        } else if (value instanceof JsonObject) {
            JsonObject jsb = (JsonObject)value;
            String url = this.getUrlByTextFile(jsb);
            fileUrls.add(url);
        }
        return String.join((CharSequence)",", fileUrls);
    }

    @Override
    public String reverseProcess(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private synchronized String getUrlByTextFile(JsonObject jsb) {
        String cellType;
        String url = "";
        switch (cellType = jsb.get("type").getAsString()) {
            case "url": {
                String link = jsb.get("link").getAsString();
                if (link == null) {
                    url = jsb.get("text").getAsString();
                    break;
                }
                url = link;
                break;
            }
            case "embed-image": {
                url = FileUrlProcess.getImageOssUrl(jsb);
                break;
            }
            case "attachment": {
                url = this.getAttachmentOssUrl(jsb);
            }
        }
        return url;
    }

    public static String getImageOssUrl(JsonObject jsb) {
        String url = "";
        String fileToken = jsb.get("fileToken").getAsString();
        String fileUuid = UUID.randomUUID().toString();
        String filePath = FileUtil.getRootPath() + File.separator + fileUuid + ".png";
        boolean isSuccess = true;
        try {
            FsApiUtil.downloadMaterial(fileToken, filePath, FsClientUtil.getFeishuClient(), null);
            url = filePath;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u6839\u636e\u6587\u4ef6FileToken\u4e0b\u8f7d\u5931\u8d25\uff01fileToken: {0}, e: {1}", new Object[]{fileToken, e.getMessage()});
            isSuccess = false;
        }
        if (!isSuccess) {
            String tmpUrl = FsApiUtil.downloadTmpMaterialUrl(fileToken, FsClientUtil.getFeishuClient());
            FileUtil.downloadFile(tmpUrl, filePath);
        }
        log.info("\u3010\u98de\u4e66\u8868\u683c\u3011 \u6587\u4ef6\u4e0a\u4f20-\u98de\u4e66\u56fe\u7247\u4e0a\u4f20\u6210\u529f\uff01fileToken: " + fileToken + ", filePath: " + filePath);
        return url;
    }

    public String getAttachmentOssUrl(JsonObject jsb) {
        String url = "";
        String token = jsb.get("fileToken").getAsString();
        String fileName = jsb.get("text").getAsString();
        String fileUuid = UUID.randomUUID().toString();
        String path = FileUtil.getRootPath() + File.separator + fileUuid + fileName;
        boolean isSuccess = true;
        try {
            FsApiUtil.downloadMaterial(token, path, FsClientUtil.getFeishuClient(), null);
            url = path;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u9644\u4ef6-\u6839\u636e\u6587\u4ef6FileToken\u4e0b\u8f7d\u5931\u8d25\uff01fileToken: {0}, e: {1}", new Object[]{token, e.getMessage()});
            isSuccess = false;
        }
        if (!isSuccess) {
            String tmpUrl = FsApiUtil.downloadTmpMaterialUrl(token, FsClientUtil.getFeishuClient());
            FileUtil.downloadFile(tmpUrl, path);
        }
        log.info("\u3010\u98de\u4e66\u8868\u683c\u3011 \u6587\u4ef6\u4e0a\u4f20-\u9644\u4ef6\u4e0a\u4f20\u6210\u529f\uff01fileToken: " + token + ", filePath: " + path);
        return url;
    }
}

