/*
 * Decompiled with CFR 0.152.
 */
package cn.isliu.core.service;

import cn.isliu.core.client.FeishuApiClient;
import cn.isliu.core.client.FeishuClient;
import cn.isliu.core.pojo.ApiResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class CustomCellService
extends FeishuApiClient {
    public CustomCellService(FeishuClient feishuClient) {
        super(feishuClient);
    }

    public ApiResponse cellsBatchUpdate(String spreadsheetToken, CellBatchUpdateRequest request) throws IOException {
        List<CellRequest> requests = request.getRequests();
        ApiResponse response = null;
        if (requests == null || requests.isEmpty()) {
            ApiResponse emptyResponse = new ApiResponse();
            emptyResponse.setCode(400);
            emptyResponse.setMsg("No cell operations found");
            return emptyResponse;
        }
        for (CellRequest cellRequest : requests) {
            Request httpRequest;
            RequestBody body;
            ApiResponse errorResponse;
            String range;
            RequestBody body2;
            Request httpRequest2;
            String url;
            if (cellRequest.getMergeCells() != null) {
                String params;
                url = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/merge_cells";
                String type = cellRequest.getMergeCells().getType();
                if (type != null && !type.isEmpty() && "JSON_STR".equals(type)) {
                    params = cellRequest.getMergeCells().getParams();
                } else {
                    String range2 = cellRequest.getMergeCells().getRange();
                    if (range2 == null) {
                        ApiResponse errorResponse2 = new ApiResponse();
                        errorResponse2.setCode(400);
                        errorResponse2.setMsg("Invalid cell range");
                        return errorResponse2;
                    }
                    params = this.gson.toJson((Object)new MergeCellsRequestBody(range2, cellRequest.getMergeCells().getMergeType()));
                }
                if ((response = this.executeRequest(httpRequest2 = this.createAuthenticatedRequest(url, "POST", body2 = RequestBody.create((String)params, (MediaType)JSON_MEDIA_TYPE)).build(), ApiResponse.class)).success()) continue;
                return response;
            }
            if (cellRequest.getUnmergeCells() != null) {
                url = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/unmerge_cells";
                range = cellRequest.getUnmergeCells().getRange();
                if (range == null) {
                    errorResponse = new ApiResponse();
                    errorResponse.setCode(400);
                    errorResponse.setMsg("Invalid cell range");
                    return errorResponse;
                }
                body = RequestBody.create((String)this.gson.toJson((Object)new UnmergeCellsRequestBody(range)), (MediaType)JSON_MEDIA_TYPE);
                httpRequest = this.createAuthenticatedRequest(url, "POST", body).build();
                response = this.executeRequest(httpRequest, ApiResponse.class);
                if (response.success()) continue;
                return response;
            }
            if (cellRequest.getStyleCells() != null) {
                url = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/style";
                range = cellRequest.getStyleCells().getRange();
                if (range == null) {
                    errorResponse = new ApiResponse();
                    errorResponse.setCode(400);
                    errorResponse.setMsg("Invalid cell range");
                    return errorResponse;
                }
                body = RequestBody.create((String)this.gson.toJson((Object)new StyleCellsRequestBody(range, cellRequest.getStyleCells().getStyle())), (MediaType)JSON_MEDIA_TYPE);
                httpRequest = this.createAuthenticatedRequest(url, "PUT", body).build();
                response = this.executeRequest(httpRequest, ApiResponse.class);
                if (response.success()) continue;
                return response;
            }
            if (cellRequest.getStyleCellsBatch() == null) continue;
            url = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/styles_batch_update";
            String type = cellRequest.getStyleCellsBatch().getType();
            String params = "";
            if (type != null && !type.isEmpty() && "JSON_STR".equals(type)) {
                params = cellRequest.getStyleCellsBatch().getParams();
            } else {
                List<String> ranges = cellRequest.getStyleCellsBatch().getRanges();
                Style style = cellRequest.getStyleCellsBatch().getStyle();
                if (ranges == null || ranges.isEmpty()) {
                    ApiResponse errorResponse3 = new ApiResponse();
                    errorResponse3.setCode(400);
                    errorResponse3.setMsg("Invalid cell ranges");
                    return errorResponse3;
                }
                StyleBatchUpdateRequest styleBatchRequest = new StyleBatchUpdateRequest();
                StyleBatchData styleBatchData = new StyleBatchData();
                styleBatchData.setRanges(ranges);
                styleBatchData.setStyle(style);
                styleBatchRequest.getData().add(styleBatchData);
                params = this.gson.toJson((Object)styleBatchRequest);
            }
            if ((response = this.executeRequest(httpRequest2 = this.createAuthenticatedRequest(url, "PUT", body2 = RequestBody.create((String)params, (MediaType)JSON_MEDIA_TYPE)).build(), ApiResponse.class)).success()) continue;
            return response;
        }
        if (response == null) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setCode(400);
            errorResponse.setMsg("No valid cell operation found");
            return errorResponse;
        }
        return response;
    }

    public static class StyleCellsBatchBuilder {
        private final CellRequest request = new CellRequest();
        private final StyleCellsBatchRequest styleCellsBatch = new StyleCellsBatchRequest();
        private final Style style = new Style();
        private Font font;

        public StyleCellsBatchBuilder() {
            this.styleCellsBatch.setStyle(this.style);
            this.request.setStyleCellsBatch(this.styleCellsBatch);
        }

        public StyleCellsBatchBuilder setReqType(String reqType) {
            this.styleCellsBatch.setType(reqType);
            return this;
        }

        public StyleCellsBatchBuilder setParams(String params) {
            this.styleCellsBatch.setParams(params);
            return this;
        }

        public StyleCellsBatchBuilder addRange(String sheetId, String startPosition, String endPosition) {
            this.styleCellsBatch.addCellRange(sheetId, startPosition, endPosition);
            return this;
        }

        public StyleCellsBatchBuilder bold(Boolean bold) {
            if (this.font == null) {
                this.font = new Font();
                this.style.setFont(this.font);
            }
            this.font.setBold(bold);
            return this;
        }

        public StyleCellsBatchBuilder italic(Boolean italic) {
            if (this.font == null) {
                this.font = new Font();
                this.style.setFont(this.font);
            }
            this.font.setItalic(italic);
            return this;
        }

        public StyleCellsBatchBuilder fontSize(String fontSize) {
            if (this.font == null) {
                this.font = new Font();
                this.style.setFont(this.font);
            }
            this.font.setFontSize(fontSize);
            return this;
        }

        public StyleCellsBatchBuilder fontClean(Boolean clean) {
            if (this.font == null) {
                this.font = new Font();
                this.style.setFont(this.font);
            }
            this.font.setClean(clean);
            return this;
        }

        public StyleCellsBatchBuilder textDecoration(Integer textDecoration) {
            this.style.setTextDecoration(textDecoration);
            return this;
        }

        public StyleCellsBatchBuilder formatter(String formatter) {
            this.style.setFormatter(formatter);
            return this;
        }

        public StyleCellsBatchBuilder hAlign(Integer hAlign) {
            this.style.setHAlign(hAlign);
            return this;
        }

        public StyleCellsBatchBuilder vAlign(Integer vAlign) {
            this.style.setVAlign(vAlign);
            return this;
        }

        public StyleCellsBatchBuilder foreColor(String foreColor) {
            this.style.setForeColor(foreColor);
            return this;
        }

        public StyleCellsBatchBuilder backColor(String backColor) {
            this.style.setBackColor(backColor);
            return this;
        }

        public StyleCellsBatchBuilder borderType(String borderType) {
            this.style.setBorderType(borderType);
            return this;
        }

        public StyleCellsBatchBuilder borderColor(String borderColor) {
            this.style.setBorderColor(borderColor);
            return this;
        }

        public StyleCellsBatchBuilder clean(Boolean clean) {
            this.style.setClean(clean);
            return this;
        }

        public CellRequest build() {
            return this.request;
        }
    }

    public static class CellRange {
        private String sheetId;
        private String startPosition;
        private String endPosition;

        public CellRange() {
        }

        public CellRange(String sheetId, String startPosition, String endPosition) {
            this.sheetId = sheetId;
            this.startPosition = startPosition;
            this.endPosition = endPosition;
        }

        public String getRange() {
            if (this.sheetId != null && this.startPosition != null && this.endPosition != null) {
                return this.sheetId + "!" + this.startPosition + ":" + this.endPosition;
            }
            return null;
        }

        public static CellRange fromRange(String range) {
            CellRange cellRange = new CellRange();
            try {
                String[] parts = range.split("!");
                cellRange.sheetId = parts[0];
                String[] positions = parts[1].split(":");
                cellRange.startPosition = positions[0];
                cellRange.endPosition = positions[1];
            }
            catch (Exception exception) {
                // empty catch block
            }
            return cellRange;
        }

        public String getSheetId() {
            return this.sheetId;
        }

        public void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getEndPosition() {
            return this.endPosition;
        }

        public void setEndPosition(String endPosition) {
            this.endPosition = endPosition;
        }
    }

    public static class StyleCellsBatchRequest {
        @Deprecated
        private List<String> ranges = new ArrayList<String>();
        private List<CellRange> cellRanges = new ArrayList<CellRange>();
        private Style style;
        private String type;
        private String params;

        public List<String> getRanges() {
            if (this.cellRanges != null && !this.cellRanges.isEmpty()) {
                ArrayList<String> result = new ArrayList<String>();
                for (CellRange cellRange : this.cellRanges) {
                    result.add(cellRange.getRange());
                }
                return result;
            }
            return this.ranges;
        }

        public List<CellRange> getCellRanges() {
            return this.cellRanges;
        }

        public void setCellRanges(List<CellRange> cellRanges) {
            this.cellRanges = cellRanges;
        }

        public void addCellRange(CellRange cellRange) {
            if (this.cellRanges == null) {
                this.cellRanges = new ArrayList<CellRange>();
            }
            this.cellRanges.add(cellRange);
        }

        public void addCellRange(String sheetId, String startPosition, String endPosition) {
            this.addCellRange(new CellRange(sheetId, startPosition, endPosition));
        }

        public Style getStyle() {
            return this.style;
        }

        public void setStyle(Style style) {
            this.style = style;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getParams() {
            return this.params;
        }

        public void setParams(String params) {
            this.params = params;
        }
    }

    public static class StyleBatchData {
        private List<String> ranges = new ArrayList<String>();
        private Style style;

        public List<String> getRanges() {
            return this.ranges;
        }

        public void setRanges(List<String> ranges) {
            this.ranges = ranges;
        }

        public Style getStyle() {
            return this.style;
        }

        public void setStyle(Style style) {
            this.style = style;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private final StyleBatchData data = new StyleBatchData();
            private final Style style = new Style();
            private Font font;

            public Builder() {
                this.data.setStyle(this.style);
            }

            public Builder addRange(String range) {
                this.data.ranges.add(range);
                return this;
            }

            public Builder bold(Boolean bold) {
                if (this.font == null) {
                    this.font = new Font();
                    this.style.setFont(this.font);
                }
                this.font.setBold(bold);
                return this;
            }

            public Builder italic(Boolean italic) {
                if (this.font == null) {
                    this.font = new Font();
                    this.style.setFont(this.font);
                }
                this.font.setItalic(italic);
                return this;
            }

            public Builder fontSize(String fontSize) {
                if (this.font == null) {
                    this.font = new Font();
                    this.style.setFont(this.font);
                }
                this.font.setFontSize(fontSize);
                return this;
            }

            public Builder fontClean(Boolean clean) {
                if (this.font == null) {
                    this.font = new Font();
                    this.style.setFont(this.font);
                }
                this.font.setClean(clean);
                return this;
            }

            public Builder textDecoration(Integer textDecoration) {
                this.style.setTextDecoration(textDecoration);
                return this;
            }

            public Builder formatter(String formatter) {
                this.style.setFormatter(formatter);
                return this;
            }

            public Builder hAlign(Integer hAlign) {
                this.style.setHAlign(hAlign);
                return this;
            }

            public Builder vAlign(Integer vAlign) {
                this.style.setVAlign(vAlign);
                return this;
            }

            public Builder foreColor(String foreColor) {
                this.style.setForeColor(foreColor);
                return this;
            }

            public Builder backColor(String backColor) {
                this.style.setBackColor(backColor);
                return this;
            }

            public Builder borderType(String borderType) {
                this.style.setBorderType(borderType);
                return this;
            }

            public Builder borderColor(String borderColor) {
                this.style.setBorderColor(borderColor);
                return this;
            }

            public Builder clean(Boolean clean) {
                this.style.setClean(clean);
                return this;
            }

            public StyleBatchData build() {
                return this.data;
            }
        }
    }

    public static class StyleBatchUpdateRequest {
        private List<StyleBatchData> data = new ArrayList<StyleBatchData>();

        public List<StyleBatchData> getData() {
            return this.data;
        }

        public void setData(List<StyleBatchData> data) {
            this.data = data;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private final StyleBatchUpdateRequest request = new StyleBatchUpdateRequest();

            public Builder addStyleBatch(StyleBatchData styleBatchData) {
                this.request.data.add(styleBatchData);
                return this;
            }

            public StyleBatchUpdateRequest build() {
                return this.request;
            }
        }
    }

    public static class StyleCellsBuilder {
        private final CellRequest request = new CellRequest();
        private final StyleCellsRequest styleCells = new StyleCellsRequest();
        private final Style style = new Style();
        private Font font;

        public StyleCellsBuilder() {
            this.styleCells.setStyle(this.style);
            this.request.setStyleCells(this.styleCells);
        }

        public StyleCellsBuilder sheetId(String sheetId) {
            this.styleCells.setSheetId(sheetId);
            return this;
        }

        public StyleCellsBuilder startPosition(String startPosition) {
            this.styleCells.setStartPosition(startPosition);
            return this;
        }

        public StyleCellsBuilder endPosition(String endPosition) {
            this.styleCells.setEndPosition(endPosition);
            return this;
        }

        public StyleCellsBuilder bold(Boolean bold) {
            if (this.font == null) {
                this.font = new Font();
                this.style.setFont(this.font);
            }
            this.font.setBold(bold);
            return this;
        }

        public StyleCellsBuilder italic(Boolean italic) {
            if (this.font == null) {
                this.font = new Font();
                this.style.setFont(this.font);
            }
            this.font.setItalic(italic);
            return this;
        }

        public StyleCellsBuilder fontSize(String fontSize) {
            if (this.font == null) {
                this.font = new Font();
                this.style.setFont(this.font);
            }
            this.font.setFontSize(fontSize);
            return this;
        }

        public StyleCellsBuilder fontClean(Boolean clean) {
            if (this.font == null) {
                this.font = new Font();
                this.style.setFont(this.font);
            }
            this.font.setClean(clean);
            return this;
        }

        public StyleCellsBuilder textDecoration(Integer textDecoration) {
            this.style.setTextDecoration(textDecoration);
            return this;
        }

        public StyleCellsBuilder formatter(String formatter) {
            this.style.setFormatter(formatter);
            return this;
        }

        public StyleCellsBuilder hAlign(Integer hAlign) {
            this.style.setHAlign(hAlign);
            return this;
        }

        public StyleCellsBuilder vAlign(Integer vAlign) {
            this.style.setVAlign(vAlign);
            return this;
        }

        public StyleCellsBuilder foreColor(String foreColor) {
            this.style.setForeColor(foreColor);
            return this;
        }

        public StyleCellsBuilder backColor(String backColor) {
            this.style.setBackColor(backColor);
            return this;
        }

        public StyleCellsBuilder borderType(String borderType) {
            this.style.setBorderType(borderType);
            return this;
        }

        public StyleCellsBuilder borderColor(String borderColor) {
            this.style.setBorderColor(borderColor);
            return this;
        }

        public StyleCellsBuilder clean(Boolean clean) {
            this.style.setClean(clean);
            return this;
        }

        public CellRequest build() {
            return this.request;
        }
    }

    private static class StyleCellsRequestBody {
        private final AppendStyle appendStyle;

        public StyleCellsRequestBody(String range, Style style) {
            this.appendStyle = new AppendStyle(range, style);
        }

        public AppendStyle getAppendStyle() {
            return this.appendStyle;
        }

        private static class AppendStyle {
            private final String range;
            private final Style style;

            public AppendStyle(String range, Style style) {
                this.range = range;
                this.style = style;
            }

            public String getRange() {
                return this.range;
            }

            public Style getStyle() {
                return this.style;
            }
        }
    }

    private static class UnmergeCellsRequestBody {
        private final String range;

        public UnmergeCellsRequestBody(String range) {
            this.range = range;
        }

        public String getRange() {
            return this.range;
        }
    }

    private static class MergeCellsRequestBody {
        private final String range;
        private final String mergeType;

        public MergeCellsRequestBody(String range, String mergeType) {
            this.range = range;
            this.mergeType = mergeType;
        }

        public String getRange() {
            return this.range;
        }

        public String getMergeType() {
            return this.mergeType;
        }
    }

    public static class Font {
        private Boolean bold;
        private Boolean italic;
        private String fontSize;
        private Boolean clean;

        public Boolean getBold() {
            return this.bold;
        }

        public void setBold(Boolean bold) {
            this.bold = bold;
        }

        public Boolean getItalic() {
            return this.italic;
        }

        public void setItalic(Boolean italic) {
            this.italic = italic;
        }

        public String getFontSize() {
            return this.fontSize;
        }

        public void setFontSize(String fontSize) {
            this.fontSize = fontSize;
        }

        public Boolean getClean() {
            return this.clean;
        }

        public void setClean(Boolean clean) {
            this.clean = clean;
        }
    }

    public static class Style {
        private Font font;
        private Integer textDecoration;
        private String formatter;
        private Integer hAlign;
        private Integer vAlign;
        private String foreColor;
        private String backColor;
        private String borderType;
        private String borderColor;
        private Boolean clean;

        public Font getFont() {
            return this.font;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public Integer getTextDecoration() {
            return this.textDecoration;
        }

        public void setTextDecoration(Integer textDecoration) {
            this.textDecoration = textDecoration;
        }

        public String getFormatter() {
            return this.formatter;
        }

        public void setFormatter(String formatter) {
            this.formatter = formatter;
        }

        public Integer getHAlign() {
            return this.hAlign;
        }

        public void setHAlign(Integer hAlign) {
            this.hAlign = hAlign;
        }

        public Integer getVAlign() {
            return this.vAlign;
        }

        public void setVAlign(Integer vAlign) {
            this.vAlign = vAlign;
        }

        public String getForeColor() {
            return this.foreColor;
        }

        public void setForeColor(String foreColor) {
            this.foreColor = foreColor;
        }

        public String getBackColor() {
            return this.backColor;
        }

        public void setBackColor(String backColor) {
            this.backColor = backColor;
        }

        public String getBorderType() {
            return this.borderType;
        }

        public void setBorderType(String borderType) {
            this.borderType = borderType;
        }

        public String getBorderColor() {
            return this.borderColor;
        }

        public void setBorderColor(String borderColor) {
            this.borderColor = borderColor;
        }

        public Boolean getClean() {
            return this.clean;
        }

        public void setClean(Boolean clean) {
            this.clean = clean;
        }
    }

    public static class StyleCellsRequest {
        private String sheetId;
        private String startPosition;
        private String endPosition;
        private String legacyRange;
        private Style style;

        public String getRange() {
            if (this.legacyRange != null && !this.legacyRange.isEmpty()) {
                return this.legacyRange;
            }
            if (this.sheetId != null && this.startPosition != null && this.endPosition != null) {
                return this.sheetId + "!" + this.startPosition + ":" + this.endPosition;
            }
            return null;
        }

        public String getSheetId() {
            return this.sheetId;
        }

        public void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getEndPosition() {
            return this.endPosition;
        }

        public void setEndPosition(String endPosition) {
            this.endPosition = endPosition;
        }

        public void setLegacyRange(String legacyRange) {
            this.legacyRange = legacyRange;
        }

        public Style getStyle() {
            return this.style;
        }

        public void setStyle(Style style) {
            this.style = style;
        }
    }

    public static class UnmergeCellsRequest {
        private String sheetId;
        private String startPosition;
        private String endPosition;
        private String legacyRange;

        public String getRange() {
            if (this.legacyRange != null && !this.legacyRange.isEmpty()) {
                return this.legacyRange;
            }
            if (this.sheetId != null && this.startPosition != null && this.endPosition != null) {
                return this.sheetId + "!" + this.startPosition + ":" + this.endPosition;
            }
            return null;
        }

        public String getSheetId() {
            return this.sheetId;
        }

        public void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getEndPosition() {
            return this.endPosition;
        }

        public void setEndPosition(String endPosition) {
            this.endPosition = endPosition;
        }
    }

    public static class MergeCellsRequest {
        private String sheetId;
        private String startPosition;
        private String endPosition;
        private String legacyRange;
        private String mergeType;
        private String type;
        private String params;

        public String getRange() {
            if (this.legacyRange != null && !this.legacyRange.isEmpty()) {
                return this.legacyRange;
            }
            if (this.sheetId != null && this.startPosition != null && this.endPosition != null) {
                return this.sheetId + "!" + this.startPosition + ":" + this.endPosition;
            }
            return null;
        }

        public String getSheetId() {
            return this.sheetId;
        }

        public void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getEndPosition() {
            return this.endPosition;
        }

        public void setEndPosition(String endPosition) {
            this.endPosition = endPosition;
        }

        public String getMergeType() {
            return this.mergeType;
        }

        public void setMergeType(String mergeType) {
            this.mergeType = mergeType;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getParams() {
            return this.params;
        }

        public void setParams(String params) {
            this.params = params;
        }
    }

    public static class CellRequest {
        private MergeCellsRequest mergeCells;
        private UnmergeCellsRequest unmergeCells;
        private StyleCellsRequest styleCells;
        private StyleCellsBatchRequest styleCellsBatch;

        public MergeCellsRequest getMergeCells() {
            return this.mergeCells;
        }

        public void setMergeCells(MergeCellsRequest mergeCells) {
            this.mergeCells = mergeCells;
        }

        public UnmergeCellsRequest getUnmergeCells() {
            return this.unmergeCells;
        }

        public void setUnmergeCells(UnmergeCellsRequest unmergeCells) {
            this.unmergeCells = unmergeCells;
        }

        public StyleCellsRequest getStyleCells() {
            return this.styleCells;
        }

        public void setStyleCells(StyleCellsRequest styleCells) {
            this.styleCells = styleCells;
        }

        public StyleCellsBatchRequest getStyleCellsBatch() {
            return this.styleCellsBatch;
        }

        public void setStyleCellsBatch(StyleCellsBatchRequest styleCellsBatch) {
            this.styleCellsBatch = styleCellsBatch;
        }

        public static MergeCellsBuilder mergeCells() {
            return new MergeCellsBuilder();
        }

        public static UnmergeCellsBuilder unmergeCells() {
            return new UnmergeCellsBuilder();
        }

        public static StyleCellsBuilder styleCells() {
            return new StyleCellsBuilder();
        }

        public static StyleCellsBatchBuilder styleCellsBatch() {
            return new StyleCellsBatchBuilder();
        }

        public static class UnmergeCellsBuilder {
            private final CellRequest request = new CellRequest();
            private final UnmergeCellsRequest unmergeCells = new UnmergeCellsRequest();

            public UnmergeCellsBuilder() {
                this.request.setUnmergeCells(this.unmergeCells);
            }

            public UnmergeCellsBuilder sheetId(String sheetId) {
                this.unmergeCells.sheetId = sheetId;
                return this;
            }

            public UnmergeCellsBuilder startPosition(String startPosition) {
                this.unmergeCells.startPosition = startPosition;
                return this;
            }

            public UnmergeCellsBuilder endPosition(String endPosition) {
                this.unmergeCells.endPosition = endPosition;
                return this;
            }

            public CellRequest build() {
                return this.request;
            }
        }

        public static class MergeCellsBuilder {
            private final CellRequest request = new CellRequest();
            private final MergeCellsRequest mergeCells = new MergeCellsRequest();

            public MergeCellsBuilder() {
                this.request.setMergeCells(this.mergeCells);
            }

            public MergeCellsBuilder setReqType(String reqType) {
                this.mergeCells.setType(reqType);
                return this;
            }

            public MergeCellsBuilder setReqParams(String reqParams) {
                this.mergeCells.setParams(reqParams);
                return this;
            }

            public MergeCellsBuilder sheetId(String sheetId) {
                this.mergeCells.sheetId = sheetId;
                return this;
            }

            public MergeCellsBuilder startPosition(String startPosition) {
                this.mergeCells.startPosition = startPosition;
                return this;
            }

            public MergeCellsBuilder endPosition(String endPosition) {
                this.mergeCells.endPosition = endPosition;
                return this;
            }

            public MergeCellsBuilder mergeType(String mergeType) {
                this.mergeCells.mergeType = mergeType;
                return this;
            }

            public CellRequest build() {
                return this.request;
            }
        }
    }

    public static class CellBatchUpdateRequest {
        private List<CellRequest> requests = new ArrayList<CellRequest>();

        public List<CellRequest> getRequests() {
            return this.requests;
        }

        public void setRequests(List<CellRequest> requests) {
            this.requests = requests;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private final CellBatchUpdateRequest request = new CellBatchUpdateRequest();

            public Builder addRequest(CellRequest cellRequest) {
                this.request.requests.add(cellRequest);
                return this;
            }

            public CellBatchUpdateRequest build() {
                return this.request;
            }
        }
    }
}

