/*
 * Decompiled with CFR 0.152.
 */
package cn.isliu.core.service;

import cn.isliu.core.client.FeishuApiClient;
import cn.isliu.core.client.FeishuClient;
import cn.isliu.core.pojo.ApiResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class CustomDataValidationService
extends FeishuApiClient {
    public CustomDataValidationService(FeishuClient feishuClient) {
        super(feishuClient);
    }

    public ApiResponse dataValidationBatchUpdate(String spreadsheetToken, DataValidationBatchUpdateRequest request) throws IOException {
        List<DataValidationRequest> requests = request.getRequests();
        ApiResponse response = null;
        if (requests == null || requests.isEmpty()) {
            ApiResponse emptyResponse = new ApiResponse();
            emptyResponse.setCode(400);
            emptyResponse.setMsg("No data validation operations found");
            return emptyResponse;
        }
        for (DataValidationRequest validationRequest : requests) {
            String url;
            ApiResponse errorResponse;
            if (validationRequest.getQueryValidation() != null) {
                QueryValidationRequest queryValidation = validationRequest.getQueryValidation();
                if (queryValidation.getRange() == null || queryValidation.getRange().isEmpty()) {
                    errorResponse = new ApiResponse();
                    errorResponse.setCode(400);
                    errorResponse.setMsg("Range cannot be empty for data validation query");
                    return errorResponse;
                }
                String baseUrl = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/dataValidation";
                StringBuilder urlBuilder = new StringBuilder(baseUrl);
                urlBuilder.append("?range=").append(URLEncoder.encode(queryValidation.getRange(), StandardCharsets.UTF_8.toString()));
                urlBuilder.append("&dataValidationType=list");
                String url2 = urlBuilder.toString();
                Request httpRequest = this.createAuthenticatedRequest(url2, "GET", null).build();
                response = this.executeRequest(httpRequest, ApiResponse.class);
                if (response.success()) continue;
                return response;
            }
            if (validationRequest.getDeleteValidation() != null) {
                DeleteValidationRequest deleteValidation = validationRequest.getDeleteValidation();
                if (deleteValidation.getRange() == null || deleteValidation.getRange().isEmpty()) {
                    errorResponse = new ApiResponse();
                    errorResponse.setCode(400);
                    errorResponse.setMsg("Range cannot be empty for data validation delete");
                    return errorResponse;
                }
                if (deleteValidation.getDataValidationIds() == null || deleteValidation.getDataValidationIds().isEmpty()) {
                    errorResponse = new ApiResponse();
                    errorResponse.setCode(400);
                    errorResponse.setMsg("DataValidationIds cannot be empty for data validation delete");
                    return errorResponse;
                }
                String url3 = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/dataValidation";
                DeleteValidationRequestBody requestBody = new DeleteValidationRequestBody();
                DeleteValidationRange validationRange = new DeleteValidationRange();
                validationRange.setRange(deleteValidation.getRange());
                validationRange.setDataValidationIds(deleteValidation.getDataValidationIds());
                requestBody.getDataValidationRanges().add(validationRange);
                RequestBody body = RequestBody.create((String)this.gson.toJson((Object)requestBody), (MediaType)JSON_MEDIA_TYPE);
                Request httpRequest = this.createAuthenticatedRequest(url3, "DELETE", body).build();
                response = this.executeRequest(httpRequest, ApiResponse.class);
                if (response.success()) continue;
                return response;
            }
            if (validationRequest.getRange() != null && "list".equals(validationRequest.getDataValidationType())) {
                RequestBody body;
                url = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/dataValidation";
                Request httpRequest = this.createAuthenticatedRequest(url, "POST", body = RequestBody.create((String)this.gson.toJson((Object)validationRequest), (MediaType)JSON_MEDIA_TYPE)).build();
                response = this.executeRequest(httpRequest, ApiResponse.class);
                if (response.success()) continue;
                return response;
            }
            if (validationRequest.getSheetId() == null || validationRequest.getDataValidationId() == null || !"list".equals(validationRequest.getDataValidationType())) continue;
            url = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/dataValidation/" + validationRequest.getSheetId() + "/" + validationRequest.getDataValidationId();
            DataValidationRequest requestBody = new DataValidationRequest();
            requestBody.setDataValidationType(validationRequest.getDataValidationType());
            requestBody.setDataValidation(validationRequest.getDataValidation());
            RequestBody body = RequestBody.create((String)this.gson.toJson((Object)requestBody), (MediaType)JSON_MEDIA_TYPE);
            Request httpRequest = this.createAuthenticatedRequest(url, "PUT", body).build();
            response = this.executeRequest(httpRequest, ApiResponse.class);
            if (response.success()) continue;
            return response;
        }
        if (response == null) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setCode(400);
            errorResponse.setMsg("No valid data validation operation found");
            return errorResponse;
        }
        return response;
    }

    public static class DataValidationOptions {
        private Boolean multipleValues;
        private Boolean highlightValidData;
        private List<String> colors = new ArrayList<String>();

        public Boolean getMultipleValues() {
            return this.multipleValues;
        }

        public void setMultipleValues(Boolean multipleValues) {
            this.multipleValues = multipleValues;
        }

        public Boolean getHighlightValidData() {
            return this.highlightValidData;
        }

        public void setHighlightValidData(Boolean highlightValidData) {
            this.highlightValidData = highlightValidData;
        }

        public List<String> getColors() {
            return this.colors;
        }

        public void setColors(List<String> colors) {
            this.colors = colors;
        }
    }

    public static class DataValidation {
        private List<String> conditionValues = new ArrayList<String>();
        private DataValidationOptions options;

        public List<String> getConditionValues() {
            return this.conditionValues;
        }

        public void setConditionValues(List<String> conditionValues) {
            this.conditionValues = conditionValues;
        }

        public DataValidationOptions getOptions() {
            return this.options;
        }

        public void setOptions(DataValidationOptions options) {
            this.options = options;
        }
    }

    public static class DeleteValidationRequest {
        private String range;
        private List<Integer> dataValidationIds = new ArrayList<Integer>();

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }

        public List<Integer> getDataValidationIds() {
            return this.dataValidationIds;
        }

        public void setDataValidationIds(List<Integer> dataValidationIds) {
            this.dataValidationIds = dataValidationIds;
        }
    }

    public static class QueryValidationRequest {
        private String range;

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }
    }

    public static class DataValidationRequest {
        private String range;
        private String dataValidationType;
        private DataValidation dataValidation;
        private String sheetId;
        private Integer dataValidationId;
        private QueryValidationRequest queryValidation;
        private DeleteValidationRequest deleteValidation;

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }

        public String getDataValidationType() {
            return this.dataValidationType;
        }

        public void setDataValidationType(String dataValidationType) {
            this.dataValidationType = dataValidationType;
        }

        public DataValidation getDataValidation() {
            return this.dataValidation;
        }

        public void setDataValidation(DataValidation dataValidation) {
            this.dataValidation = dataValidation;
        }

        public String getSheetId() {
            return this.sheetId;
        }

        public void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        public Integer getDataValidationId() {
            return this.dataValidationId;
        }

        public void setDataValidationId(Integer dataValidationId) {
            this.dataValidationId = dataValidationId;
        }

        public QueryValidationRequest getQueryValidation() {
            return this.queryValidation;
        }

        public void setQueryValidation(QueryValidationRequest queryValidation) {
            this.queryValidation = queryValidation;
        }

        public DeleteValidationRequest getDeleteValidation() {
            return this.deleteValidation;
        }

        public void setDeleteValidation(DeleteValidationRequest deleteValidation) {
            this.deleteValidation = deleteValidation;
        }

        public static ListDataValidationBuilder listValidation() {
            return new ListDataValidationBuilder();
        }

        public static UpdateListDataValidationBuilder updateListValidation() {
            return new UpdateListDataValidationBuilder();
        }

        public static QueryListDataValidationBuilder queryListValidation() {
            return new QueryListDataValidationBuilder();
        }

        public static DeleteListDataValidationBuilder deleteListValidation() {
            return new DeleteListDataValidationBuilder();
        }

        public static class DeleteListDataValidationBuilder {
            private final DataValidationRequest request = new DataValidationRequest();
            private final DeleteValidationRequest deleteValidation = new DeleteValidationRequest();

            public DeleteListDataValidationBuilder() {
                this.request.setDeleteValidation(this.deleteValidation);
            }

            public DeleteListDataValidationBuilder range(String range) {
                this.deleteValidation.setRange(range);
                return this;
            }

            public DeleteListDataValidationBuilder range(String sheetId, String startPosition, String endPosition) {
                this.deleteValidation.setRange(sheetId + "!" + startPosition + ":" + endPosition);
                return this;
            }

            public DeleteListDataValidationBuilder addDataValidationId(int dataValidationId) {
                this.deleteValidation.getDataValidationIds().add(dataValidationId);
                return this;
            }

            public DeleteListDataValidationBuilder addDataValidationIds(List<Integer> dataValidationIds) {
                this.deleteValidation.getDataValidationIds().addAll(dataValidationIds);
                return this;
            }

            public DeleteListDataValidationBuilder addDataValidationIds(Integer ... dataValidationIds) {
                for (Integer id : dataValidationIds) {
                    this.deleteValidation.getDataValidationIds().add(id);
                }
                return this;
            }

            public DataValidationRequest build() {
                return this.request;
            }
        }

        public static class QueryListDataValidationBuilder {
            private final DataValidationRequest request = new DataValidationRequest();
            private final QueryValidationRequest queryValidation = new QueryValidationRequest();

            public QueryListDataValidationBuilder() {
                this.request.setQueryValidation(this.queryValidation);
            }

            public QueryListDataValidationBuilder range(String range) {
                this.queryValidation.setRange(range);
                return this;
            }

            public QueryListDataValidationBuilder range(String sheetId, String startPosition, String endPosition) {
                this.queryValidation.setRange(sheetId + "!" + startPosition + ":" + endPosition);
                return this;
            }

            public DataValidationRequest build() {
                return this.request;
            }
        }

        public static class UpdateListDataValidationBuilder {
            private final DataValidationRequest request = new DataValidationRequest();
            private final DataValidation dataValidation = new DataValidation();
            private final DataValidationOptions options = new DataValidationOptions();

            public UpdateListDataValidationBuilder() {
                this.request.setDataValidationType("list");
                this.dataValidation.setOptions(this.options);
                this.request.setDataValidation(this.dataValidation);
            }

            public UpdateListDataValidationBuilder target(String sheetId, int dataValidationId) {
                this.request.setSheetId(sheetId);
                this.request.setDataValidationId(dataValidationId);
                return this;
            }

            public UpdateListDataValidationBuilder addValue(String value) {
                this.dataValidation.getConditionValues().add(value);
                return this;
            }

            public UpdateListDataValidationBuilder addValues(List<String> values) {
                this.dataValidation.getConditionValues().addAll(values);
                return this;
            }

            public UpdateListDataValidationBuilder addValues(String ... values) {
                for (String value : values) {
                    this.dataValidation.getConditionValues().add(value);
                }
                return this;
            }

            public UpdateListDataValidationBuilder setValues(List<String> values) {
                this.dataValidation.setConditionValues(new ArrayList<String>(values));
                return this;
            }

            public UpdateListDataValidationBuilder setValues(String ... values) {
                ArrayList<String> valueList = new ArrayList<String>();
                for (String value : values) {
                    valueList.add(value);
                }
                this.dataValidation.setConditionValues(valueList);
                return this;
            }

            public UpdateListDataValidationBuilder multipleValues(boolean multipleValues) {
                this.options.setMultipleValues(multipleValues);
                return this;
            }

            public UpdateListDataValidationBuilder highlightValidData(boolean highlightValidData) {
                this.options.setHighlightValidData(highlightValidData);
                return this;
            }

            public UpdateListDataValidationBuilder addColor(String color) {
                this.options.getColors().add(color);
                return this;
            }

            public UpdateListDataValidationBuilder addColors(List<String> colors) {
                this.options.getColors().addAll(colors);
                return this;
            }

            public UpdateListDataValidationBuilder addColors(String ... colors) {
                for (String color : colors) {
                    this.options.getColors().add(color);
                }
                return this;
            }

            public UpdateListDataValidationBuilder setColors(List<String> colors) {
                this.options.setColors(new ArrayList<String>(colors));
                return this;
            }

            public UpdateListDataValidationBuilder setColors(String ... colors) {
                ArrayList<String> colorList = new ArrayList<String>();
                for (String color : colors) {
                    colorList.add(color);
                }
                this.options.setColors(colorList);
                return this;
            }

            public DataValidationRequest build() {
                return this.request;
            }
        }

        public static class ListDataValidationBuilder {
            private final DataValidationRequest request = new DataValidationRequest();
            private final DataValidation dataValidation = new DataValidation();
            private final DataValidationOptions options = new DataValidationOptions();

            public ListDataValidationBuilder() {
                this.request.setDataValidationType("list");
                this.dataValidation.setOptions(this.options);
                this.request.setDataValidation(this.dataValidation);
            }

            public ListDataValidationBuilder range(String range) {
                this.request.setRange(range);
                return this;
            }

            public ListDataValidationBuilder range(String sheetId, String startPosition, String endPosition) {
                this.request.setRange(sheetId + "!" + startPosition + ":" + endPosition);
                return this;
            }

            public ListDataValidationBuilder addValue(String value) {
                this.dataValidation.getConditionValues().add(value);
                return this;
            }

            public ListDataValidationBuilder addValues(List<String> values) {
                this.dataValidation.getConditionValues().addAll(values);
                return this;
            }

            public ListDataValidationBuilder addValues(String ... values) {
                for (String value : values) {
                    this.dataValidation.getConditionValues().add(value);
                }
                return this;
            }

            public ListDataValidationBuilder multipleValues(boolean multipleValues) {
                this.options.setMultipleValues(multipleValues);
                return this;
            }

            public ListDataValidationBuilder highlightValidData(boolean highlightValidData) {
                this.options.setHighlightValidData(highlightValidData);
                return this;
            }

            public ListDataValidationBuilder addColor(String color) {
                this.options.getColors().add(color);
                return this;
            }

            public ListDataValidationBuilder addColors(List<String> colors) {
                this.options.getColors().addAll(colors);
                return this;
            }

            public ListDataValidationBuilder addColors(String ... colors) {
                for (String color : colors) {
                    this.options.getColors().add(color);
                }
                return this;
            }

            public DataValidationRequest build() {
                return this.request;
            }
        }
    }

    public static class DataValidationBatchUpdateRequest {
        private List<DataValidationRequest> requests = new ArrayList<DataValidationRequest>();

        public List<DataValidationRequest> getRequests() {
            return this.requests;
        }

        public void setRequests(List<DataValidationRequest> requests) {
            this.requests = requests;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private final DataValidationBatchUpdateRequest request = new DataValidationBatchUpdateRequest();

            public Builder addRequest(DataValidationRequest validationRequest) {
                this.request.requests.add(validationRequest);
                return this;
            }

            public DataValidationBatchUpdateRequest build() {
                return this.request;
            }
        }
    }

    private static class DeleteValidationRange {
        private String range;
        private List<Integer> dataValidationIds;

        private DeleteValidationRange() {
        }

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }

        public List<Integer> getDataValidationIds() {
            return this.dataValidationIds;
        }

        public void setDataValidationIds(List<Integer> dataValidationIds) {
            this.dataValidationIds = dataValidationIds;
        }
    }

    private static class DeleteValidationRequestBody {
        private List<DeleteValidationRange> dataValidationRanges = new ArrayList<DeleteValidationRange>();

        public List<DeleteValidationRange> getDataValidationRanges() {
            return this.dataValidationRanges;
        }

        public void setDataValidationRanges(List<DeleteValidationRange> dataValidationRanges) {
            this.dataValidationRanges = dataValidationRanges;
        }
    }
}

