/*
 * Decompiled with CFR 0.152.
 */
package cn.isliu.core.service;

import cn.isliu.core.client.FeishuApiClient;
import cn.isliu.core.client.FeishuClient;
import cn.isliu.core.pojo.ApiResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class CustomDimensionService
extends FeishuApiClient {
    public CustomDimensionService(FeishuClient feishuClient) {
        super(feishuClient);
    }

    public ApiResponse dimensionsBatchUpdate(String spreadsheetToken, DimensionBatchUpdateRequest request) throws IOException {
        List<DimensionRequest> requests = request.getRequests();
        ApiResponse response = null;
        if (requests == null || requests.isEmpty()) {
            ApiResponse emptyResponse = new ApiResponse();
            emptyResponse.setCode(400);
            emptyResponse.setMsg("No dimension operations found");
            return emptyResponse;
        }
        for (DimensionRequest dimensionRequest : requests) {
            RequestBody body;
            String url;
            Request httpRequest;
            if (!(dimensionRequest.getAddDimension() != null ? !(response = this.executeRequest(httpRequest = this.createAuthenticatedRequest(url = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/dimension_range", "POST", body = RequestBody.create((String)this.gson.toJson((Object)new AddDimensionRequestBody(dimensionRequest.getAddDimension())), (MediaType)JSON_MEDIA_TYPE)).build(), ApiResponse.class)).success() : (dimensionRequest.getInsertDimension() != null ? !(response = this.executeRequest(httpRequest = this.createAuthenticatedRequest(url = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/insert_dimension_range", "POST", body = RequestBody.create((String)this.gson.toJson((Object)new InsertDimensionRequestBody(dimensionRequest.getInsertDimension(), dimensionRequest.getInheritStyle())), (MediaType)JSON_MEDIA_TYPE)).build(), ApiResponse.class)).success() : (dimensionRequest.getUpdateDimension() != null ? !(response = this.executeRequest(httpRequest = this.createAuthenticatedRequest(url = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/dimension_range", "PUT", body = RequestBody.create((String)this.gson.toJson((Object)new UpdateDimensionRequestBody(dimensionRequest.getUpdateDimension(), dimensionRequest.getDimensionProperties())), (MediaType)JSON_MEDIA_TYPE)).build(), ApiResponse.class)).success() : dimensionRequest.getDeleteDimension() != null && !(response = this.executeRequest(httpRequest = this.createAuthenticatedRequest(url = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/dimension_range", "DELETE", body = RequestBody.create((String)this.gson.toJson((Object)new DeleteDimensionRequestBody(dimensionRequest.getDeleteDimension())), (MediaType)JSON_MEDIA_TYPE)).build(), ApiResponse.class)).success())))) continue;
            return response;
        }
        if (response == null) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setCode(400);
            errorResponse.setMsg("No valid dimension operation found");
            return errorResponse;
        }
        return response;
    }

    private static class DeleteDimensionRequestBody {
        private final UpdateDimensionRange dimension;

        public DeleteDimensionRequestBody(UpdateDimensionRange dimension) {
            this.dimension = dimension;
        }

        public UpdateDimensionRange getDimension() {
            return this.dimension;
        }
    }

    private static class UpdateDimensionRequestBody {
        private final UpdateDimensionRange dimension;
        private final DimensionProperties dimensionProperties;

        public UpdateDimensionRequestBody(UpdateDimensionRange dimension, DimensionProperties dimensionProperties) {
            this.dimension = dimension;
            this.dimensionProperties = dimensionProperties;
        }

        public UpdateDimensionRange getDimension() {
            return this.dimension;
        }

        public DimensionProperties getDimensionProperties() {
            return this.dimensionProperties;
        }
    }

    private static class InsertDimensionRequestBody {
        private final InsertDimensionRange dimension;
        private final String inheritStyle;

        public InsertDimensionRequestBody(InsertDimensionRange dimension, String inheritStyle) {
            this.dimension = dimension;
            this.inheritStyle = inheritStyle;
        }

        public InsertDimensionRange getDimension() {
            return this.dimension;
        }

        public String getInheritStyle() {
            return this.inheritStyle;
        }
    }

    private static class AddDimensionRequestBody {
        private final DimensionRange dimension;

        public AddDimensionRequestBody(DimensionRange dimension) {
            this.dimension = dimension;
        }

        public DimensionRange getDimension() {
            return this.dimension;
        }
    }

    public static class DimensionProperties {
        private Boolean visible;
        private Integer fixedSize;

        public Boolean getVisible() {
            return this.visible;
        }

        public void setVisible(Boolean visible) {
            this.visible = visible;
        }

        public Integer getFixedSize() {
            return this.fixedSize;
        }

        public void setFixedSize(Integer fixedSize) {
            this.fixedSize = fixedSize;
        }
    }

    public static class UpdateDimensionRange {
        private String sheetId;
        private String majorDimension;
        private Integer startIndex;
        private Integer endIndex;

        public String getSheetId() {
            return this.sheetId;
        }

        public void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        public String getMajorDimension() {
            return this.majorDimension;
        }

        public void setMajorDimension(String majorDimension) {
            this.majorDimension = majorDimension;
        }

        public Integer getStartIndex() {
            return this.startIndex;
        }

        public void setStartIndex(Integer startIndex) {
            this.startIndex = startIndex;
        }

        public Integer getEndIndex() {
            return this.endIndex;
        }

        public void setEndIndex(Integer endIndex) {
            this.endIndex = endIndex;
        }
    }

    public static class InsertDimensionRange {
        private String sheetId;
        private String majorDimension;
        private Integer startIndex;
        private Integer endIndex;

        public String getSheetId() {
            return this.sheetId;
        }

        public void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        public String getMajorDimension() {
            return this.majorDimension;
        }

        public void setMajorDimension(String majorDimension) {
            this.majorDimension = majorDimension;
        }

        public Integer getStartIndex() {
            return this.startIndex;
        }

        public void setStartIndex(Integer startIndex) {
            this.startIndex = startIndex;
        }

        public Integer getEndIndex() {
            return this.endIndex;
        }

        public void setEndIndex(Integer endIndex) {
            this.endIndex = endIndex;
        }
    }

    public static class DimensionRange {
        private String sheetId;
        private String majorDimension;
        private Integer length;

        public String getSheetId() {
            return this.sheetId;
        }

        public void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        public String getMajorDimension() {
            return this.majorDimension;
        }

        public void setMajorDimension(String majorDimension) {
            this.majorDimension = majorDimension;
        }

        public Integer getLength() {
            return this.length;
        }

        public void setLength(Integer length) {
            this.length = length;
        }
    }

    public static class DimensionRequest {
        private DimensionRange addDimension;
        private InsertDimensionRange insertDimension;
        private UpdateDimensionRange updateDimension;
        private UpdateDimensionRange deleteDimension;
        private DimensionProperties dimensionProperties;
        private String inheritStyle;

        public DimensionRange getAddDimension() {
            return this.addDimension;
        }

        public void setAddDimension(DimensionRange addDimension) {
            this.addDimension = addDimension;
        }

        public InsertDimensionRange getInsertDimension() {
            return this.insertDimension;
        }

        public void setInsertDimension(InsertDimensionRange insertDimension) {
            this.insertDimension = insertDimension;
        }

        public UpdateDimensionRange getUpdateDimension() {
            return this.updateDimension;
        }

        public void setUpdateDimension(UpdateDimensionRange updateDimension) {
            this.updateDimension = updateDimension;
        }

        public UpdateDimensionRange getDeleteDimension() {
            return this.deleteDimension;
        }

        public void setDeleteDimension(UpdateDimensionRange deleteDimension) {
            this.deleteDimension = deleteDimension;
        }

        public DimensionProperties getDimensionProperties() {
            return this.dimensionProperties;
        }

        public void setDimensionProperties(DimensionProperties dimensionProperties) {
            this.dimensionProperties = dimensionProperties;
        }

        public String getInheritStyle() {
            return this.inheritStyle;
        }

        public void setInheritStyle(String inheritStyle) {
            this.inheritStyle = inheritStyle;
        }

        public static AddDimensionBuilder addDimension() {
            return new AddDimensionBuilder();
        }

        public static InsertDimensionBuilder insertDimension() {
            return new InsertDimensionBuilder();
        }

        public static UpdateDimensionBuilder updateDimension() {
            return new UpdateDimensionBuilder();
        }

        public static DeleteDimensionBuilder deleteDimension() {
            return new DeleteDimensionBuilder();
        }

        public static class DeleteDimensionBuilder {
            private final DimensionRequest request = new DimensionRequest();
            private final UpdateDimensionRange dimension = new UpdateDimensionRange();

            public DeleteDimensionBuilder() {
                this.request.setDeleteDimension(this.dimension);
            }

            public DeleteDimensionBuilder sheetId(String sheetId) {
                this.dimension.sheetId = sheetId;
                return this;
            }

            public DeleteDimensionBuilder majorDimension(String majorDimension) {
                this.dimension.majorDimension = majorDimension;
                return this;
            }

            public DeleteDimensionBuilder startIndex(Integer startIndex) {
                this.dimension.startIndex = startIndex;
                return this;
            }

            public DeleteDimensionBuilder endIndex(Integer endIndex) {
                this.dimension.endIndex = endIndex;
                return this;
            }

            public DimensionRequest build() {
                return this.request;
            }
        }

        public static class UpdateDimensionBuilder {
            private final DimensionRequest request = new DimensionRequest();
            private final UpdateDimensionRange dimension = new UpdateDimensionRange();
            private final DimensionProperties properties = new DimensionProperties();

            public UpdateDimensionBuilder() {
                this.request.setUpdateDimension(this.dimension);
                this.request.setDimensionProperties(this.properties);
            }

            public UpdateDimensionBuilder sheetId(String sheetId) {
                this.dimension.sheetId = sheetId;
                return this;
            }

            public UpdateDimensionBuilder majorDimension(String majorDimension) {
                this.dimension.majorDimension = majorDimension;
                return this;
            }

            public UpdateDimensionBuilder startIndex(Integer startIndex) {
                this.dimension.startIndex = startIndex;
                return this;
            }

            public UpdateDimensionBuilder endIndex(Integer endIndex) {
                this.dimension.endIndex = endIndex;
                return this;
            }

            public UpdateDimensionBuilder visible(Boolean visible) {
                this.properties.visible = visible;
                return this;
            }

            public UpdateDimensionBuilder fixedSize(Integer fixedSize) {
                this.properties.fixedSize = fixedSize;
                return this;
            }

            public DimensionRequest build() {
                return this.request;
            }
        }

        public static class InsertDimensionBuilder {
            private final DimensionRequest request = new DimensionRequest();
            private final InsertDimensionRange dimension = new InsertDimensionRange();

            public InsertDimensionBuilder() {
                this.request.setInsertDimension(this.dimension);
            }

            public InsertDimensionBuilder sheetId(String sheetId) {
                this.dimension.sheetId = sheetId;
                return this;
            }

            public InsertDimensionBuilder majorDimension(String majorDimension) {
                this.dimension.majorDimension = majorDimension;
                return this;
            }

            public InsertDimensionBuilder startIndex(Integer startIndex) {
                this.dimension.startIndex = startIndex;
                return this;
            }

            public InsertDimensionBuilder endIndex(Integer endIndex) {
                this.dimension.endIndex = endIndex;
                return this;
            }

            public InsertDimensionBuilder inheritStyle(String inheritStyle) {
                this.request.inheritStyle = inheritStyle;
                return this;
            }

            public DimensionRequest build() {
                return this.request;
            }
        }

        public static class AddDimensionBuilder {
            private final DimensionRequest request = new DimensionRequest();
            private final DimensionRange dimension = new DimensionRange();

            public AddDimensionBuilder() {
                this.request.setAddDimension(this.dimension);
            }

            public AddDimensionBuilder sheetId(String sheetId) {
                this.dimension.sheetId = sheetId;
                return this;
            }

            public AddDimensionBuilder majorDimension(String majorDimension) {
                this.dimension.majorDimension = majorDimension;
                return this;
            }

            public AddDimensionBuilder length(Integer length) {
                this.dimension.length = length;
                return this;
            }

            public DimensionRequest build() {
                return this.request;
            }
        }
    }

    public static class DimensionBatchUpdateRequest {
        private List<DimensionRequest> requests = new ArrayList<DimensionRequest>();

        public List<DimensionRequest> getRequests() {
            return this.requests;
        }

        public void setRequests(List<DimensionRequest> requests) {
            this.requests = requests;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private final DimensionBatchUpdateRequest request = new DimensionBatchUpdateRequest();

            public Builder addRequest(DimensionRequest dimensionRequest) {
                this.request.requests.add(dimensionRequest);
                return this;
            }

            public DimensionBatchUpdateRequest build() {
                return this.request;
            }
        }
    }
}

