/*
 * Decompiled with CFR 0.152.
 */
package cn.isliu.core.service;

import cn.isliu.core.client.FeishuApiClient;
import cn.isliu.core.client.FeishuClient;
import cn.isliu.core.pojo.ApiResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class CustomProtectedDimensionService
extends FeishuApiClient {
    public CustomProtectedDimensionService(FeishuClient feishuClient) {
        super(feishuClient);
    }

    public ApiResponse protectedDimensionBatchUpdate(String spreadsheetToken, ProtectedDimensionBatchUpdateRequest request) throws IOException {
        List<ProtectedDimensionRequest> requests = request.getRequests();
        ApiResponse response = null;
        if (requests == null || requests.isEmpty()) {
            ApiResponse emptyResponse = new ApiResponse();
            emptyResponse.setCode(400);
            emptyResponse.setMsg("No protected dimension operations found");
            return emptyResponse;
        }
        for (ProtectedDimensionRequest protectedDimensionRequest : requests) {
            RequestBody body;
            String url;
            Request httpRequest;
            if (protectedDimensionRequest.getAddProtectedDimension() == null || (response = this.executeRequest(httpRequest = this.createAuthenticatedRequest(url = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/protected_dimension", "POST", body = RequestBody.create((String)this.gson.toJson((Object)new AddProtectedDimensionRequestBody(protectedDimensionRequest.getAddProtectedDimension())), (MediaType)JSON_MEDIA_TYPE)).build(), ApiResponse.class)).success()) continue;
            return response;
        }
        if (response == null) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setCode(400);
            errorResponse.setMsg("No valid protected dimension operation found");
            return errorResponse;
        }
        return response;
    }

    private static class AddProtectedDimensionRequestBody {
        private final List<AddProtectedDimensionRange> addProtectedDimension;

        public AddProtectedDimensionRequestBody(List<AddProtectedDimensionRange> addProtectedDimension) {
            this.addProtectedDimension = addProtectedDimension;
        }

        public List<AddProtectedDimensionRange> getAddProtectedDimension() {
            return this.addProtectedDimension;
        }
    }

    public static class DimensionRange {
        private String sheetId;
        private String majorDimension;
        private Integer startIndex;
        private Integer endIndex;

        public String getSheetId() {
            return this.sheetId;
        }

        public void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        public String getMajorDimension() {
            return this.majorDimension;
        }

        public void setMajorDimension(String majorDimension) {
            this.majorDimension = majorDimension;
        }

        public Integer getStartIndex() {
            return this.startIndex;
        }

        public void setStartIndex(Integer startIndex) {
            this.startIndex = startIndex;
        }

        public Integer getEndIndex() {
            return this.endIndex;
        }

        public void setEndIndex(Integer endIndex) {
            this.endIndex = endIndex;
        }
    }

    public static class AddProtectedDimensionRange {
        private DimensionRange dimension = new DimensionRange();
        private List<String> users = new ArrayList<String>();
        private String lockInfo;

        public DimensionRange getDimension() {
            return this.dimension;
        }

        public void setDimension(DimensionRange dimension) {
            this.dimension = dimension;
        }

        public List<String> getUsers() {
            return this.users;
        }

        public void setUsers(List<String> users) {
            this.users = users;
        }

        public String getLockInfo() {
            return this.lockInfo;
        }

        public void setLockInfo(String lockInfo) {
            this.lockInfo = lockInfo;
        }
    }

    public static class ProtectedDimensionRequest {
        private List<AddProtectedDimensionRange> addProtectedDimension;

        public List<AddProtectedDimensionRange> getAddProtectedDimension() {
            return this.addProtectedDimension;
        }

        public void setAddProtectedDimension(List<AddProtectedDimensionRange> addProtectedDimension) {
            this.addProtectedDimension = addProtectedDimension;
        }

        public static AddProtectedDimensionBuilder addProtectedDimension() {
            return new AddProtectedDimensionBuilder();
        }

        public static class AddProtectedDimensionBuilder {
            private final ProtectedDimensionRequest request = new ProtectedDimensionRequest();
            private final AddProtectedDimensionRange protectedDimension = new AddProtectedDimensionRange();

            public AddProtectedDimensionBuilder() {
                ArrayList<AddProtectedDimensionRange> list = new ArrayList<AddProtectedDimensionRange>();
                list.add(this.protectedDimension);
                this.request.setAddProtectedDimension(list);
            }

            public AddProtectedDimensionBuilder sheetId(String sheetId) {
                this.protectedDimension.getDimension().setSheetId(sheetId);
                return this;
            }

            public AddProtectedDimensionBuilder majorDimension(String majorDimension) {
                this.protectedDimension.getDimension().setMajorDimension(majorDimension);
                return this;
            }

            public AddProtectedDimensionBuilder startIndex(Integer startIndex) {
                this.protectedDimension.getDimension().setStartIndex(startIndex);
                return this;
            }

            public AddProtectedDimensionBuilder endIndex(Integer endIndex) {
                this.protectedDimension.getDimension().setEndIndex(endIndex);
                return this;
            }

            public AddProtectedDimensionBuilder addUser(String userId) {
                this.protectedDimension.getUsers().add(userId);
                return this;
            }

            public AddProtectedDimensionBuilder users(List<String> userIds) {
                this.protectedDimension.setUsers(userIds);
                return this;
            }

            public AddProtectedDimensionBuilder lockInfo(String lockInfo) {
                this.protectedDimension.setLockInfo(lockInfo);
                return this;
            }

            public ProtectedDimensionRequest build() {
                return this.request;
            }
        }
    }

    public static class ProtectedDimensionBatchUpdateRequest {
        private List<ProtectedDimensionRequest> requests = new ArrayList<ProtectedDimensionRequest>();

        public List<ProtectedDimensionRequest> getRequests() {
            return this.requests;
        }

        public void setRequests(List<ProtectedDimensionRequest> requests) {
            this.requests = requests;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private final ProtectedDimensionBatchUpdateRequest request = new ProtectedDimensionBatchUpdateRequest();

            public Builder addRequest(ProtectedDimensionRequest protectedDimensionRequest) {
                this.request.requests.add(protectedDimensionRequest);
                return this;
            }

            public ProtectedDimensionBatchUpdateRequest build() {
                return this.request;
            }
        }
    }
}

