/*
 * Decompiled with CFR 0.152.
 */
package cn.isliu.core.service;

import cn.isliu.core.client.FeishuApiClient;
import cn.isliu.core.client.FeishuClient;
import cn.isliu.core.pojo.ApiResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class CustomSheetService
extends FeishuApiClient {
    public CustomSheetService(FeishuClient feishuClient) {
        super(feishuClient);
    }

    public ApiResponse sheetsBatchUpdate(String spreadsheetToken, SheetBatchUpdateRequest request) throws IOException {
        List<SheetRequest> requests = request.getRequests();
        String userIdType = null;
        for (SheetRequest sheetRequest : requests) {
            UpdateSheetRequest updateSheet = sheetRequest.getUpdateSheet();
            if (updateSheet == null) continue;
            SheetPropertiesUpdate properties = updateSheet.getProperties();
            userIdType = properties.getUserIdType();
            break;
        }
        String url = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/sheets_batch_update";
        if (userIdType != null && !userIdType.isEmpty()) {
            url = url + "?user_id_type=" + userIdType;
        }
        RequestBody body = RequestBody.create((String)this.gson.toJson((Object)request), (MediaType)JSON_MEDIA_TYPE);
        Request httpRequest = this.createAuthenticatedRequest(url, "POST", body).build();
        return this.executeRequest(httpRequest, ApiResponse.class);
    }

    public static class Sheet {
        private String sheetId;
        private String title;
        private Integer index;
        private Integer rowCount;
        private Integer columnCount;
        private Boolean hidden;
        private Integer frozenRowCount;
        private Integer frozenColCount;

        public String getSheetId() {
            return this.sheetId;
        }

        public void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public Integer getRowCount() {
            return this.rowCount;
        }

        public void setRowCount(Integer rowCount) {
            this.rowCount = rowCount;
        }

        public Integer getColumnCount() {
            return this.columnCount;
        }

        public void setColumnCount(Integer columnCount) {
            this.columnCount = columnCount;
        }

        public Boolean getHidden() {
            return this.hidden;
        }

        public void setHidden(Boolean hidden) {
            this.hidden = hidden;
        }

        public Integer getFrozenRowCount() {
            return this.frozenRowCount;
        }

        public void setFrozenRowCount(Integer frozenRowCount) {
            this.frozenRowCount = frozenRowCount;
        }

        public Integer getFrozenColCount() {
            return this.frozenColCount;
        }

        public void setFrozenColCount(Integer frozenColCount) {
            this.frozenColCount = frozenColCount;
        }
    }

    public static class SheetProtect {
        private String lock;
        private String lockInfo;
        private List<String> userIDs;

        public String getLock() {
            return this.lock;
        }

        public void setLock(String lock) {
            this.lock = lock;
        }

        public String getLockInfo() {
            return this.lockInfo;
        }

        public void setLockInfo(String lockInfo) {
            this.lockInfo = lockInfo;
        }

        public List<String> getUserIDs() {
            return this.userIDs;
        }

        public void setUserIDs(List<String> userIDs) {
            this.userIDs = userIDs;
        }
    }

    public static class SheetPropertiesUpdate {
        private String sheetId;
        private String title;
        private Integer index;
        private Boolean hidden;
        private Integer frozenRowCount;
        private Integer frozenColCount;
        private SheetProtect protect;
        private String userIdType;

        public String getSheetId() {
            return this.sheetId;
        }

        public void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public Boolean getHidden() {
            return this.hidden;
        }

        public void setHidden(Boolean hidden) {
            this.hidden = hidden;
        }

        public Integer getFrozenRowCount() {
            return this.frozenRowCount;
        }

        public void setFrozenRowCount(Integer frozenRowCount) {
            this.frozenRowCount = frozenRowCount;
        }

        public Integer getFrozenColCount() {
            return this.frozenColCount;
        }

        public void setFrozenColCount(Integer frozenColCount) {
            this.frozenColCount = frozenColCount;
        }

        public SheetProtect getProtect() {
            return this.protect;
        }

        public void setProtect(SheetProtect protect) {
            this.protect = protect;
        }

        public String getUserIdType() {
            return this.userIdType;
        }

        public void setUserIdType(String userIdType) {
            this.userIdType = userIdType;
        }
    }

    public static class UpdateSheetRequest {
        private SheetPropertiesUpdate properties;

        public SheetPropertiesUpdate getProperties() {
            return this.properties;
        }

        public void setProperties(SheetPropertiesUpdate properties) {
            this.properties = properties;
        }
    }

    public static class DeleteSheetRequest {
        private String sheetId;

        public String getSheetId() {
            return this.sheetId;
        }

        public void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }
    }

    public static class SheetDestination {
        private String title;

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }

    public static class SheetSource {
        private String sheetId;

        public String getSheetId() {
            return this.sheetId;
        }

        public void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }
    }

    public static class CopySheetRequest {
        private SheetSource source;
        private SheetDestination destination;

        public SheetSource getSource() {
            return this.source;
        }

        public void setSource(SheetSource source) {
            this.source = source;
        }

        public SheetDestination getDestination() {
            return this.destination;
        }

        public void setDestination(SheetDestination destination) {
            this.destination = destination;
        }
    }

    public static class SheetProperties {
        private String title;
        private Integer index;

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }
    }

    public static class AddSheetRequest {
        private SheetProperties properties;

        public SheetProperties getProperties() {
            return this.properties;
        }

        public void setProperties(SheetProperties properties) {
            this.properties = properties;
        }
    }

    public static class SheetRequest {
        private AddSheetRequest addSheet;
        private CopySheetRequest copySheet;
        private DeleteSheetRequest deleteSheet;
        private UpdateSheetRequest updateSheet;

        public AddSheetRequest getAddSheet() {
            return this.addSheet;
        }

        public void setAddSheet(AddSheetRequest addSheet) {
            this.addSheet = addSheet;
        }

        public CopySheetRequest getCopySheet() {
            return this.copySheet;
        }

        public void setCopySheet(CopySheetRequest copySheet) {
            this.copySheet = copySheet;
        }

        public DeleteSheetRequest getDeleteSheet() {
            return this.deleteSheet;
        }

        public void setDeleteSheet(DeleteSheetRequest deleteSheet) {
            this.deleteSheet = deleteSheet;
        }

        public UpdateSheetRequest getUpdateSheet() {
            return this.updateSheet;
        }

        public void setUpdateSheet(UpdateSheetRequest updateSheet) {
            this.updateSheet = updateSheet;
        }

        public static AddSheetBuilder addSheet() {
            return new AddSheetBuilder();
        }

        public static CopySheetBuilder copySheet() {
            return new CopySheetBuilder();
        }

        public static DeleteSheetBuilder deleteSheet() {
            return new DeleteSheetBuilder();
        }

        public static UpdateSheetBuilder updateSheet() {
            return new UpdateSheetBuilder();
        }

        public static class UpdateSheetBuilder {
            private final SheetRequest request = new SheetRequest();
            private final UpdateSheetRequest updateSheet = new UpdateSheetRequest();

            public UpdateSheetBuilder() {
                this.request.setUpdateSheet(this.updateSheet);
            }

            private SheetPropertiesUpdate getProperties() {
                if (this.updateSheet.properties == null) {
                    this.updateSheet.properties = new SheetPropertiesUpdate();
                }
                return this.updateSheet.properties;
            }

            public UpdateSheetBuilder sheetId(String sheetId) {
                this.getProperties().sheetId = sheetId;
                return this;
            }

            public UpdateSheetBuilder title(String title) {
                this.getProperties().title = title;
                return this;
            }

            public UpdateSheetBuilder index(Integer index) {
                this.getProperties().index = index;
                return this;
            }

            public UpdateSheetBuilder hidden(Boolean hidden) {
                this.getProperties().hidden = hidden;
                return this;
            }

            public UpdateSheetBuilder frozenRowCount(Integer frozenRowCount) {
                this.getProperties().frozenRowCount = frozenRowCount;
                return this;
            }

            public UpdateSheetBuilder frozenColCount(Integer frozenColCount) {
                this.getProperties().frozenColCount = frozenColCount;
                return this;
            }

            public UpdateSheetBuilder userIdType(String userIdType) {
                this.getProperties().userIdType = userIdType;
                return this;
            }

            public UpdateSheetBuilder protect(String lock, String lockInfo, List<String> userIDs) {
                SheetPropertiesUpdate properties = this.getProperties();
                if (properties.protect == null) {
                    properties.protect = new SheetProtect();
                }
                properties.protect.lock = lock;
                properties.protect.lockInfo = lockInfo;
                properties.protect.userIDs = userIDs;
                return this;
            }

            public SheetRequest build() {
                return this.request;
            }
        }

        public static class DeleteSheetBuilder {
            private final SheetRequest request = new SheetRequest();
            private final DeleteSheetRequest deleteSheet = new DeleteSheetRequest();

            public DeleteSheetBuilder() {
                this.request.setDeleteSheet(this.deleteSheet);
            }

            public DeleteSheetBuilder sheetId(String sheetId) {
                this.deleteSheet.sheetId = sheetId;
                return this;
            }

            public SheetRequest build() {
                return this.request;
            }
        }

        public static class CopySheetBuilder {
            private final SheetRequest request = new SheetRequest();
            private final CopySheetRequest copySheet = new CopySheetRequest();

            public CopySheetBuilder() {
                this.request.setCopySheet(this.copySheet);
            }

            private SheetSource getSource() {
                if (this.copySheet.source == null) {
                    this.copySheet.source = new SheetSource();
                }
                return this.copySheet.source;
            }

            private SheetDestination getDestination() {
                if (this.copySheet.destination == null) {
                    this.copySheet.destination = new SheetDestination();
                }
                return this.copySheet.destination;
            }

            public CopySheetBuilder sourceSheetId(String sheetId) {
                this.getSource().sheetId = sheetId;
                return this;
            }

            public CopySheetBuilder destinationTitle(String title) {
                this.getDestination().title = title;
                return this;
            }

            public SheetRequest build() {
                return this.request;
            }
        }

        public static class AddSheetBuilder {
            private final SheetRequest request = new SheetRequest();
            private final AddSheetRequest addSheet = new AddSheetRequest();

            public AddSheetBuilder() {
                this.request.setAddSheet(this.addSheet);
            }

            private SheetProperties getProperties() {
                if (this.addSheet.properties == null) {
                    this.addSheet.properties = new SheetProperties();
                }
                return this.addSheet.properties;
            }

            public AddSheetBuilder title(String title) {
                this.getProperties().title = title;
                return this;
            }

            public AddSheetBuilder index(Integer index) {
                this.getProperties().index = index;
                return this;
            }

            public SheetRequest build() {
                return this.request;
            }
        }
    }

    public static class SheetBatchUpdateRequest {
        private List<SheetRequest> requests = new ArrayList<SheetRequest>();

        public List<SheetRequest> getRequests() {
            return this.requests;
        }

        public void setRequests(List<SheetRequest> requests) {
            this.requests = requests;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private final SheetBatchUpdateRequest request = new SheetBatchUpdateRequest();

            public Builder addRequest(SheetRequest sheetRequest) {
                this.request.requests.add(sheetRequest);
                return this;
            }

            public SheetBatchUpdateRequest build() {
                return this.request;
            }
        }
    }
}

