/*
 * Decompiled with CFR 0.152.
 */
package cn.isliu.core.service;

import cn.isliu.core.client.FeishuApiClient;
import cn.isliu.core.client.FeishuClient;
import cn.isliu.core.pojo.ApiResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class CustomValueService
extends FeishuApiClient {
    public CustomValueService(FeishuClient feishuClient) {
        super(feishuClient);
    }

    public ApiResponse valueBatchUpdate(String spreadsheetToken, ValueBatchUpdateRequest request) throws IOException {
        List<ValueRequest> requests = request.getRequests();
        ApiResponse response = null;
        if (requests == null || requests.isEmpty()) {
            ApiResponse emptyResponse = new ApiResponse();
            emptyResponse.setCode(400);
            emptyResponse.setMsg("No value operations found");
            return emptyResponse;
        }
        for (ValueRequest valueRequest : requests) {
            String params;
            String url;
            Request httpRequest;
            RequestBody body;
            Request httpRequest2;
            Request httpRequest3;
            RequestBody body2;
            String url2;
            if (valueRequest.getPrependValues() != null) {
                url2 = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/values_prepend";
                httpRequest3 = this.createAuthenticatedRequest(url2, "POST", body2 = RequestBody.create((String)this.gson.toJson((Object)valueRequest.getPrependValues()), (MediaType)JSON_MEDIA_TYPE)).build();
                response = this.executeRequest(httpRequest3, ApiResponse.class);
                if (response.success()) continue;
                return response;
            }
            if (valueRequest.getAppendValues() != null) {
                url2 = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/values_append";
                String insertDataOption = valueRequest.getAppendValues().getInsertDataOption();
                if (insertDataOption != null && !insertDataOption.isEmpty()) {
                    url2 = url2 + "?insertDataOption=" + insertDataOption;
                }
                if ((response = this.executeRequest(httpRequest2 = this.createAuthenticatedRequest(url2, "POST", body = RequestBody.create((String)this.gson.toJson((Object)valueRequest.getAppendValues()), (MediaType)JSON_MEDIA_TYPE)).build(), ApiResponse.class)).success()) continue;
                return response;
            }
            if (valueRequest.getImageValues() != null) {
                url2 = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/values_image";
                httpRequest3 = this.createAuthenticatedRequest(url2, "POST", body2 = RequestBody.create((String)this.gson.toJson((Object)valueRequest.getImageValues()), (MediaType)JSON_MEDIA_TYPE)).build();
                response = this.executeRequest(httpRequest3, ApiResponse.class);
                if (response.success()) continue;
                return response;
            }
            if (valueRequest.getGetValues() != null) {
                ValueGetRequest getValues = valueRequest.getGetValues();
                String baseUrl = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/values/" + getValues.getRange();
                StringBuilder urlBuilder = new StringBuilder(baseUrl);
                boolean hasParam = false;
                if (getValues.getValueRenderOption() != null && !getValues.getValueRenderOption().isEmpty()) {
                    urlBuilder.append(hasParam ? "&" : "?").append("valueRenderOption=").append(URLEncoder.encode(getValues.getValueRenderOption(), StandardCharsets.UTF_8.toString()));
                    hasParam = true;
                }
                if (getValues.getDateTimeRenderOption() != null && !getValues.getDateTimeRenderOption().isEmpty()) {
                    urlBuilder.append(hasParam ? "&" : "?").append("dateTimeRenderOption=").append(URLEncoder.encode(getValues.getDateTimeRenderOption(), StandardCharsets.UTF_8.toString()));
                    hasParam = true;
                }
                if (getValues.getUserIdType() != null && !getValues.getUserIdType().isEmpty()) {
                    urlBuilder.append(hasParam ? "&" : "?").append("user_id_type=").append(URLEncoder.encode(getValues.getUserIdType(), StandardCharsets.UTF_8.toString()));
                }
                if ((response = this.executeRequest(httpRequest = this.createAuthenticatedRequest(url = urlBuilder.toString(), "GET", null).build(), ApiResponse.class)).success()) continue;
                return response;
            }
            if (valueRequest.getBatchGetValues() != null) {
                ValueBatchGetRequest batchGetValues = valueRequest.getBatchGetValues();
                if (batchGetValues.getRanges() == null || batchGetValues.getRanges().isEmpty()) {
                    ApiResponse errorResponse = new ApiResponse();
                    errorResponse.setCode(400);
                    errorResponse.setMsg("Ranges cannot be empty for batch get values");
                    return errorResponse;
                }
                StringBuilder rangesBuilder = new StringBuilder();
                for (int i = 0; i < batchGetValues.getRanges().size(); ++i) {
                    if (i > 0) {
                        rangesBuilder.append(",");
                    }
                    rangesBuilder.append(batchGetValues.getRanges().get(i));
                }
                String baseUrl = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/values_batch_get";
                StringBuilder urlBuilder = new StringBuilder(baseUrl);
                urlBuilder.append("?ranges=").append(URLEncoder.encode(rangesBuilder.toString(), StandardCharsets.UTF_8.toString()));
                if (batchGetValues.getValueRenderOption() != null && !batchGetValues.getValueRenderOption().isEmpty()) {
                    urlBuilder.append("&valueRenderOption=").append(URLEncoder.encode(batchGetValues.getValueRenderOption(), StandardCharsets.UTF_8.toString()));
                }
                if (batchGetValues.getDateTimeRenderOption() != null && !batchGetValues.getDateTimeRenderOption().isEmpty()) {
                    urlBuilder.append("&dateTimeRenderOption=").append(URLEncoder.encode(batchGetValues.getDateTimeRenderOption(), StandardCharsets.UTF_8.toString()));
                }
                if (batchGetValues.getUserIdType() != null && !batchGetValues.getUserIdType().isEmpty()) {
                    urlBuilder.append("&user_id_type=").append(URLEncoder.encode(batchGetValues.getUserIdType(), StandardCharsets.UTF_8.toString()));
                }
                if ((response = this.executeRequest(httpRequest = this.createAuthenticatedRequest(url = urlBuilder.toString(), "GET", null).build(), ApiResponse.class)).success()) continue;
                return response;
            }
            if (!(valueRequest.getPutValues() != null ? !(response = this.executeRequest(httpRequest3 = this.createAuthenticatedRequest(url2 = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/values", "PUT", body2 = RequestBody.create((String)this.gson.toJson((Object)valueRequest.getPutValues()), (MediaType)JSON_MEDIA_TYPE)).build(), ApiResponse.class)).success() : valueRequest.getBatchPutValues() != null && !(response = this.executeRequest(httpRequest2 = this.createAuthenticatedRequest(url2 = "https://open.feishu.cn/open-apis/sheets/v2/spreadsheets/" + spreadsheetToken + "/values_batch_update", "POST", body = RequestBody.create((String)(params = this.gson.toJson((Object)valueRequest.getBatchPutValues())), (MediaType)JSON_MEDIA_TYPE)).build(), ApiResponse.class)).success())) continue;
            return response;
        }
        if (response == null) {
            ApiResponse errorResponse = new ApiResponse();
            errorResponse.setCode(400);
            errorResponse.setMsg("No valid value operation found");
            return errorResponse;
        }
        return response;
    }

    public static class ValueRangeItem {
        private String range;
        private String type;
        private List<List<Object>> values = new ArrayList<List<Object>>();

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }

        public List<List<Object>> getValues() {
            return this.values;
        }

        public void setValues(List<List<Object>> values) {
            this.values = values;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class ValueBatchUpdatePutRequest {
        private List<ValueRangeItem> valueRanges = new ArrayList<ValueRangeItem>();
        private String type;
        private String params;

        public List<ValueRangeItem> getValueRanges() {
            return this.valueRanges;
        }

        public void setValueRanges(List<ValueRangeItem> valueRanges) {
            this.valueRanges = valueRanges;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setParams(String params) {
            this.params = params;
        }

        public String getType() {
            return this.type;
        }

        public String getParams() {
            return this.params;
        }
    }

    public static class ValuePutRequest {
        private ValueRange valueRange;

        public ValueRange getValueRange() {
            return this.valueRange;
        }

        public void setValueRange(ValueRange valueRange) {
            this.valueRange = valueRange;
        }
    }

    public static class ValueBatchGetRequest {
        private List<String> ranges = new ArrayList<String>();
        private String valueRenderOption;
        private String dateTimeRenderOption;
        private String userIdType;
        private String type;
        private String params;

        public List<String> getRanges() {
            return this.ranges;
        }

        public void setRanges(List<String> ranges) {
            this.ranges = ranges;
        }

        public void addRange(String range) {
            if (this.ranges == null) {
                this.ranges = new ArrayList<String>();
            }
            this.ranges.add(range);
        }

        public String getValueRenderOption() {
            return this.valueRenderOption;
        }

        public void setValueRenderOption(String valueRenderOption) {
            this.valueRenderOption = valueRenderOption;
        }

        public String getDateTimeRenderOption() {
            return this.dateTimeRenderOption;
        }

        public void setDateTimeRenderOption(String dateTimeRenderOption) {
            this.dateTimeRenderOption = dateTimeRenderOption;
        }

        public String getUserIdType() {
            return this.userIdType;
        }

        public void setUserIdType(String userIdType) {
            this.userIdType = userIdType;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setParams(String params) {
            this.params = params;
        }

        public String getType() {
            return this.type;
        }

        public String getParams() {
            return this.params;
        }
    }

    public static class ValueGetRequest {
        private String range;
        private String valueRenderOption;
        private String dateTimeRenderOption;
        private String userIdType;

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }

        public String getValueRenderOption() {
            return this.valueRenderOption;
        }

        public void setValueRenderOption(String valueRenderOption) {
            this.valueRenderOption = valueRenderOption;
        }

        public String getDateTimeRenderOption() {
            return this.dateTimeRenderOption;
        }

        public void setDateTimeRenderOption(String dateTimeRenderOption) {
            this.dateTimeRenderOption = dateTimeRenderOption;
        }

        public String getUserIdType() {
            return this.userIdType;
        }

        public void setUserIdType(String userIdType) {
            this.userIdType = userIdType;
        }
    }

    public static class ValueImageRequest {
        private String range;
        private byte[] image;
        private String name;

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }

        public byte[] getImage() {
            return this.image;
        }

        public void setImage(byte[] image) {
            this.image = image;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class ValueAppendRequest {
        private ValueRange valueRange;
        private String insertDataOption;

        public ValueRange getValueRange() {
            return this.valueRange;
        }

        public void setValueRange(ValueRange valueRange) {
            this.valueRange = valueRange;
        }

        public String getInsertDataOption() {
            return this.insertDataOption;
        }

        public void setInsertDataOption(String insertDataOption) {
            this.insertDataOption = insertDataOption;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private final ValueAppendRequest request = new ValueAppendRequest();
            private final ValueRange valueRange = new ValueRange();

            public Builder() {
                this.request.setValueRange(this.valueRange);
            }

            public Builder range(String sheetId, String startPosition, String endPosition) {
                this.valueRange.setRange(sheetId + "!" + startPosition + ":" + endPosition);
                return this;
            }

            public Builder addRow(List<Object> rowData) {
                this.valueRange.getValues().add(rowData);
                return this;
            }

            public Builder addRow(Object ... values) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (Object value : values) {
                    row.add(value);
                }
                this.valueRange.getValues().add(row);
                return this;
            }

            public ValueAppendRequest build() {
                return this.request;
            }
        }
    }

    public static class ValuePrependRequest {
        private ValueRange valueRange;

        public ValueRange getValueRange() {
            return this.valueRange;
        }

        public void setValueRange(ValueRange valueRange) {
            this.valueRange = valueRange;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private final ValuePrependRequest request = new ValuePrependRequest();
            private final ValueRange valueRange = new ValueRange();

            public Builder() {
                this.request.setValueRange(this.valueRange);
            }

            public Builder range(String sheetId, String startPosition, String endPosition) {
                this.valueRange.setRange(sheetId + "!" + startPosition + ":" + endPosition);
                return this;
            }

            public Builder addRow(List<Object> rowData) {
                this.valueRange.getValues().add(rowData);
                return this;
            }

            public Builder addRow(Object ... values) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (Object value : values) {
                    row.add(value);
                }
                this.valueRange.getValues().add(row);
                return this;
            }

            public ValuePrependRequest build() {
                return this.request;
            }
        }
    }

    public static class ValueRange {
        private String range;
        private List<List<Object>> values = new ArrayList<List<Object>>();

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }

        public List<List<Object>> getValues() {
            return this.values;
        }

        public void setValues(List<List<Object>> values) {
            this.values = values;
        }
    }

    public static class ValueRequest {
        private ValuePrependRequest prependValues;
        private ValueAppendRequest appendValues;
        private ValueImageRequest imageValues;
        private ValueGetRequest getValues;
        private ValueBatchGetRequest batchGetValues;
        private ValuePutRequest putValues;
        private ValueBatchUpdatePutRequest batchPutValues;

        public ValuePrependRequest getPrependValues() {
            return this.prependValues;
        }

        public void setPrependValues(ValuePrependRequest prependValues) {
            this.prependValues = prependValues;
        }

        public ValueAppendRequest getAppendValues() {
            return this.appendValues;
        }

        public void setAppendValues(ValueAppendRequest appendValues) {
            this.appendValues = appendValues;
        }

        public ValueImageRequest getImageValues() {
            return this.imageValues;
        }

        public void setImageValues(ValueImageRequest imageValues) {
            this.imageValues = imageValues;
        }

        public ValueGetRequest getGetValues() {
            return this.getValues;
        }

        public void setGetValues(ValueGetRequest getValues) {
            this.getValues = getValues;
        }

        public ValueBatchGetRequest getBatchGetValues() {
            return this.batchGetValues;
        }

        public void setBatchGetValues(ValueBatchGetRequest batchGetValues) {
            this.batchGetValues = batchGetValues;
        }

        public ValuePutRequest getPutValues() {
            return this.putValues;
        }

        public void setPutValues(ValuePutRequest putValues) {
            this.putValues = putValues;
        }

        public ValueBatchUpdatePutRequest getBatchPutValues() {
            return this.batchPutValues;
        }

        public void setBatchPutValues(ValueBatchUpdatePutRequest batchPutValues) {
            this.batchPutValues = batchPutValues;
        }

        public static PrependValuesBuilder prependValues() {
            return new PrependValuesBuilder();
        }

        public static AppendValuesBuilder appendValues() {
            return new AppendValuesBuilder();
        }

        public static ImageValuesBuilder imageValues() {
            return new ImageValuesBuilder();
        }

        public static GetValuesBuilder getValues() {
            return new GetValuesBuilder();
        }

        public static BatchGetValuesBuilder batchGetValues() {
            return new BatchGetValuesBuilder();
        }

        public static PutValuesBuilder putValues() {
            return new PutValuesBuilder();
        }

        public static BatchPutValuesBuilder batchPutValues() {
            return new BatchPutValuesBuilder();
        }

        public static class BatchPutValuesBuilder {
            private final ValueRequest request = new ValueRequest();
            private final ValueBatchUpdatePutRequest batchPutValues = new ValueBatchUpdatePutRequest();
            private ValueRangeItem currentItem;

            public BatchPutValuesBuilder() {
                this.request.setBatchPutValues(this.batchPutValues);
            }

            public BatchPutValuesBuilder setReqType(String reqType) {
                this.batchPutValues.setType(reqType);
                return this;
            }

            public BatchPutValuesBuilder setReqParams(String reqParams) {
                this.batchPutValues.setParams(reqParams);
                return this;
            }

            public BatchPutValuesBuilder addRange(String range) {
                this.currentItem = new ValueRangeItem();
                this.currentItem.setRange(range);
                this.batchPutValues.getValueRanges().add(this.currentItem);
                return this;
            }

            public BatchPutValuesBuilder setType(String type) {
                this.currentItem.setType(type);
                return this;
            }

            public BatchPutValuesBuilder addRange(String sheetId, String startPosition, String endPosition) {
                String range = sheetId + "!" + startPosition + ":" + endPosition;
                return this.addRange(range);
            }

            public BatchPutValuesBuilder addRow(List<Object> rowData) {
                if (this.currentItem == null) {
                    throw new IllegalStateException("Must call addRange before addRow");
                }
                this.currentItem.getValues().add(rowData);
                return this;
            }

            public BatchPutValuesBuilder addRow(Object ... values) {
                if (this.currentItem == null) {
                    throw new IllegalStateException("Must call addRange before addRow");
                }
                ArrayList<Object> row = new ArrayList<Object>();
                for (Object value : values) {
                    row.add(value);
                }
                this.currentItem.getValues().add(row);
                return this;
            }

            public ValueRequest build() {
                return this.request;
            }
        }

        public static class PutValuesBuilder {
            private final ValueRequest request = new ValueRequest();
            private final ValuePutRequest putValues = new ValuePutRequest();
            private final ValueRange valueRange = new ValueRange();

            public PutValuesBuilder() {
                this.putValues.setValueRange(this.valueRange);
                this.request.setPutValues(this.putValues);
            }

            public PutValuesBuilder range(String sheetId, String startPosition, String endPosition) {
                this.valueRange.setRange(sheetId + "!" + startPosition + ":" + endPosition);
                return this;
            }

            public PutValuesBuilder addRow(List<Object> rowData) {
                this.valueRange.getValues().add(rowData);
                return this;
            }

            public PutValuesBuilder addRow(Object ... values) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (Object value : values) {
                    row.add(value);
                }
                this.valueRange.getValues().add(row);
                return this;
            }

            public ValueRequest build() {
                return this.request;
            }
        }

        public static class BatchGetValuesBuilder {
            private final ValueRequest request = new ValueRequest();
            private final ValueBatchGetRequest batchGetValues = new ValueBatchGetRequest();

            public BatchGetValuesBuilder() {
                this.request.setBatchGetValues(this.batchGetValues);
            }

            public BatchGetValuesBuilder addRange(String range) {
                this.batchGetValues.addRange(range);
                return this;
            }

            public BatchGetValuesBuilder addRange(String sheetId, String startPosition, String endPosition) {
                String range = sheetId + "!" + startPosition + ":" + endPosition;
                this.batchGetValues.addRange(range);
                return this;
            }

            public BatchGetValuesBuilder valueRenderOption(String valueRenderOption) {
                this.batchGetValues.setValueRenderOption(valueRenderOption);
                return this;
            }

            public BatchGetValuesBuilder dateTimeRenderOption(String dateTimeRenderOption) {
                this.batchGetValues.setDateTimeRenderOption(dateTimeRenderOption);
                return this;
            }

            public BatchGetValuesBuilder userIdType(String userIdType) {
                this.batchGetValues.setUserIdType(userIdType);
                return this;
            }

            public ValueRequest build() {
                return this.request;
            }
        }

        public static class GetValuesBuilder {
            private final ValueRequest request = new ValueRequest();
            private final ValueGetRequest getValues = new ValueGetRequest();

            public GetValuesBuilder() {
                this.request.setGetValues(this.getValues);
            }

            public GetValuesBuilder range(String sheetId, String startPosition, String endPosition) {
                this.getValues.setRange(sheetId + "!" + startPosition + ":" + endPosition);
                return this;
            }

            public GetValuesBuilder valueRenderOption(String valueRenderOption) {
                this.getValues.setValueRenderOption(valueRenderOption);
                return this;
            }

            public GetValuesBuilder dateTimeRenderOption(String dateTimeRenderOption) {
                this.getValues.setDateTimeRenderOption(dateTimeRenderOption);
                return this;
            }

            public GetValuesBuilder userIdType(String userIdType) {
                this.getValues.setUserIdType(userIdType);
                return this;
            }

            public ValueRequest build() {
                return this.request;
            }
        }

        public static class ImageValuesBuilder {
            private final ValueRequest request = new ValueRequest();
            private final ValueImageRequest imageValues = new ValueImageRequest();

            public ImageValuesBuilder() {
                this.request.setImageValues(this.imageValues);
            }

            public ImageValuesBuilder range(String range) {
                this.imageValues.setRange(range);
                return this;
            }

            public ImageValuesBuilder range(String sheetId, String position) {
                this.imageValues.setRange(sheetId + "!" + position + ":" + position);
                return this;
            }

            public ImageValuesBuilder range(String sheetId, String startPosition, String endPosition) {
                this.imageValues.setRange(sheetId + "!" + startPosition + ":" + endPosition);
                return this;
            }

            public ImageValuesBuilder image(byte[] image) {
                this.imageValues.setImage(image);
                return this;
            }

            public ImageValuesBuilder name(String name) {
                this.imageValues.setName(name);
                return this;
            }

            public ValueRequest build() {
                return this.request;
            }
        }

        public static class AppendValuesBuilder {
            private final ValueRequest request = new ValueRequest();
            private final ValueAppendRequest appendValues = new ValueAppendRequest();
            private final ValueRange valueRange = new ValueRange();

            public AppendValuesBuilder() {
                this.appendValues.setValueRange(this.valueRange);
                this.request.setAppendValues(this.appendValues);
            }

            public AppendValuesBuilder range(String range) {
                this.valueRange.setRange(range);
                return this;
            }

            public AppendValuesBuilder range(String sheetId, String startPosition, String endPosition) {
                this.valueRange.setRange(sheetId + "!" + startPosition + ":" + endPosition);
                return this;
            }

            public AppendValuesBuilder insertDataOption(String insertDataOption) {
                this.appendValues.setInsertDataOption(insertDataOption);
                return this;
            }

            public AppendValuesBuilder addRow(List<Object> rowData) {
                this.valueRange.getValues().add(rowData);
                return this;
            }

            public AppendValuesBuilder addRow(Object ... values) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (Object value : values) {
                    row.add(value);
                }
                this.valueRange.getValues().add(row);
                return this;
            }

            public ValueRequest build() {
                return this.request;
            }
        }

        public static class PrependValuesBuilder {
            private final ValueRequest request = new ValueRequest();
            private final ValuePrependRequest prependValues = new ValuePrependRequest();
            private final ValueRange valueRange = new ValueRange();

            public PrependValuesBuilder() {
                this.prependValues.setValueRange(this.valueRange);
                this.request.setPrependValues(this.prependValues);
            }

            public PrependValuesBuilder range(String range) {
                this.valueRange.setRange(range);
                return this;
            }

            public PrependValuesBuilder range(String sheetId, String startPosition, String endPosition) {
                this.valueRange.setRange(sheetId + "!" + startPosition + ":" + endPosition);
                return this;
            }

            public PrependValuesBuilder addRow(List<Object> rowData) {
                this.valueRange.getValues().add(rowData);
                return this;
            }

            public PrependValuesBuilder addRow(Object ... values) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (Object value : values) {
                    row.add(value);
                }
                this.valueRange.getValues().add(row);
                return this;
            }

            public ValueRequest build() {
                return this.request;
            }
        }
    }

    public static class ValueBatchUpdateRequest {
        private List<ValueRequest> requests = new ArrayList<ValueRequest>();

        public List<ValueRequest> getRequests() {
            return this.requests;
        }

        public void setRequests(List<ValueRequest> requests) {
            this.requests = requests;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private final ValueBatchUpdateRequest request = new ValueBatchUpdateRequest();

            public Builder addRequest(ValueRequest valueRequest) {
                this.request.requests.add(valueRequest);
                return this;
            }

            public ValueBatchUpdateRequest build() {
                return this.request;
            }
        }
    }
}

