/*
 * Decompiled with CFR 0.152.
 */
package cn.isliu.core.utils;

import cn.isliu.core.annotation.TableProperty;
import cn.isliu.core.converters.FieldValueProcess;
import cn.isliu.core.enums.BaseEnum;
import cn.isliu.core.enums.TypeEnum;
import cn.isliu.core.pojo.FieldProperty;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ConvertFieldUtil {
    private static final Logger log = Logger.getLogger(ConvertFieldUtil.class.getName());
    private static final Gson gson = new Gson();

    public static Map<String, Object> convertPositionToField(JsonObject jsonObject, Map<String, FieldProperty> fieldsMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String positionKey = (String)entry.getKey();
            FieldProperty fieldProperty = fieldsMap.get(positionKey);
            if (fieldProperty == null) continue;
            String fieldKey = fieldProperty.getField();
            TableProperty tableProperty = fieldProperty.getTableProperty();
            Object value = ConvertFieldUtil.getValueByFieldRule(tableProperty, (JsonElement)entry.getValue());
            if (fieldKey != null) {
                result.put(fieldKey, value);
                continue;
            }
            result.put(positionKey, value);
        }
        return result;
    }

    private static Object getValueByFieldRule(TableProperty tableProperty, JsonElement value) {
        if (tableProperty == null || value == null || value.isJsonNull()) {
            return null;
        }
        List result = null;
        TypeEnum typeEnum = tableProperty.type();
        if (Objects.nonNull((Object)typeEnum)) {
            switch (typeEnum) {
                case TEXT: 
                case NUMBER: 
                case DATE: {
                    result = ConvertFieldUtil.getJsonValue(value);
                    break;
                }
                case SINGLE_SELECT: {
                    List<String> arr = ConvertFieldUtil.parseStrToArr(value);
                    result = ConvertFieldUtil.conversionValue(tableProperty, arr.get(0));
                    break;
                }
                case MULTI_TEXT: {
                    result = ConvertFieldUtil.parseStrToArr(value);
                    break;
                }
                case MULTI_SELECT: {
                    List<String> values = ConvertFieldUtil.parseStrToArr(value);
                    result = values.stream().map(v -> ConvertFieldUtil.conversionValue(tableProperty, v)).collect(Collectors.toList());
                    break;
                }
                case TEXT_URL: {
                    result = ConvertFieldUtil.getTextUrl(value);
                    break;
                }
                case TEXT_FILE: {
                    result = ConvertFieldUtil.conversionValue(tableProperty, ConvertFieldUtil.getJsonValue(value));
                }
            }
        }
        return result;
    }

    private static Object getTextUrl(JsonElement value) {
        if (value instanceof JsonArray) {
            ArrayList<String> fileUrls = new ArrayList<String>();
            JsonArray arr = (JsonArray)value;
            for (int i = 0; i < arr.size(); ++i) {
                JsonObject jsonObject;
                String url;
                JsonElement jsonElement = arr.get(i);
                if (!jsonElement.isJsonObject() || (url = ConvertFieldUtil.getUrlByTextFile(jsonObject = jsonElement.getAsJsonObject())).isEmpty()) continue;
                fileUrls.add(url);
            }
            return String.join((CharSequence)",", fileUrls);
        }
        if (value instanceof JsonObject) {
            JsonObject jsb = (JsonObject)value;
            return ConvertFieldUtil.getUrlByTextFile(jsb);
        }
        return value;
    }

    private static Object getJsonValue(JsonElement value) {
        if (value.isJsonPrimitive()) {
            if (value.getAsJsonPrimitive().isString()) {
                String strValue = value.getAsString();
                if (strValue.length() >= 2 && (strValue.startsWith("\"") && strValue.endsWith("\"") || strValue.startsWith("'") && strValue.endsWith("'"))) {
                    return strValue.substring(1, strValue.length() - 1);
                }
                return strValue;
            }
            if (value.getAsJsonPrimitive().isNumber()) {
                return value.getAsNumber();
            }
            if (value.getAsJsonPrimitive().isBoolean()) {
                return value.getAsBoolean();
            }
        }
        return value;
    }

    private static String getUrlByTextFile(JsonObject jsb) {
        String url = "";
        String cellType = jsb.get("type").getAsString();
        if (cellType.equals("url")) {
            String link = jsb.get("link").getAsString();
            url = link == null ? jsb.get("text").getAsString() : link;
        }
        return url;
    }

    public static List<String> parseStrToArr(JsonElement value) {
        String result = "";
        if (value.isJsonPrimitive()) {
            if (value.getAsJsonPrimitive().isString()) {
                result = value.getAsString();
                if (result.length() >= 2 && (result.startsWith("\"") && result.endsWith("\"") || result.startsWith("'") && result.endsWith("'"))) {
                    result = result.substring(1, result.length() - 1);
                }
            } else {
                result = value.toString();
            }
        } else {
            result = value.isJsonArray() ? value.toString() : value.toString();
        }
        String[] split = result.split(",");
        return new ArrayList<String>(Arrays.asList(split));
    }

    private static Object conversionValue(TableProperty tableProperty, Object value) {
        Object result = value;
        if (value != null) {
            Class<? extends FieldValueProcess> fieldFormatClass;
            BaseEnum baseEnum;
            Class<? extends BaseEnum> enumClass = tableProperty.enumClass();
            if (enumClass != null && enumClass != BaseEnum.class && (baseEnum = BaseEnum.getByDesc(enumClass, value)) != null) {
                result = baseEnum.getCode();
            }
            if ((fieldFormatClass = tableProperty.fieldFormatClass()) != null && !fieldFormatClass.isInterface()) {
                try {
                    FieldValueProcess fieldValueProcess = fieldFormatClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    result = fieldValueProcess.process(result);
                }
                catch (InstantiationException e) {
                    log.log(Level.SEVERE, "\u65e0\u6cd5\u5b9e\u4f8b\u5316\u5b57\u6bb5\u683c\u5f0f\u5316\u7c7b: " + fieldFormatClass.getName(), e);
                }
                catch (IllegalAccessException e) {
                    log.log(Level.SEVERE, "\u65e0\u6cd5\u8bbf\u95ee\u5b57\u6bb5\u683c\u5f0f\u5316\u7c7b\u7684\u6784\u9020\u51fd\u6570: " + fieldFormatClass.getName(), e);
                }
                catch (NoSuchMethodException e) {
                    log.log(Level.SEVERE, "\u5b57\u6bb5\u683c\u5f0f\u5316\u7c7b\u7f3a\u5c11\u65e0\u53c2\u6784\u9020\u51fd\u6570: " + fieldFormatClass.getName(), e);
                }
                catch (InvocationTargetException e) {
                    log.log(Level.SEVERE, "\u5b57\u6bb5\u683c\u5f0f\u5316\u7c7b\u6784\u9020\u51fd\u6570\u8c03\u7528\u5f02\u5e38: " + fieldFormatClass.getName(), e);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "\u521b\u5efa\u5b57\u6bb5\u683c\u5f0f\u5316\u7c7b\u5b9e\u4f8b\u65f6\u53d1\u751f\u672a\u77e5\u5f02\u5e38: " + fieldFormatClass.getName(), e);
                }
            }
        }
        return result;
    }

    public static Object reverseValueConversion(TableProperty tableProperty, Object value) {
        Object result = value;
        if (value != null && tableProperty != null) {
            Class<? extends FieldValueProcess> fieldFormatClass;
            BaseEnum baseEnum;
            Class<? extends BaseEnum> enumClass = tableProperty.enumClass();
            if (enumClass != null && enumClass != BaseEnum.class && (baseEnum = BaseEnum.getByCode(enumClass, value)) != null) {
                result = baseEnum.getDesc();
            }
            if ((fieldFormatClass = tableProperty.fieldFormatClass()) != null && !fieldFormatClass.isInterface()) {
                try {
                    FieldValueProcess fieldValueProcess = fieldFormatClass.newInstance();
                    result = fieldValueProcess.reverseProcess(result);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    log.log(Level.FINE, "format value error", e);
                }
            }
        }
        return result;
    }
}

