/*
 * Decompiled with CFR 0.152.
 */
package cn.isliu.core.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);
    public static final String DEFAULT_FILE_PATH = "fs";

    public static byte[] getImageData(String filePath) {
        byte[] imageData;
        block15: {
            imageData = new byte[]{};
            try {
                if (filePath.startsWith("http")) {
                    URL url = new URL(filePath);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setDoInput(true);
                    connection.connect();
                    try (InputStream input = connection.getInputStream();){
                        imageData = FileUtil.readStream(input);
                        break block15;
                    }
                }
                File imageFile = new File(filePath);
                imageData = Files.readAllBytes(imageFile.toPath());
            }
            catch (IOException e) {
                log.error("\u3010\u5de8\u91cf\u5e7f\u544a\u52a9\u624b\u3011 \u8bfb\u53d6\u56fe\u7247\u6587\u4ef6\u5f02\u5e38\uff01\u53c2\u6570\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{filePath, e.getMessage(), e});
            }
        }
        return imageData;
    }

    public static byte[] readStream(InputStream input) throws IOException {
        int bytesRead;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = input.read(buffer)) != -1) {
            byteArrayOutputStream.write(buffer, 0, bytesRead);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(String fileURL, String savePath) {
        HttpURLConnection httpConn = null;
        try {
            URL url = new URL(fileURL);
            httpConn = (HttpURLConnection)url.openConnection();
            int responseCode = httpConn.getResponseCode();
            if (responseCode == 200) {
                int bytesRead;
                InputStream inputStream = httpConn.getInputStream();
                FileOutputStream outputStream = new FileOutputStream(savePath);
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                outputStream.close();
                inputStream.close();
                log.info("\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f\u3002\u4fdd\u5b58\u8def\u5f84: {}", (Object)savePath);
            } else {
                log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\u3002\u54cd\u5e94\u7801: {}", (Object)responseCode);
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\u3002", (Throwable)e);
        }
        finally {
            if (httpConn != null) {
                httpConn.disconnect();
            }
        }
    }

    public static String getRootPath() {
        File dir;
        String tempDir = System.getProperty("java.io.tmpdir") + File.separator + DEFAULT_FILE_PATH;
        if (!tempDir.endsWith(File.separator)) {
            tempDir = tempDir + File.separator;
        }
        if (!(dir = new File(tempDir)).exists()) {
            dir.mkdirs();
        }
        return tempDir;
    }
}

