/*
 * Decompiled with CFR 0.152.
 */
package cn.isliu.core.utils;

import cn.isliu.core.CopySheet;
import cn.isliu.core.Reply;
import cn.isliu.core.Sheet;
import cn.isliu.core.SheetMeta;
import cn.isliu.core.ValuesBatch;
import cn.isliu.core.client.FeishuClient;
import cn.isliu.core.exception.FsHelperException;
import cn.isliu.core.pojo.ApiResponse;
import cn.isliu.core.service.CustomCellService;
import cn.isliu.core.service.CustomDataValidationService;
import cn.isliu.core.service.CustomDimensionService;
import cn.isliu.core.service.CustomSheetService;
import cn.isliu.core.service.CustomValueService;
import cn.isliu.core.utils.FileUtil;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lark.oapi.service.drive.v1.model.BatchGetTmpDownloadUrlMediaReq;
import com.lark.oapi.service.drive.v1.model.BatchGetTmpDownloadUrlMediaResp;
import com.lark.oapi.service.drive.v1.model.BatchGetTmpDownloadUrlMediaRespBody;
import com.lark.oapi.service.drive.v1.model.DownloadMediaReq;
import com.lark.oapi.service.drive.v1.model.DownloadMediaResp;
import com.lark.oapi.service.sheets.v3.model.GetSpreadsheetReq;
import com.lark.oapi.service.sheets.v3.model.GetSpreadsheetResp;
import com.lark.oapi.service.sheets.v3.model.QuerySpreadsheetSheetReq;
import com.lark.oapi.service.sheets.v3.model.QuerySpreadsheetSheetResp;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FsApiUtil {
    private static final Gson gson = new Gson();
    private static final Logger log = Logger.getLogger(FsApiUtil.class.getName());
    private static final String REQ_TYPE = "JSON_STR";
    public static final int DEFAULT_ROW_NUM = 1000;

    public static ValuesBatch getSheetData(String sheetId, String spreadsheetToken, String startPosition, String endPosition, FeishuClient client) {
        ValuesBatch valuesBatch = null;
        try {
            CustomValueService.ValueRequest batchGetRequest = CustomValueService.ValueRequest.batchGetValues().addRange(sheetId, startPosition, endPosition).valueRenderOption("Formula").dateTimeRenderOption("FormattedString").build();
            CustomValueService.ValueBatchUpdateRequest getBatchRangesRequest = CustomValueService.ValueBatchUpdateRequest.newBuilder().addRequest(batchGetRequest).build();
            ApiResponse batchRangeResp = client.customValues().valueBatchUpdate(spreadsheetToken, getBatchRangesRequest);
            if (!batchRangeResp.success()) {
                log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011\u83b7\u53d6Sheet\u6570\u636e\u5931\u8d25\uff01 \u9519\u8bef\u4fe1\u606f\uff1a{0}", gson.toJson((Object)batchRangeResp));
                throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011\u83b7\u53d6Sheet\u6570\u636e\u5931\u8d25\uff01");
            }
            valuesBatch = (ValuesBatch)gson.fromJson(gson.toJson(batchRangeResp.getData()), ValuesBatch.class);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011\u83b7\u53d6Sheet\u6570\u636e\u5931\u8d25\uff01 \u9519\u8bef\u4fe1\u606f\uff1a{0}", e.getMessage());
            throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011\u83b7\u53d6Sheet\u6570\u636e\u5931\u8d25\uff01");
        }
        return valuesBatch;
    }

    public static Sheet getSheetMetadata(String sheetId, FeishuClient client, String spreadsheetToken) {
        try {
            QuerySpreadsheetSheetReq req = QuerySpreadsheetSheetReq.newBuilder().spreadsheetToken(spreadsheetToken).build();
            QuerySpreadsheetSheetResp resp = client.sheets().v3().spreadsheetSheet().query(req);
            if (resp.success()) {
                SheetMeta sheetMeta = (SheetMeta)gson.fromJson(gson.toJson(resp.getData()), SheetMeta.class);
                List<Sheet> sheets = sheetMeta.getSheets();
                AtomicReference sheet = new AtomicReference();
                sheets.forEach(s -> {
                    if (s.getSheetId().equals(sheetId)) {
                        sheet.set(s);
                    }
                });
                return (Sheet)sheet.get();
            }
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u83b7\u53d6Sheet\u5143\u6570\u636e\u5f02\u5e38\uff01\u9519\u8bef\u4fe1\u606f\uff1a{0}", gson.toJson((Object)resp));
            throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011 \u83b7\u53d6Sheet\u5143\u6570\u636e\u5f02\u5e38\uff01\u9519\u8bef\u4fe1\u606f\uff1a" + resp.getMsg());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u83b7\u53d6Sheet\u5143\u6570\u636e\u5f02\u5e38\uff01\u9519\u8bef\u4fe1\u606f\uff1a{0}", e.getMessage());
            throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011 \u83b7\u53d6Sheet\u5143\u6570\u636e\u5f02\u5e38\uff01");
        }
    }

    public static void mergeCells(String cell, String sheetId, FeishuClient client, String spreadsheetToken) {
        try {
            CustomCellService.CellBatchUpdateRequest batchMergeRequest = CustomCellService.CellBatchUpdateRequest.newBuilder().addRequest(CustomCellService.CellRequest.mergeCells().setReqType(REQ_TYPE).setReqParams(cell.replaceAll("%SHEET_ID%", sheetId)).build()).build();
            ApiResponse batchMergeResp = client.customCells().cellsBatchUpdate(spreadsheetToken, batchMergeRequest);
            if (!batchMergeResp.success()) {
                log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u5408\u5e76\u5355\u5143\u683c\u8bf7\u6c42\u5f02\u5e38\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{cell, batchMergeResp.getMsg()});
                throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011 \u5408\u5e76\u5355\u5143\u683c\u8bf7\u6c42\u5f02\u5e38\uff01");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u5408\u5e76\u5355\u5143\u683c\u5f02\u5e38\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{cell, e.getMessage()});
            throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011 \u5408\u5e76\u5355\u5143\u683c\u5f02\u5e38\uff01");
        }
    }

    public static void createTemplateHead(String head, String sheetId, FeishuClient client, String spreadsheetToken) {
        try {
            CustomValueService.ValueBatchUpdateRequest batchValueRequest = CustomValueService.ValueBatchUpdateRequest.newBuilder().addRequest(CustomValueService.ValueRequest.batchPutValues().setReqType(REQ_TYPE).setReqParams(head.replaceAll("%SHEET_ID%", sheetId)).build()).build();
            ApiResponse apiResponse = client.customValues().valueBatchUpdate(spreadsheetToken, batchValueRequest);
            if (!apiResponse.success()) {
                log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u5199\u5165\u8868\u683c\u5934\u6570\u636e\u5f02\u5e38\uff01\u9519\u8bef\u4fe1\u606f\uff1a{0}", apiResponse.getMsg());
                throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011 \u5199\u5165\u8868\u683c\u5934\u6570\u636e\u5f02\u5e38\uff01");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u5199\u5165\u8868\u683c\u5934\u5f02\u5e38\uff01\u9519\u8bef\u4fe1\u606f\uff1a{0}", e.getMessage());
            throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011 \u5199\u5165\u8868\u683c\u5934\u5f02\u5e38\uff01");
        }
    }

    public static void setTableStyle(String style, String sheetId, FeishuClient client, String spreadsheetToken) {
        try {
            CustomCellService.CellBatchUpdateRequest batchUpdateRequest = CustomCellService.CellBatchUpdateRequest.newBuilder().addRequest(CustomCellService.CellRequest.styleCellsBatch().setReqType(REQ_TYPE).setParams(style.replaceAll("%SHEET_ID%", sheetId)).build()).build();
            ApiResponse apiResponse = client.customCells().cellsBatchUpdate(spreadsheetToken, batchUpdateRequest);
            if (!apiResponse.success()) {
                log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u5199\u5165\u8868\u683c\u6837\u5f0f\u6570\u636e\u5f02\u5e38\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{style, apiResponse.getMsg()});
                throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011 \u5199\u5165\u8868\u683c\u6837\u5f0f\u6570\u636e\u5f02\u5e38\uff01");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u5199\u5165\u8868\u683c\u6837\u5f0f\u5f02\u5e38\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{style, e.getMessage()});
            throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011 \u5199\u5165\u8868\u683c\u6837\u5f0f\u5f02\u5e38\uff01");
        }
    }

    public static String createSheet(String title, FeishuClient client, String spreadsheetToken) {
        String sheetId;
        block4: {
            sheetId = null;
            try {
                CustomSheetService.SheetBatchUpdateRequest addSheetRequest = CustomSheetService.SheetBatchUpdateRequest.newBuilder().addRequest(CustomSheetService.SheetRequest.addSheet().title(title).build()).build();
                ApiResponse addResp = client.customSheets().sheetsBatchUpdate(spreadsheetToken, addSheetRequest);
                if (addResp.success()) {
                    log.log(Level.INFO, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u521b\u5efa sheet \u6210\u529f\uff01 {0}", gson.toJson((Object)addResp));
                    JsonObject jsObj = (JsonObject)gson.fromJson(gson.toJson(addResp.getData()), JsonObject.class);
                    JsonArray replies = jsObj.getAsJsonArray("replies");
                    JsonObject jsonObject = replies.get(0).getAsJsonObject();
                    Reply reply = (Reply)gson.fromJson((JsonElement)jsonObject, Reply.class);
                    sheetId = reply.getAddSheet().getProperties().getSheetId();
                    if (sheetId == null || sheetId.isEmpty()) {
                        log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u521b\u5efa sheet \u5931\u8d25\uff01");
                        throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011\u521b\u5efa sheet \u5f02\u5e38\uff01SheetId\u8fd4\u56de\u4e3a\u7a7a\uff01");
                    }
                    break block4;
                }
                log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u521b\u5efa sheet \u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a{0}", gson.toJson((Object)addResp));
                throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011 \u521b\u5efa sheet \u5f02\u5e38\uff01");
            }
            catch (Exception e) {
                String message = e.getMessage();
                log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u521b\u5efa sheet \u5f02\u5e38\uff01\u9519\u8bef\u4fe1\u606f\uff1a{0}", message);
                throw new FsHelperException(message != null && message.contains("403") ? "\u8bf7\u6309\u7167\u4e0a\u65b9\u64cd\u4f5c\uff0c\u5f53\u524d\u667a\u6295\u65e0\u6cd5\u64cd\u4f5c\u5bf9\u5e94\u6587\u6863\u54e6" : "\u3010\u98de\u4e66\u8868\u683c\u3011 \u521b\u5efa sheet \u5f02\u5e38\uff01");
            }
        }
        return sheetId;
    }

    public static String copySheet(String sourceSheetId, String title, FeishuClient client, String spreadsheetToken) {
        String sheetId = null;
        try {
            CustomSheetService.SheetBatchUpdateRequest copyRequest = CustomSheetService.SheetBatchUpdateRequest.newBuilder().addRequest(CustomSheetService.SheetRequest.copySheet().sourceSheetId(sourceSheetId).destinationTitle(title).build()).build();
            ApiResponse copyResp = client.customSheets().sheetsBatchUpdate(spreadsheetToken, copyRequest);
            if (copyResp.success()) {
                log.log(Level.INFO, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u590d\u5236 sheet \u6210\u529f\uff01 {0}", gson.toJson((Object)copyResp));
                JsonObject jsObj = (JsonObject)gson.fromJson(gson.toJson(copyResp.getData()), JsonObject.class);
                JsonArray replies = jsObj.getAsJsonArray("replies");
                JsonObject jsonObject = replies.get(0).getAsJsonObject();
                Reply reply = (Reply)gson.fromJson((JsonElement)jsonObject, Reply.class);
                CopySheet copySheet = reply.getCopySheet();
                sheetId = copySheet.getProperties().getSheetId();
                if (sheetId == null || sheetId.isEmpty()) {
                    throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011 \u590d\u5236\u6a21\u7248\u5f02\u5e38\uff01SheetID \u4e3a\u7a7a\uff01");
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u590d\u5236\u6a21\u7248\u5f02\u5e38\uff01\u9519\u8bef\u4fe1\u606f\uff1a{0}", e.getMessage());
            throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011 \u590d\u5236\u6a21\u7248\u5f02\u5e38\uff01");
        }
        return sheetId;
    }

    public static void setDateType(String sheetId, FeishuClient client, String spreadsheetToken, String conf, Integer headLine) {
        JsonObject confObj = (JsonObject)gson.fromJson(conf, JsonObject.class);
        String position = confObj.get("position").getAsString();
        String formatter = confObj.get("formatter").getAsString();
        if (position == null || position.trim().isEmpty()) {
            return;
        }
        try {
            CustomCellService.CellBatchUpdateRequest batchStyleRequest = CustomCellService.CellBatchUpdateRequest.newBuilder().addRequest(CustomCellService.CellRequest.styleCells().sheetId(sheetId).startPosition(position + headLine).endPosition(position + 1000).formatter(formatter).build()).build();
            ApiResponse batchStyleResp = client.customCells().cellsBatchUpdate(spreadsheetToken, batchStyleRequest);
            if (!batchStyleResp.success()) {
                log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u5199\u5165\u8868\u683c\u6837\u5f0f\u6570\u636e\u5f02\u5e38\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{conf, batchStyleResp.getMsg()});
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u5199\u5165\u8868\u683c\u6837\u5f0f\u6570\u636e\u5f02\u5e38\uff01", e);
        }
    }

    public static void setOptions(String sheetId, FeishuClient client, String spreadsheetToken, boolean isMulti, String startPosition, String endPosition, List<String> result) {
        try {
            CustomDataValidationService.DataValidationRequest listRequest = CustomDataValidationService.DataValidationRequest.listValidation().range(sheetId, startPosition, endPosition).addValues(result).multipleValues(isMulti).build();
            CustomDataValidationService.DataValidationBatchUpdateRequest batchRequest = CustomDataValidationService.DataValidationBatchUpdateRequest.newBuilder().addRequest(listRequest).build();
            ApiResponse response = client.customDataValidations().dataValidationBatchUpdate(spreadsheetToken, batchRequest);
            if (!response.success()) {
                log.log(Level.SEVERE, "\u8bbe\u7f6e\u4e0b\u62c9\u5217\u8868\u5931\u8d25\uff0c sheetId:{0}, startPosition:{1}, endPosition: {2}, \u8fd4\u56de\u4fe1\u606f:{3}", new Object[]{sheetId, startPosition, endPosition, gson.toJson((Object)response)});
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "\u8bbe\u7f6e\u4e0b\u62c9\u5217\u8868\u5931\u8d25\uff0csheetId:{0}", new Object[]{sheetId});
        }
    }

    public static void removeSheet(String sheetId, FeishuClient client, String spreadsheetToken) {
        try {
            CustomSheetService.SheetBatchUpdateRequest deleteRequest = CustomSheetService.SheetBatchUpdateRequest.newBuilder().addRequest(CustomSheetService.SheetRequest.deleteSheet().sheetId(sheetId).build()).build();
            ApiResponse deleteResp = client.customSheets().sheetsBatchUpdate(spreadsheetToken, deleteRequest);
            if (!deleteResp.success()) {
                log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u5220\u9664 sheet \u5931\u8d25\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{sheetId, deleteResp.getMsg()});
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u5220\u9664 sheet \u5f02\u5e38\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{sheetId, e.getMessage()});
        }
    }

    public static void downloadMaterial(String fileToken, String outputPath, FeishuClient client, String extra) {
        try {
            DownloadMediaReq req = DownloadMediaReq.newBuilder().fileToken(fileToken).build();
            DownloadMediaResp resp = client.drive().v1().media().download(req);
            if (resp.success()) {
                resp.writeFile(outputPath);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u4e0b\u8f7d\u7d20\u6750\u5f02\u5e38\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{fileToken, e.getMessage()});
            throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011 \u4e0b\u8f7d\u7d20\u6750\u5f02\u5e38\uff01");
        }
    }

    public static String downloadTmpMaterialUrl(String fileToken, FeishuClient client) {
        String tmpUrl = "";
        try {
            BatchGetTmpDownloadUrlMediaReq req = BatchGetTmpDownloadUrlMediaReq.newBuilder().fileTokens(new String[]{fileToken}).build();
            BatchGetTmpDownloadUrlMediaResp resp = client.drive().v1().media().batchGetTmpDownloadUrl(req);
            if (resp.success()) {
                return ((BatchGetTmpDownloadUrlMediaRespBody)resp.getData()).getTmpDownloadUrls()[0].getTmpDownloadUrl();
            }
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u83b7\u53d6\u4e34\u65f6\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{fileToken, gson.toJson((Object)resp)});
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u83b7\u53d6\u4e34\u65f6\u4e0b\u8f7d\u5730\u5740\u5f02\u5e38\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{fileToken, e.getMessage()});
        }
        return tmpUrl;
    }

    public static Object putValues(String spreadsheetToken, CustomValueService.ValueRequest putValuesBuilder, FeishuClient client) {
        log.log(Level.INFO, "\u3010\u98de\u4e66\u8868\u683c\u3011 putValues \u5f00\u59cb\u5199\u5165\u6570\u636e\uff01\u53c2\u6570\uff1a{0}", gson.toJson((Object)putValuesBuilder));
        CustomValueService.ValueBatchUpdateRequest putDataRequest = CustomValueService.ValueBatchUpdateRequest.newBuilder().addRequest(putValuesBuilder).build();
        try {
            ApiResponse putResp = client.customValues().valueBatchUpdate(spreadsheetToken, putDataRequest);
            if (putResp.success()) {
                return putResp.getData();
            }
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u5199\u5165\u8868\u683c\u6570\u636e\u5931\u8d25\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{putValuesBuilder, putResp.getMsg()});
            throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011 \u5199\u5165\u8868\u683c\u6570\u636e\u5931\u8d25\uff01");
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u5199\u5165\u8868\u683c\u6570\u636e\u5f02\u5e38\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{spreadsheetToken, e.getMessage()});
            throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011 \u5199\u5165\u8868\u683c\u6570\u636e\u5f02\u5e38\uff01");
        }
    }

    public static Object batchPutValues(String sheetId, String spreadsheetToken, CustomValueService.ValueRequest batchPutRequest, FeishuClient client) {
        log.log(Level.INFO, "\u3010\u98de\u4e66\u8868\u683c\u3011 batchPutValues \u5f00\u59cb\u5199\u5165\u6570\u636e\uff01\u53c2\u6570\uff1a{0}", gson.toJson((Object)batchPutRequest));
        try {
            CustomValueService.ValueBatchUpdateRequest batchPutDataRequest = CustomValueService.ValueBatchUpdateRequest.newBuilder().addRequest(batchPutRequest).build();
            ApiResponse batchPutResp = client.customValues().valueBatchUpdate(spreadsheetToken, batchPutDataRequest);
            if (batchPutResp.success()) {
                return batchPutResp.getData();
            }
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u6279\u91cf\u5199\u5165\u6570\u636e\u5931\u8d25\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{sheetId, gson.toJson((Object)batchPutResp)});
            throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011 \u6279\u91cf\u5199\u5165\u6570\u636e\u5931\u8d25\uff01");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u6279\u91cf\u5199\u5165\u6570\u636e\u5f02\u5e38\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{sheetId, e.getMessage()});
            throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011 \u6279\u91cf\u5199\u5165\u6570\u636e\u5f02\u5e38\uff01");
        }
    }

    public static Object addRowColumns(String sheetId, String spreadsheetToken, String type, int length, FeishuClient client) {
        CustomDimensionService.DimensionBatchUpdateRequest batchRequest = CustomDimensionService.DimensionBatchUpdateRequest.newBuilder().addRequest(CustomDimensionService.DimensionRequest.addDimension().sheetId(sheetId).majorDimension(type).length(length).build()).build();
        try {
            ApiResponse batchResp = client.customDimensions().dimensionsBatchUpdate(spreadsheetToken, batchRequest);
            if (batchResp.success()) {
                return batchResp.getData();
            }
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u6dfb\u52a0\u884c\u5217\u5931\u8d25\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{sheetId, gson.toJson((Object)batchResp)});
            throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011 \u6dfb\u52a0\u884c\u5217\u5931\u8d25\uff01");
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u6dfb\u52a0\u884c\u5217\u5f02\u5e38\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{sheetId, e.getMessage()});
            throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011 \u6dfb\u52a0\u884c\u5217\u5f02\u5e38\uff01");
        }
    }

    public static Object getTableInfo(String sheetId, String spreadsheetToken, FeishuClient client) {
        try {
            GetSpreadsheetReq req = GetSpreadsheetReq.newBuilder().spreadsheetToken(spreadsheetToken).build();
            GetSpreadsheetResp resp = client.sheets().v3().spreadsheet().get(req);
            if (resp.success()) {
                return resp.getData();
            }
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u83b7\u53d6\u8868\u683c\u4fe1\u606f\u5931\u8d25\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{sheetId, resp.getMsg()});
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u83b7\u53d6\u8868\u683c\u4fe1\u606f\u5f02\u5e38\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{sheetId, e.getMessage()});
        }
        return null;
    }

    public static void setCellType(String sheetId, String formatter, String startPosition, String endPosition, FeishuClient client, String spreadsheetToken) {
        try {
            CustomCellService.CellBatchUpdateRequest batchUpdateRequest = CustomCellService.CellBatchUpdateRequest.newBuilder().addRequest(CustomCellService.CellRequest.styleCells().formatter(formatter).sheetId(sheetId).startPosition(startPosition).endPosition(endPosition).build()).build();
            ApiResponse apiResponse = client.customCells().cellsBatchUpdate(spreadsheetToken, batchUpdateRequest);
            if (!apiResponse.success()) {
                log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u8bbe\u7f6e\u5355\u5143\u683c\u7c7b\u578b\u5931\u8d25\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{sheetId, apiResponse.getMsg()});
                throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011 \u6279\u91cf\u8bbe\u7f6e\u5355\u5143\u683c\u7c7b\u578b\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u8bbe\u7f6e\u5355\u5143\u683c\u7c7b\u578b\u5931\u8d25\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{sheetId, e.getMessage()});
            throw new FsHelperException("\u3010\u98de\u4e66\u8868\u683c\u3011 \u6279\u91cf\u8bbe\u7f6e\u5355\u5143\u683c\u7c7b\u578b\u5f02\u5e38\uff01");
        }
    }

    public static Object imageUpload(String filePath, String fileName, String position, String sheetId, String spreadsheetToken, FeishuClient client) {
        try {
            byte[] imageData = FileUtil.getImageData(filePath);
            CustomValueService.ValueRequest imageRequest = CustomValueService.ValueRequest.imageValues().range(sheetId, position).image(imageData).name(fileName).build();
            CustomValueService.ValueBatchUpdateRequest imageWriteRequest = CustomValueService.ValueBatchUpdateRequest.newBuilder().addRequest(imageRequest).build();
            ApiResponse imageResp = client.customValues().valueBatchUpdate(spreadsheetToken, imageWriteRequest);
            if (!imageResp.success()) {
                log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u56fe\u7247\u4e0a\u4f20\u5931\u8d25\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{filePath, gson.toJson((Object)imageResp)});
            }
            return imageResp.getData();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "\u3010\u98de\u4e66\u8868\u683c\u3011 \u56fe\u7247\u4e0a\u4f20\u5f02\u5e38\uff01\u53c2\u6570\uff1a{0}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{1}", new Object[]{filePath, e.getMessage()});
            return null;
        }
    }
}

