/*
 * Decompiled with CFR 0.152.
 */
package cn.isliu.core.utils;

import cn.isliu.core.Cell;
import cn.isliu.core.FsTableData;
import cn.isliu.core.GridProperties;
import cn.isliu.core.Merge;
import cn.isliu.core.MergedCell;
import cn.isliu.core.Sheet;
import cn.isliu.core.TableData;
import cn.isliu.core.TableRow;
import cn.isliu.core.ValueRange;
import cn.isliu.core.ValuesBatch;
import cn.isliu.core.annotation.TableProperty;
import cn.isliu.core.config.FsConfig;
import cn.isliu.core.converters.OptionsValueProcess;
import cn.isliu.core.enums.BaseEnum;
import cn.isliu.core.enums.TypeEnum;
import cn.isliu.core.pojo.FieldProperty;
import cn.isliu.core.service.CustomValueService;
import cn.isliu.core.utils.FsApiUtil;
import cn.isliu.core.utils.FsClientUtil;
import cn.isliu.core.utils.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class FsTableUtil {
    public static List<FsTableData> getFsTableData(Sheet sheet, String spreadsheetToken) {
        GridProperties gridProperties = sheet.getGridProperties();
        int totalRow = gridProperties.getRowCount();
        int rowCount = Math.min(totalRow, 100);
        int colCount = gridProperties.getColumnCount();
        int startOffset = 1;
        int actualRows = Math.max(0, totalRow - startOffset);
        int batchCount = (actualRows + rowCount - 1) / rowCount;
        LinkedList<List<Object>> values = new LinkedList<List<Object>>();
        for (int i = 0; i < batchCount; ++i) {
            int startRowIndex = startOffset + i * rowCount;
            int endRowIndex = Math.max(startRowIndex + rowCount - 1, totalRow - 1);
            ValuesBatch valuesBatch = FsApiUtil.getSheetData(sheet.getSheetId(), spreadsheetToken, "A" + startRowIndex, FsTableUtil.getColumnName(colCount - 1) + endRowIndex, FsClientUtil.getFeishuClient());
            if (valuesBatch == null) continue;
            List<ValueRange> valueRanges = valuesBatch.getValueRanges();
            for (ValueRange valueRange : valueRanges) {
                values.addAll(valueRange.getValues());
            }
        }
        TableData tableData = FsTableUtil.processSheetData(sheet, values);
        List<FsTableData> dataList = FsTableUtil.getFsTableData(tableData);
        HashMap titleMap = new HashMap();
        dataList.stream().filter(d -> d.getRow() == FsConfig.getTitleLine() - 1).findFirst().ifPresent(d -> {
            Map map = (Map)d.getData();
            titleMap.putAll(map);
        });
        return dataList.stream().filter(fsTableData -> fsTableData.getRow() >= FsConfig.getHeadLine()).map(item -> {
            HashMap resultMap = new HashMap();
            Map map = (Map)item.getData();
            map.forEach((k, v) -> {
                String title = (String)titleMap.get(k);
                if (title != null) {
                    resultMap.put(title, v);
                }
            });
            item.setData(resultMap);
            return item;
        }).collect(Collectors.toList());
    }

    private static List<FsTableData> getFsTableData(TableData tableData) {
        return FsTableUtil.getFsTableData(tableData, new ArrayList<String>());
    }

    private static List<FsTableData> getFsTableData(TableData tableData, List<String> ignoreUniqueFields) {
        LinkedList<FsTableData> fsTableList = new LinkedList<FsTableData>();
        for (TableRow row : tableData.getRows()) {
            String jsonStr;
            FsTableData fsTableData = new FsTableData();
            int rowIndex = 0;
            HashMap<String, Object> obj = new HashMap<String, Object>();
            for (Cell cell : row.getCells()) {
                obj.put(FsTableUtil.getColumnName(cell.getCol()), cell.getValue());
                rowIndex = cell.getRow();
            }
            fsTableData.setRow(rowIndex);
            fsTableData.setData(obj);
            if (!ignoreUniqueFields.isEmpty()) {
                HashMap<String, Object> clone = new HashMap<String, Object>(obj);
                ignoreUniqueFields.forEach(clone::remove);
                jsonStr = StringUtil.mapToJson(clone);
            } else {
                jsonStr = StringUtil.mapToJson(obj);
            }
            String uniqueId = StringUtil.getSHA256(jsonStr);
            fsTableData.setUniqueId(uniqueId);
            fsTableList.add(fsTableData);
        }
        return fsTableList;
    }

    public static TableData processSheetData(Sheet metadata, List<List<Object>> values) {
        int i;
        TableData tableData = new TableData();
        int rowCount = values.size();
        int colCount = values.stream().mapToInt(List::size).max().orElse(0);
        Cell[][] grid = new Cell[rowCount][colCount];
        for (i = 0; i < rowCount; ++i) {
            List<Object> row = values.get(i);
            for (int j = 0; j < colCount; ++j) {
                Object value = j < row.size() ? row.get(j) : null;
                grid[i][j] = new Cell(i, j, value);
            }
        }
        if (metadata.getMerges() != null) {
            for (Merge merge : metadata.getMerges()) {
                int startRow = merge.getStartRowIndex();
                int endRow = merge.getEndRowIndex();
                int startCol = merge.getStartColumnIndex();
                int endCol = merge.getEndColumnIndex();
                Object topLeftValue = null;
                if (startRow < rowCount && startCol < colCount) {
                    topLeftValue = grid[startRow][startCol].getValue();
                }
                for (int i2 = startRow; i2 <= endRow; ++i2) {
                    for (int j = startCol; j <= endCol; ++j) {
                        if (i2 >= rowCount || j >= colCount) continue;
                        grid[i2][j].setMerge(merge);
                        if (i2 == startRow && j == startCol) continue;
                        grid[i2][j].setValue(topLeftValue);
                    }
                }
            }
        }
        for (i = 0; i < rowCount; ++i) {
            boolean allNull = true;
            for (int j = 0; j < colCount; ++j) {
                if (grid[i][j].getValue() == null) continue;
                allNull = false;
                break;
            }
            if (allNull) continue;
            TableRow tableRow = new TableRow();
            for (int j = 0; j < colCount; ++j) {
                Cell cell = grid[i][j];
                if (cell.getMerge() != null && cell.getRow() == cell.getMerge().getStartRowIndex() && cell.getCol() == cell.getMerge().getStartColumnIndex()) {
                    MergedCell mergedCell = new MergedCell();
                    mergedCell.setValue(cell.getValue());
                    mergedCell.setRow(cell.getRow());
                    mergedCell.setCol(cell.getCol());
                    mergedCell.setRowSpan(cell.getMerge().getRowSpan());
                    mergedCell.setColSpan(cell.getMerge().getColSpan());
                    tableRow.getCells().add(mergedCell);
                    continue;
                }
                tableRow.getCells().add(cell);
            }
            tableData.getRows().add(tableRow);
        }
        return tableData;
    }

    public static String getColumnName(int columnIndex) {
        StringBuilder sb = new StringBuilder();
        while (columnIndex >= 0) {
            char c = (char)(65 + columnIndex % 26);
            sb.insert(0, c);
            if ((columnIndex = columnIndex / 26 - 1) >= 0) continue;
            break;
        }
        return sb.toString();
    }

    public static String getColumnNameByNuNumber(int columnNumber) {
        StringBuilder columnName = new StringBuilder();
        while (columnNumber > 0) {
            int remainder = (columnNumber - 1) % 26;
            columnName.insert(0, (char)(65 + remainder));
            columnNumber = (columnNumber - 1) / 26;
        }
        return columnName.toString();
    }

    public static Map<String, String> getTitlePostionMap(Sheet sheet, String spreadsheetToken) {
        List<Object> values;
        List<ValueRange> valueRanges;
        GridProperties gridProperties = sheet.getGridProperties();
        int colCount = gridProperties.getColumnCount();
        TreeMap<String, String> resultMap = new TreeMap<String, String>();
        ValuesBatch valuesBatch = FsApiUtil.getSheetData(sheet.getSheetId(), spreadsheetToken, "A" + FsConfig.getTitleLine(), FsTableUtil.getColumnName(colCount - 1) + FsConfig.getTitleLine(), FsClientUtil.getFeishuClient());
        if (valuesBatch != null && (valueRanges = valuesBatch.getValueRanges()) != null && !valueRanges.isEmpty() && (values = valueRanges.get(0).getValues().get(0)) != null && !values.isEmpty()) {
            for (int i = 0; i < values.size(); ++i) {
                Object valObj = values.get(i);
                if (valObj == null) continue;
                String value = (String)valObj;
                resultMap.put(value.trim(), FsTableUtil.getColumnName(i));
            }
        }
        return resultMap;
    }

    public static void setTableOptions(String spreadsheetToken, List<String> headers, Map<String, FieldProperty> fieldsMap, String sheetId) {
        List<Object> list = Arrays.asList(headers.toArray());
        fieldsMap.forEach((field, fieldProperty) -> {
            TableProperty tableProperty = fieldProperty.getTableProperty();
            String position = "";
            if (tableProperty != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Object obj = list.get(i);
                    if (!obj.toString().equals(field)) continue;
                    position = FsTableUtil.getColumnNameByNuNumber(i + 1);
                }
                int line = FsConfig.getTitleLine() + 1;
                if (tableProperty.enumClass() != BaseEnum.class) {
                    FsApiUtil.setOptions(sheetId, FsClientUtil.getFeishuClient(), spreadsheetToken, tableProperty.type() == TypeEnum.MULTI_SELECT, position + line, position + 200, Arrays.stream(tableProperty.enumClass().getEnumConstants()).map(BaseEnum::getDesc).collect(Collectors.toList()));
                }
                if (tableProperty.optionsClass() != OptionsValueProcess.class) {
                    List result;
                    Class<? extends OptionsValueProcess> optionsClass = tableProperty.optionsClass();
                    try {
                        OptionsValueProcess optionsValueProcess = optionsClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        result = (List)optionsValueProcess.process();
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                    FsApiUtil.setOptions(sheetId, FsClientUtil.getFeishuClient(), spreadsheetToken, tableProperty.type() == TypeEnum.MULTI_SELECT, position + line, position + 200, result);
                }
            }
        });
    }

    public static CustomValueService.ValueRequest getHeadTemplateBuilder(String sheetId, List<String> headers) {
        CustomValueService.ValueRequest.BatchPutValuesBuilder batchPutValuesBuilder = CustomValueService.ValueRequest.batchPutValues();
        batchPutValuesBuilder.addRange(sheetId + "!A1:" + FsTableUtil.getColumnNameByNuNumber(headers.size()) + "1");
        batchPutValuesBuilder.addRow(headers.toArray());
        return batchPutValuesBuilder.build();
    }

    public static String getDefaultTableStyle(String sheetId, int size) {
        String colorTemplate = "{\"data\": [{\"style\": {\"font\": {\"bold\": true, \"clean\": false, \"italic\": false, \"fontSize\": \"10pt/1.5\"}, \"clean\": false, \"hAlign\": 1, \"vAlign\": 1, \"backColor\": \"#000000\", \"foreColor\": \"#ffffff\", \"formatter\": \"\", \"borderType\": \"FULL_BORDER\", \"borderColor\": \"#000000\", \"textDecoration\": 0}, \"ranges\": [\"SHEET_ID!RANG\"]}]}";
        colorTemplate = colorTemplate.replace("SHEET_ID", sheetId);
        colorTemplate = colorTemplate.replace("RANG", "A1:" + FsTableUtil.getColumnNameByNuNumber(size) + "1");
        colorTemplate = colorTemplate.replace("FORE_COLOR", FsConfig.FORE_COLOR).replace("BACK_COLOR", FsConfig.BACK_COLOR);
        return colorTemplate;
    }
}

