/*
 * Decompiled with CFR 0.152.
 */
package cn.isliu.core.utils;

import cn.isliu.core.annotation.TableProperty;
import cn.isliu.core.enums.BaseEnum;
import cn.isliu.core.utils.ConvertFieldUtil;
import cn.isliu.core.utils.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class GenerateUtil {
    private static final Logger log = Logger.getLogger(GenerateUtil.class.getName());

    public static <T> T generateInstance(List<String> fieldPathList, Class<T> clazz, Map<String, Object> dataMap) {
        Object t;
        try {
            t = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efa\u5b9e\u4f8b\u5931\u8d25: " + clazz.getSimpleName(), e);
        }
        fieldPathList.forEach(fieldPath -> {
            Object value = dataMap.get(fieldPath);
            if (value != null) {
                try {
                    GenerateUtil.setNestedField(t, fieldPath, value);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "\u3010\u5de8\u91cf\u5e7f\u544a\u52a9\u624b\u3011 \u83b7\u53d6\u5b57\u6bb5\u503c\u5f02\u5e38\uff01\u53c2\u6570\uff1a{0}\uff0c\u5f02\u5e38\uff1a{1}", new Object[]{fieldPath, e.getMessage()});
                }
            }
        });
        return t;
    }

    private static void setNestedField(Object target, String fieldPath, Object value) throws Exception {
        String[] parts = fieldPath.split("\\.");
        GenerateUtil.setNestedFieldRecursive(target, parts, 0, value);
    }

    private static void setNestedFieldRecursive(Object target, String[] parts, int index, Object value) throws Exception {
        if (index >= parts.length - 1) {
            GenerateUtil.setFieldValue(target, parts[index], value);
            return;
        }
        String fieldName = parts[index];
        Field field = GenerateUtil.getDeclaredField(target.getClass(), fieldName);
        if (field == null && (field = GenerateUtil.getDeclaredField(target.getClass(), StringUtil.toCamelCase(fieldName))) == null) {
            throw new NoSuchFieldException("Field not found: " + fieldName);
        }
        field.setAccessible(true);
        ArrayList<Object> nestedObj = field.get(target);
        if (List.class.isAssignableFrom(field.getType())) {
            List list;
            if (nestedObj == null) {
                nestedObj = new ArrayList();
                field.set(target, nestedObj);
            }
            if ((list = (List)nestedObj).isEmpty()) {
                Object newElement = GenerateUtil.createListElement(field);
                list.add(newElement);
            }
            nestedObj = list.get(0);
        } else if (nestedObj == null) {
            try {
                nestedObj = field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                field.set(target, nestedObj);
            }
            catch (InstantiationException e) {
                log.log(Level.WARNING, "\u65e0\u6cd5\u521b\u5efa\u5d4c\u5957\u5bf9\u8c61\u5b9e\u4f8b: " + field.getType().getName() + ", \u5b57\u6bb5: " + fieldName, e);
                return;
            }
        }
        GenerateUtil.setNestedFieldRecursive(nestedObj, parts, index + 1, value);
    }

    private static Object createListElement(Field listField) throws Exception {
        Type[] typeArgs;
        Type genericType = listField.getGenericType();
        if (genericType instanceof ParameterizedType && (typeArgs = ((ParameterizedType)genericType).getActualTypeArguments()).length > 0 && typeArgs[0] instanceof Class) {
            Class elementClass = (Class)typeArgs[0];
            try {
                return elementClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "\u65e0\u6cd5\u521b\u5efaList\u5143\u7d20\u5b9e\u4f8b: " + elementClass.getName(), e);
                return null;
            }
        }
        throw new InstantiationException("Cannot determine list element type for field: " + listField.getName());
    }

    private static void setFieldValue(Object target, String fieldName, Object value) throws Exception {
        Field field = GenerateUtil.getDeclaredField(target.getClass(), fieldName);
        if (field == null && (field = GenerateUtil.getDeclaredField(target.getClass(), StringUtil.toCamelCase(fieldName))) == null) {
            throw new NoSuchFieldException("Field not found: " + fieldName);
        }
        field.setAccessible(true);
        Class<?> fieldType = field.getType();
        if (value != null) {
            if (fieldType == String.class) {
                field.set(target, GenerateUtil.convertStrValue(value));
            } else if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                field.set(target, Integer.parseInt(GenerateUtil.convertValue(value)));
            } else if (fieldType == Double.class || fieldType == Double.TYPE) {
                field.set(target, Double.parseDouble(GenerateUtil.convertValue(value)));
            } else if (fieldType == Boolean.class || fieldType == Boolean.TYPE) {
                field.set(target, Boolean.parseBoolean(GenerateUtil.convertValue(value)));
            } else if (fieldType == Long.class || fieldType == Long.TYPE) {
                String stringValue = GenerateUtil.convertValue(value);
                try {
                    field.set(target, Long.parseLong(stringValue));
                }
                catch (NumberFormatException e) {
                    try {
                        field.set(target, Double.valueOf(Double.parseDouble(stringValue)).longValue());
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("\u65e0\u6cd5\u5c06\u503c '" + stringValue + "' \u8f6c\u6362\u4e3a long \u6216\u79d1\u5b66\u8ba1\u6570\u6cd5\u8868\u793a\u7684\u6570\u503c", ex);
                    }
                }
            } else if (fieldType == List.class) {
                Type genericType = field.getGenericType();
                if (!(genericType instanceof ParameterizedType)) {
                    throw new IllegalArgumentException("\u65e0\u6cd5\u83b7\u53d6\u5b57\u6bb5\u7684\u6cdb\u578b\u4fe1\u606f\uff1a" + fieldName);
                }
                Type elementType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                if (!(elementType instanceof Class)) {
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u975eClass\u7c7b\u578b\u7684\u6cdb\u578b\uff1a" + elementType);
                }
                Class elementClass = (Class)elementType;
                ArrayList<Object> convertedList = new ArrayList<Object>();
                if (value instanceof List) {
                    for (Object item : (List)value) {
                        convertedList.add(GenerateUtil.convertValue(item, elementClass));
                    }
                } else {
                    convertedList.add(GenerateUtil.convertValue(value, elementClass));
                }
                field.set(target, convertedList);
            } else if (BaseEnum.class.isAssignableFrom(fieldType)) {
                if (value instanceof String) {
                    field.set(target, GenerateUtil.parseEnum(fieldType, (String)value));
                }
            } else {
                field.set(target, value);
            }
        } else {
            field.set(target, null);
        }
    }

    private static Field getDeclaredField(Class<?> clazz, String fieldName) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            try {
                return c.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        String camelCaseFieldName = StringUtil.toCamelCase(fieldName);
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            try {
                return c.getDeclaredField(camelCaseFieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    private static String convertStrValue(Object value) {
        String result = "";
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            result = bigDecimal.stripTrailingZeros().toPlainString();
        } else if (value instanceof Double) {
            String stringValue = GenerateUtil.convertValue(value);
            try {
                result = String.valueOf(Long.parseLong(stringValue));
            }
            catch (NumberFormatException e) {
                try {
                    result = String.valueOf(Double.valueOf(Double.parseDouble(stringValue)).longValue());
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("\u65e0\u6cd5\u5c06\u503c '" + stringValue + "' \u8f6c\u6362\u4e3a long \u6216\u79d1\u5b66\u8ba1\u6570\u6cd5\u8868\u793a\u7684\u6570\u503c", ex);
                }
            }
        } else {
            result = String.valueOf(value);
        }
        return result.trim();
    }

    private static String convertValue(Object value) {
        String result = "";
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            result = bigDecimal.stripTrailingZeros().toPlainString();
        } else {
            result = String.valueOf(value);
        }
        return result.trim();
    }

    private static Object convertValue(Object value, Class<?> targetType) throws Exception {
        if (value == null) {
            return null;
        }
        if (targetType.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (targetType == String.class) {
            return value.toString().trim();
        }
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            return Integer.parseInt(value.toString().trim());
        }
        if (targetType == Double.class || targetType == Double.TYPE) {
            return Double.parseDouble(value.toString().trim());
        }
        if (targetType == Long.class || targetType == Long.TYPE) {
            return Long.parseLong(value.toString().trim());
        }
        if (BaseEnum.class.isAssignableFrom(targetType)) {
            if (value instanceof String) {
                return GenerateUtil.parseEnum(targetType, (String)value);
            }
            throw new IllegalArgumentException("\u679a\u4e3e\u7c7b\u578b\u5b57\u6bb5\u53ea\u63a5\u53d7\u5b57\u7b26\u4e32\u7c7b\u578b\u7684\u503c");
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684List\u5143\u7d20\u7c7b\u578b\u8f6c\u6362\uff1a" + targetType.getName());
    }

    public static <T extends BaseEnum> T parseEnum(Class<T> enumClass, String value) {
        String val = value.trim();
        return (T)Arrays.stream(enumClass.getEnumConstants()).filter(e -> e.getCode().equals(val) || e.getDesc().equals(val)).findFirst().orElseThrow(() -> new IllegalArgumentException("No matching enum for value: " + val));
    }

    public static Map<String, Object> getFieldValue(Object target, Map<String, String> fieldMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
            String fieldName = entry.getKey();
            String fieldPath = entry.getValue();
            try {
                Object value = GenerateUtil.getNestedFieldValue(target, fieldPath);
                if (value == null) continue;
                result.put(fieldName, value);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "\u83b7\u53d6\u5b57\u6bb5\u503c\u5f02\u5e38\uff0c\u5b57\u6bb5\u8def\u5f84\uff1a" + fieldPath, e);
            }
        }
        return result;
    }

    public static Object getNestedFieldValue(Object target, String fieldPath) throws Exception {
        String[] parts = fieldPath.split("\\.");
        return GenerateUtil.getNestedFieldValueRecursive(target, parts, 0);
    }

    private static Object getNestedFieldValueRecursive(Object target, String[] parts, int index) throws Exception {
        if (target == null) {
            return null;
        }
        if (index >= parts.length - 1) {
            return GenerateUtil.getFieldValue(target, parts[index]);
        }
        String fieldName = parts[index];
        Field field = GenerateUtil.getDeclaredField(target.getClass(), fieldName);
        if (field == null && (field = GenerateUtil.getDeclaredField(target.getClass(), StringUtil.toCamelCase(fieldName))) == null) {
            throw new NoSuchFieldException("Field not found: " + fieldName);
        }
        field.setAccessible(true);
        Object nestedObj = field.get(target);
        if (nestedObj instanceof List) {
            List list = (List)nestedObj;
            if (!list.isEmpty()) {
                nestedObj = list.get(0);
            } else {
                return null;
            }
        }
        return GenerateUtil.getNestedFieldValueRecursive(nestedObj, parts, index + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object getFieldValue(Object target, String fieldName) throws Exception {
        Field field = GenerateUtil.getDeclaredField(target.getClass(), fieldName);
        if (field == null && (field = GenerateUtil.getDeclaredField(target.getClass(), StringUtil.toCamelCase(fieldName))) == null) {
            throw new NoSuchFieldException("Field not found: " + fieldName);
        }
        field.setAccessible(true);
        List newObject = field.get(target);
        if (!(newObject instanceof List)) return ConvertFieldUtil.reverseValueConversion(field.getAnnotation(TableProperty.class), newObject);
        List list = newObject;
        if (list.isEmpty()) return null;
        Field finalField = field;
        return list.stream().map(obj -> ConvertFieldUtil.reverseValueConversion(finalField.getAnnotation(TableProperty.class), obj)).collect(Collectors.toList());
    }

    public static Object getFieldValueList(Object fieldValue) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("values", fieldValue);
        params.put("type", "multipleValue");
        return params;
    }

    @Nullable
    public static <T> String getUniqueId(T data) {
        String uniqueId = null;
        try {
            Object uniqueIdObj = GenerateUtil.getNestedFieldValue(data, "uniqueId");
            if (uniqueIdObj != null) {
                uniqueId = uniqueIdObj.toString();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return uniqueId;
    }
}

