/*
 * Decompiled with CFR 0.152.
 */
package cn.isliu.core.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;

public class JSONUtil {
    private static final Gson gson = new Gson();

    public static JsonObject convertHashMapToJsonObject(HashMap<String, Object> data) {
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                String strValue = (String)value;
                if (strValue.length() >= 2 && strValue.startsWith("\"") && strValue.endsWith("\"")) {
                    strValue = strValue.substring(1, strValue.length() - 1);
                }
                jsonObject.addProperty(key, strValue);
                continue;
            }
            if (value instanceof Number) {
                jsonObject.addProperty(key, (Number)value);
                continue;
            }
            if (value instanceof Boolean) {
                jsonObject.addProperty(key, (Boolean)value);
                continue;
            }
            if (value instanceof Character) {
                jsonObject.addProperty(key, (Character)value);
                continue;
            }
            if (value == null) {
                jsonObject.add(key, null);
                continue;
            }
            JsonElement element = gson.toJsonTree(value);
            jsonObject.add(key, element);
        }
        return jsonObject;
    }
}

