/*
 * Decompiled with CFR 0.152.
 */
package cn.isliu.core.utils;

import cn.isliu.core.annotation.TableProperty;
import cn.isliu.core.converters.FieldValueProcess;
import cn.isliu.core.converters.OptionsValueProcess;
import cn.isliu.core.enums.BaseEnum;
import cn.isliu.core.enums.TypeEnum;
import cn.isliu.core.pojo.FieldProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class PropertyUtil {
    public static Map<String, FieldProperty> getTablePropertyFieldsMap(Class<?> clazz) {
        TreeMap<String, FieldProperty> allFields = new TreeMap<String, FieldProperty>();
        TreeMap<String, String> fieldsWithChildren = new TreeMap<String, String>();
        PropertyUtil.getTablePropertyFieldsMapRecursive(clazz, allFields, "", "", new HashMap(), fieldsWithChildren, false);
        HashMap<String, FieldProperty> result = new HashMap<String, FieldProperty>();
        for (Map.Entry entry : allFields.entrySet()) {
            if (fieldsWithChildren.containsKey(entry.getKey())) continue;
            result.put((String)entry.getKey(), (FieldProperty)entry.getValue());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getTablePropertyFieldsMapRecursive(Class<?> clazz, Map<String, FieldProperty> result, String keyPrefix, String valuePrefix, Map<Class<?>, Integer> depthMap, Map<String, String> fieldsWithChildren, boolean parentHasAnnotation) {
        if (!PropertyUtil.isTargetPackageClass(clazz)) {
            return;
        }
        Integer currentDepth = depthMap.getOrDefault(clazz, 0);
        if (currentDepth > 5) {
            if (!keyPrefix.isEmpty()) {
                TableProperty dummyAnnotation = PropertyUtil.createDummyTableProperty(valuePrefix);
                result.put(keyPrefix, new FieldProperty(valuePrefix, dummyAnnotation));
            }
            return;
        }
        depthMap.put(clazz, currentDepth + 1);
        try {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (field.isAnnotationPresent(TableProperty.class)) {
                    TableProperty tableProperty = field.getAnnotation(TableProperty.class);
                    String[] propertyValues = tableProperty.value().split("\\.");
                    String propertyValue = propertyValues.length > 0 && !propertyValues[0].isEmpty() ? propertyValues[0] : field.getName();
                    PropertyUtil.processFieldForMap(field, propertyValue, keyPrefix, valuePrefix, result, depthMap, fieldsWithChildren, parentHasAnnotation);
                    continue;
                }
                PropertyUtil.processFieldWithoutAnnotation(field, keyPrefix, valuePrefix, result, depthMap, fieldsWithChildren, parentHasAnnotation);
            }
        }
        finally {
            if (currentDepth == 0) {
                depthMap.remove(clazz);
            } else {
                depthMap.put(clazz, currentDepth);
            }
        }
    }

    private static boolean isTargetPackageClass(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        String className = clazz.getName();
        return !className.startsWith("java.") && !className.startsWith("javax.") && !className.startsWith("sun.") && !className.startsWith("com.sun.") && !className.startsWith("jdk.");
    }

    private static TableProperty createDummyTableProperty(final String value) {
        return new TableProperty(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return TableProperty.class;
            }

            @Override
            public String value() {
                return value;
            }

            @Override
            public String field() {
                return "";
            }

            @Override
            public int order() {
                return Integer.MAX_VALUE;
            }

            @Override
            public TypeEnum type() {
                return TypeEnum.TEXT;
            }

            @Override
            public Class<? extends BaseEnum> enumClass() {
                return BaseEnum.class;
            }

            @Override
            public Class<? extends FieldValueProcess> fieldFormatClass() {
                return FieldValueProcess.class;
            }

            @Override
            public Class<? extends OptionsValueProcess> optionsClass() {
                return OptionsValueProcess.class;
            }
        };
    }

    private static void processFieldForMap(Field field, String fieldPropertyName, String keyPrefix, String valuePrefix, Map<String, FieldProperty> result, Map<Class<?>, Integer> depthMap, Map<String, String> fieldsWithChildren, boolean parentHasAnnotation) {
        String fullKey = keyPrefix.isEmpty() ? fieldPropertyName : keyPrefix + "." + fieldPropertyName;
        String fullValue = valuePrefix.isEmpty() ? field.getName() : valuePrefix + "." + field.getName();
        TableProperty tableProperty = field.getAnnotation(TableProperty.class);
        Class<?> fieldType = field.getType();
        if (PropertyUtil.isComplexType(fieldType)) {
            HashMap<String, FieldProperty> subFields = new HashMap<String, FieldProperty>();
            HashMap<String, String> subFieldsWithChildren = new HashMap<String, String>();
            if (Collection.class.isAssignableFrom(fieldType)) {
                ParameterizedType parameterizedType;
                Type[] actualTypeArguments;
                Type genericType = field.getGenericType();
                if (genericType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length > 0 && actualTypeArguments[0] instanceof Class) {
                    Class elementType = (Class)actualTypeArguments[0];
                    PropertyUtil.getTablePropertyFieldsMapRecursive(elementType, subFields, fullKey, fullValue, depthMap, subFieldsWithChildren, true);
                }
            } else {
                PropertyUtil.getTablePropertyFieldsMapRecursive(fieldType, subFields, fullKey, fullValue, depthMap, subFieldsWithChildren, true);
            }
            result.putAll(subFields);
            if (!subFields.isEmpty()) {
                fieldsWithChildren.put(fullKey, fullValue);
                fieldsWithChildren.putAll(subFieldsWithChildren);
            } else {
                result.put(fullKey, new FieldProperty(fullValue, tableProperty));
            }
        } else {
            result.put(fullKey, new FieldProperty(fullValue, tableProperty));
        }
    }

    private static void processFieldWithoutAnnotation(Field field, String keyPrefix, String valuePrefix, Map<String, FieldProperty> result, Map<Class<?>, Integer> depthMap, Map<String, String> fieldsWithChildren, boolean parentHasAnnotation) {
        Class<?> fieldType = field.getType();
        if (PropertyUtil.isComplexType(fieldType)) {
            String newValuePrefix;
            String string = newValuePrefix = valuePrefix.isEmpty() ? field.getName() : valuePrefix + "." + field.getName();
            String newKeyPrefix = parentHasAnnotation ? (keyPrefix.isEmpty() ? field.getName() : keyPrefix + "." + field.getName()) : "";
            HashMap<String, FieldProperty> subFields = new HashMap<String, FieldProperty>();
            HashMap<String, String> subFieldsWithChildren = new HashMap<String, String>();
            if (Collection.class.isAssignableFrom(fieldType)) {
                ParameterizedType parameterizedType;
                Type[] actualTypeArguments;
                Type genericType = field.getGenericType();
                if (genericType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length > 0 && actualTypeArguments[0] instanceof Class) {
                    Class elementType = (Class)actualTypeArguments[0];
                    PropertyUtil.getTablePropertyFieldsMapRecursive(elementType, subFields, newKeyPrefix, newValuePrefix, depthMap, subFieldsWithChildren, false);
                }
            } else {
                PropertyUtil.getTablePropertyFieldsMapRecursive(fieldType, subFields, newKeyPrefix, newValuePrefix, depthMap, subFieldsWithChildren, false);
            }
            result.putAll(subFields);
            if (!subFields.isEmpty()) {
                String currentPath = keyPrefix.isEmpty() ? field.getName() : keyPrefix + "." + field.getName();
                fieldsWithChildren.put(currentPath, newValuePrefix);
                fieldsWithChildren.putAll(subFieldsWithChildren);
            }
        }
    }

    private static boolean isComplexType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return false;
        }
        return !clazz.equals(String.class) && !clazz.equals(Integer.class) && !clazz.equals(Long.class) && !clazz.equals(Boolean.class) && !clazz.equals(Double.class) && !clazz.equals(Float.class) && !clazz.equals(Character.class) && !clazz.equals(Byte.class) && !clazz.equals(Short.class) && !clazz.equals(Date.class) && !clazz.equals(LocalDate.class) && !clazz.equals(LocalDateTime.class);
    }

    @NotNull
    public static List<String> getHeaders(Map<String, FieldProperty> fieldsMap) {
        return fieldsMap.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((FieldProperty)entry.getValue()).getTableProperty().order())).map(Map.Entry::getKey).collect(Collectors.toList());
    }
}

