/*
 * Decompiled with CFR 0.152.
 */
package cn.isliu.core.utils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class StringUtil {
    public static String mapToJson(Map<String, Object> map) {
        StringBuilder jsonBuilder = new StringBuilder();
        jsonBuilder.append("{");
        Object[] keys = map.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            Object value = map.get(key);
            jsonBuilder.append("\"").append(key).append("\":");
            if (value instanceof String) {
                jsonBuilder.append("\"").append(value).append("\"");
            } else {
                jsonBuilder.append(value);
            }
            if (i >= keys.length - 1) continue;
            jsonBuilder.append(",");
        }
        jsonBuilder.append("}");
        return jsonBuilder.toString();
    }

    public static String getSHA256(String str) {
        String uniqueId;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(str.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            uniqueId = hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not available", e);
        }
        return uniqueId;
    }

    public static String toCamelCase(String underscoreName) {
        if (underscoreName == null || underscoreName.isEmpty()) {
            return underscoreName;
        }
        StringBuilder result = new StringBuilder();
        boolean capitalizeNext = false;
        for (char c : underscoreName.toCharArray()) {
            if (c == '_') {
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                result.append(Character.toUpperCase(c));
                capitalizeNext = false;
                continue;
            }
            result.append(Character.toLowerCase(c));
        }
        return result.toString();
    }

    public static String joinWithComma(Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            sb.append(obj != null ? obj.toString() : "");
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static String joinWithComma(Object[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i] != null ? array[i].toString() : "");
            if (i >= array.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

