/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.startup;

import cn.jants.core.startup.assembly.FilterAssembly;
import cn.jants.core.startup.assembly.ServletAssembly;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

public class CommonProperty {
    public int port = 8080;
    public String contextPath;
    public String webApp;
    public Integer maxConnections = 2000;
    public Integer maxThreads = 2000;
    public Integer connectionTimeout = 30000;
    public String charset = "UTF-8";
    public List<ServletAssembly> servlets;
    public List<FilterAssembly> filters;
    public Class loadClass;
    public boolean isOpen = false;

    public CommonProperty(String webApp, int port, String contextPath, Class loadClass, boolean isOpen) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port of web server: " + port);
        }
        this.webApp = webApp;
        this.port = port;
        this.contextPath = contextPath;
        this.loadClass = loadClass;
        this.isOpen = isOpen;
    }

    public CommonProperty setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public CommonProperty setPort(int port) {
        this.port = port;
        return this;
    }

    public CommonProperty setContextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public CommonProperty setWebApp(String webApp) {
        this.webApp = webApp;
        return this;
    }

    public CommonProperty setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public CommonProperty setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    public CommonProperty setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public CommonProperty addServlets(List<ServletAssembly> servlets) {
        this.servlets = servlets;
        return this;
    }

    public CommonProperty addFilters(List<FilterAssembly> filters) {
        this.filters = filters;
        return this;
    }

    public Class getLoadClass() {
        return this.loadClass;
    }

    public void openBrowser() {
        try {
            String urlStr = "http://localhost";
            if (this.port != 80) {
                urlStr = urlStr.concat(":" + this.port);
            }
            URI uri = new URI(urlStr);
            Desktop.getDesktop().browse(uri);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CommonProperty start() {
        return this;
    }
}

