/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.utils;

import cn.jants.common.utils.StrUtil;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ParamTypeUtil {
    public static <T> T parse(String value, Class<T> cls) {
        Object result = null;
        if (StrUtil.isBlank(value)) {
            return (T)result;
        }
        try {
            if (cls == String.class || cls == Character.TYPE) {
                result = value;
            } else if (cls == Integer.class || cls == Integer.TYPE) {
                result = Integer.valueOf(value);
            } else if (cls == Boolean.class || cls == Boolean.TYPE) {
                result = Boolean.valueOf(value);
            } else if (cls == Long.class || cls == Long.TYPE) {
                result = Long.valueOf(value);
            } else if (cls == Byte.class || cls == Byte.TYPE) {
                result = Byte.valueOf(value);
            } else if (cls == Short.class || cls == Short.TYPE) {
                result = Short.valueOf(value);
            } else if (cls == Float.class || cls == Float.TYPE) {
                result = Float.valueOf(value);
            } else if (cls == Double.class || cls == Double.TYPE) {
                result = Double.valueOf(value);
            } else if (cls == BigDecimal.class) {
                BigDecimal decimal = new BigDecimal(value);
                result = decimal;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38, \u7c7b\u578b\u4e0d\u5339\u914d!");
        }
        return (T)result;
    }

    public static <T> T[] parse(String[] value, Class<T> cls) {
        Object[] result = null;
        if (value == null) {
            return result;
        }
        try {
            if (cls == String[].class || cls == char[].class) {
                return value;
            }
            if (cls == Integer[].class || cls == int[].class) {
                result = new Integer[value.length];
                for (int i = 0; i < value.length; ++i) {
                    result[i] = Integer.valueOf(value[i]);
                }
                return result;
            }
            if (cls == Boolean[].class || cls == boolean[].class) {
                result = new Boolean[value.length];
                for (int i = 0; i < value.length; ++i) {
                    result[i] = Boolean.valueOf(value[i]);
                }
                return result;
            }
            if (cls == Long[].class || cls == long[].class) {
                result = new Long[value.length];
                for (int i = 0; i < value.length; ++i) {
                    result[i] = Long.valueOf(value[i]);
                }
                return result;
            }
            if (cls == Byte[].class || cls == byte[].class) {
                result = new Byte[value.length];
                for (int i = 0; i < value.length; ++i) {
                    result[i] = Byte.valueOf(value[i]);
                }
                return result;
            }
            if (cls == Short[].class || cls == short[].class) {
                result = new Short[value.length];
                for (int i = 0; i < value.length; ++i) {
                    result[i] = Short.valueOf(value[i]);
                }
                return result;
            }
            if (cls == Float[].class || cls == float[].class) {
                result = new Float[value.length];
                for (int i = 0; i < value.length; ++i) {
                    result[i] = Float.valueOf(value[i]);
                }
                return result;
            }
            if (cls == Double[].class || cls == double[].class) {
                result = new Double[value.length];
                for (int i = 0; i < value.length; ++i) {
                    result[i] = Double.valueOf(value[i]);
                }
                return result;
            }
            if (cls == BigDecimal.class) {
                result = new BigDecimal[value.length];
                for (int i = 0; i < value.length; ++i) {
                    BigDecimal decimal = new BigDecimal(value[i]);
                    result[i] = decimal;
                }
                return result;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38, \u7c7b\u578b\u4e0d\u5339\u914d!");
        }
        return result;
    }

    public static <T> Object setDefault(Class<T> cls) {
        try {
            if (cls == Character.TYPE) {
                return Character.valueOf(' ');
            }
            if (cls == Integer.TYPE || cls == Byte.TYPE || cls == Short.TYPE || cls == Long.TYPE) {
                return 0;
            }
            if (cls == Boolean.TYPE) {
                return false;
            }
            if (cls == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (cls == Double.TYPE) {
                return 0.0;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u53c2\u6570\u8f6c\u6362\u9519\u8bef!");
        }
        return null;
    }

    public static boolean isBaseDataType(Class clazz) {
        return clazz.equals(String.class) || clazz.equals(Integer.class) || clazz.equals(Byte.class) || clazz.equals(Long.class) || clazz.equals(Double.class) || clazz.equals(Float.class) || clazz.equals(Character.class) || clazz.equals(Short.class) || clazz.equals(BigDecimal.class) || clazz.equals(BigInteger.class) || clazz.equals(Boolean.class) || clazz.isPrimitive();
    }
}

