/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.sqlmap;

import cn.jants.core.utils.ParamTypeUtil;
import cn.jants.plugin.sqlmap.ChooseSqlNode;
import cn.jants.plugin.sqlmap.ForEachSqlNode;
import cn.jants.plugin.sqlmap.IfSqlNode;
import cn.jants.plugin.sqlmap.IncludeSqlNode;
import cn.jants.plugin.sqlmap.SetSqlNode;
import cn.jants.plugin.sqlmap.SqlNode;
import cn.jants.plugin.sqlmap.SqlParams;
import cn.jants.plugin.sqlmap.TextSqlNode;
import cn.jants.plugin.sqlmap.TrimSqlNode;
import cn.jants.plugin.sqlmap.WhereSqlNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SqlXmlParser {
    private static final Logger logger = LoggerFactory.getLogger(SqlXmlParser.class);
    protected static Map<String, List<SqlNode>> sqlMap = new ConcurrentHashMap<String, List<SqlNode>>();
    private static final String STATIC_START_SYMBOL = "#{";
    private static final String STATIC_END_SYMBOL = "}";

    public static void parse(Document document) {
        Element documentElement = document.getDocumentElement();
        if ("mapper".equals(documentElement.getTagName())) {
            String rootName = documentElement.getAttribute("namespace");
            if (rootName.isEmpty()) {
                throw new RuntimeException("the namespace domain must be defined!");
            }
            NodeList nodeList = documentElement.getElementsByTagName("sql");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node item = nodeList.item(i);
                String key = rootName + "." + ((Element)item).getAttribute("id");
                NodeList childs = item.getChildNodes();
                ArrayList<SqlNode> nodes = new ArrayList<SqlNode>();
                for (int j = 0; j < childs.getLength(); ++j) {
                    Node it = childs.item(j);
                    if (it.getNodeType() == 3) {
                        nodes.add(new TextSqlNode(it.getTextContent()));
                        continue;
                    }
                    String nodeName = it.getNodeName();
                    if (nodeName == "include") {
                        String refid = ((Element)it).getAttribute("refid");
                        String includKey = rootName + "." + refid;
                        List<SqlNode> sqlNodes = sqlMap.get(includKey);
                        if (sqlNodes == null || sqlNodes.size() == 0) {
                            throw new RuntimeException(includKey + " the includ reference node must exist or can only be configured in the front!");
                        }
                        nodes.add(new IncludeSqlNode(sqlNodes.get(0)));
                        continue;
                    }
                    if (nodeName == "if") {
                        nodes.add(new IfSqlNode(it));
                        continue;
                    }
                    if (nodeName == "where") {
                        nodes.add(new WhereSqlNode(it));
                        continue;
                    }
                    if (nodeName == "set") {
                        nodes.add(new SetSqlNode(it));
                        continue;
                    }
                    if (nodeName == "trim") {
                        nodes.add(new TrimSqlNode(it));
                        continue;
                    }
                    if (nodeName == "choose") {
                        nodes.add(new ChooseSqlNode(it));
                        continue;
                    }
                    if (nodeName != "foreach") continue;
                    nodes.add(new ForEachSqlNode(it));
                }
                sqlMap.put(key, nodes);
            }
        }
    }

    public static SqlParams getPreparedStatement(String key, Object params) {
        List<SqlNode> sqlNodes = sqlMap.get(key);
        if (sqlNodes == null || sqlNodes.size() == 0) {
            throw new IllegalArgumentException("not find " + key + "!");
        }
        StringBuffer sb = new StringBuffer();
        for (SqlNode sqlNode : sqlNodes) {
            sb.append(sqlNode.getResult(params));
        }
        String sql = sb.toString().replaceAll("\r|\n|\t|", "").replaceAll(" +", " ").trim();
        if (params == null) {
            return new SqlParams(sql, null);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        if (ParamTypeUtil.isBaseDataType(params.getClass())) {
            System.out.println(sql);
            int startNum = sql.indexOf(STATIC_START_SYMBOL);
            sql = sql.substring(0, startNum).concat("?");
            values.add(params);
        } else if (params instanceof Map) {
            Set entries = ((Map)params).entrySet();
            for (Map.Entry entry : entries) {
                String ikey = STATIC_START_SYMBOL + (String)entry.getKey() + STATIC_END_SYMBOL;
                Object v = entry.getValue();
                if (sql.indexOf(ikey) == -1) continue;
                values.add(v);
                sql = sql.replace(ikey, "? ");
            }
        } else {
            throw new IllegalArgumentException("[" + params + "] \u4f20\u5165\u7684\u6570\u636e\u5bf9\u8c61\u5fc5\u987bMap\u7c7b\u578b \u6216\u57fa\u672c\u6570\u636e\u7c7b\u578b!");
        }
        return new SqlParams(sql, values.toArray());
    }

    public static SqlParams getPreparedStatement(String key) {
        return SqlXmlParser.getPreparedStatement(key, null);
    }

    public static void clear() {
        sqlMap.clear();
    }
}

