/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.common.bean;

import cn.jants.common.annotation.service.Aop;
import cn.jants.common.annotation.service.Uop;
import cn.jants.common.utils.CollectionUtil;
import cn.jants.plugin.cache.Cacheable;
import cn.jants.restful.request.RequestMappingBean;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log {
    private static final String LOG_NAME = Log.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(Log.class);
    private static final ThreadLocal<SimpleDateFormat> SDF = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };

    public static void info(String format, Object ... arguments) {
        format = Log.getStackMsg(Thread.currentThread().getStackTrace()).concat(":").concat(format);
        LOG.info(format, arguments);
    }

    public static void debug(String format, Object ... arguments) {
        format = Log.getStackMsg(Thread.currentThread().getStackTrace()).concat(":").concat(format);
        LOG.debug(format, arguments);
    }

    public static void error(String format, Object ... arguments) {
        format = Log.getStackMsg(Thread.currentThread().getStackTrace()).concat(":").concat(format);
        LOG.error(format, arguments);
    }

    public static void warn(String format, Object ... arguments) {
        format = Log.getStackMsg(Thread.currentThread().getStackTrace()).concat(":").concat(format);
        LOG.warn(format, arguments);
    }

    public static final void action(String target, HttpServletRequest request, RequestMappingBean bean) {
        StringBuilder sb = new StringBuilder("\nAnts log report -------- ").append(SDF.get().format(new Date())).append(" ------------------------------\n");
        sb.append("Url         : ").append(request.getMethod()).append(" ").append(target).append("\n");
        Class<?> c = bean.getObject().getClass();
        sb.append("Controller  : ").append(String.valueOf(c.getName())).append(".".concat(bean.getMethod().getName())).append(" (").append(c.getSimpleName()).append(".java:1)").append("\n");
        Method m = bean.getMethod();
        if ("application/json".equals(request.getContentType())) {
            sb.append("Parameter   : ").append(bean.getParams()).append("\n");
        } else {
            sb.append("Parameter   : ").append(JSON.toJSON((Object)request.getParameterMap())).append("\n");
        }
        Cacheable cache = m.getAnnotation(Cacheable.class);
        if (cache != null) {
            sb.append("Cache       : ").append("true").append("\n");
        }
        Aop classAop = c.getAnnotation(Aop.class);
        Aop methodAop = m.getAnnotation(Aop.class);
        Uop methodUop = m.getAnnotation(Uop.class);
        if (classAop != null || methodAop != null) {
            Class[] interceptors = CollectionUtil.union(classAop == null ? null : classAop.value(), methodAop == null ? null : methodAop.value());
            if (interceptors != null && interceptors.length > 0 && (interceptors = CollectionUtil.minus(interceptors, methodUop == null ? null : methodUop.value())).length > 0) {
                sb.append("Interceptor : ");
            }
            for (int i = 0; i < interceptors.length; ++i) {
                if (i != 0) {
                    sb.append("              ");
                }
                sb.append(interceptors[i].getName()).append(" (").append(interceptors[i].getSimpleName()).append(".java:1)").append("\n");
            }
        }
        sb.append("---------------------------------------------------------------------------\n");
        System.out.println(sb.toString());
    }

    private static String getStackMsg(StackTraceElement[] ste) {
        if (ste == null) {
            return null;
        }
        boolean srcFlag = false;
        for (int i = 0; i < ste.length; ++i) {
            StackTraceElement s = ste[i];
            if (srcFlag) {
                return s == null ? "" : s.toString();
            }
            if (!LOG_NAME.equals(s.getClassName())) continue;
            srcFlag = true;
        }
        return null;
    }
}

