/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.common.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QRCodeUtil {
    private static final Logger LOG = LoggerFactory.getLogger(QRCodeUtil.class);
    private static final String CHARSET = "utf-8";
    private static final String FORMAT_NAME = "JPG";
    private static final int WIDTH = 60;
    private static final int HEIGHT = 60;
    private static AtomicInteger CODE_SIZE = new AtomicInteger(300);
    private static AtomicInteger CODE_COLOR = new AtomicInteger(-16777216);
    private static AtomicInteger BG_COLOR = new AtomicInteger(-1);

    public static void setBitMatrix(Integer codeSize, Integer codeColor, Integer bgColor) {
        CODE_SIZE.set(codeSize);
        CODE_COLOR.set(codeColor);
        if (bgColor != null) {
            BG_COLOR.set(bgColor);
        }
    }

    public static void setBitMatrix(Integer codeSize, Integer codeColor) {
        QRCodeUtil.setBitMatrix(codeSize, codeColor);
    }

    private static BufferedImage createImage(String content, String imgPath, boolean needCompress) throws Exception {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, CHARSET);
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, CODE_SIZE.get(), CODE_SIZE.get(), hints);
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        System.out.println(String.format("width:%s, height:%s", width, height));
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int rgb = new Color(x * 10 / 12, y * 10 / 12, 1).getRGB();
                image.setRGB(x, y, bitMatrix.get(x, y) ? rgb : BG_COLOR.get());
            }
        }
        if (imgPath == null || "".equals(imgPath)) {
            return image;
        }
        QRCodeUtil.insertImage(image, imgPath, needCompress);
        return image;
    }

    private static void insertImage(BufferedImage source, String imgPath, boolean needCompress) throws Exception {
        File file = new File(imgPath);
        if (!file.exists()) {
            System.err.println("" + imgPath + "   \u8be5\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            return;
        }
        Image src = ImageIO.read(new File(imgPath));
        int width = ((Image)src).getWidth(null);
        int height = ((Image)src).getHeight(null);
        if (needCompress) {
            if (width > 60) {
                width = 60;
            }
            if (height > 60) {
                height = 60;
            }
            Image image = src.getScaledInstance(width, height, 4);
            BufferedImage tag = new BufferedImage(width, height, 1);
            Graphics g = tag.getGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            src = image;
        }
        Graphics2D graph = source.createGraphics();
        int x = (CODE_SIZE.get() - width) / 2;
        int y = (CODE_SIZE.get() - height) / 2;
        graph.drawImage(src, x, y, width, height, null);
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, width, width, 6.0f, 6.0f);
        graph.setStroke(new BasicStroke(3.0f));
        graph.draw(shape);
        graph.dispose();
    }

    private static void mkdirs(String destPath) {
        File file = new File(destPath);
        if (!file.exists() && !file.isDirectory()) {
            file.mkdirs();
        }
    }

    public static void writeToFile(String content, String imgPath, String destFile, boolean needCompress) {
        try {
            BufferedImage image = QRCodeUtil.createImage(content, imgPath, needCompress);
            int n = destFile.lastIndexOf(File.separator);
            String destPath = destFile.substring(0, n == -1 ? destFile.lastIndexOf("/") : n);
            QRCodeUtil.mkdirs(destPath);
            ImageIO.write((RenderedImage)image, FORMAT_NAME, new File(destFile));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("\u751f\u6210\u4e8c\u7ef4\u7801\u5230\u6587\u4ef6\u5f02\u5e38 " + e.getMessage());
        }
    }

    public static void writeToFile(String content, String destFile) {
        QRCodeUtil.writeToFile(content, null, destFile, false);
    }

    public static void writeToOutputStream(String content, String imgPath, boolean needCompress, OutputStream out) {
        try {
            BufferedImage image = QRCodeUtil.createImage(content, imgPath, needCompress);
            ImageIO.write((RenderedImage)image, FORMAT_NAME, out);
        }
        catch (IOException e) {
            LOG.error("Could not write an image of format " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeToOutputStream(String content, OutputStream out) {
        QRCodeUtil.writeToOutputStream(content, null, false, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getInputStream(String content) {
        OutputStream fos = null;
        File file = null;
        try {
            file = File.createTempFile("temp", ".code");
            LOG.info("\u4e34\u65f6\u6587\u4ef6\u6240\u5728\u7684\u672c\u5730\u8def\u5f84 > {}", (Object)file.getCanonicalPath());
            fos = new FileOutputStream(file);
            QRCodeUtil.writeToOutputStream(content, fos);
            FileInputStream fileInputStream = new FileInputStream(file.getCanonicalPath());
            return fileInputStream;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fos.flush();
                ((FileOutputStream)fos).close();
                file.deleteOnExit();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void main(String[] args) {
        QRCodeUtil.writeToFile("\u8fd9\u4e34\u65f6\u6587\u4ef6\u6240\u5728\u7684\u672c\u5730\u8def\u4e34\u65f6\u6587\u4ef6\u6240\u5728\u7684\u672c\u5730\u8def\u4e34\u65f6\u6587\u4ef6\u6240\u5728\u7684\u672c\u5730\u8def\u662f", "e:/aa.jpg", "e:/code/tes.png", true);
    }
}

