/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.context;

import cn.jants.common.annotation.boot.DbConfiguration;
import cn.jants.common.annotation.boot.DbSource;
import cn.jants.common.annotation.boot.PropertyConfiguration;
import cn.jants.common.annotation.boot.ViewConfiguration;
import cn.jants.common.annotation.plugin.EnableActiveMQPlugin;
import cn.jants.common.annotation.plugin.EnableEhcachePlugin;
import cn.jants.common.annotation.plugin.EnableRedisPlugin;
import cn.jants.common.annotation.plugin.EnableSQLMapPlugin;
import cn.jants.common.annotation.service.Application;
import cn.jants.common.bean.Log;
import cn.jants.common.bean.Prop;
import cn.jants.common.enums.DataSourceType;
import cn.jants.common.enums.ViewType;
import cn.jants.common.utils.StrUtil;
import cn.jants.core.context.AppConfiguration;
import cn.jants.core.context.AppConstant;
import cn.jants.core.ext.Plugin;
import cn.jants.core.handler.RenderHandler;
import cn.jants.core.module.Constant;
import cn.jants.core.module.HandlerManager;
import cn.jants.core.module.InterceptorManager;
import cn.jants.core.module.PluginManager;
import cn.jants.core.module.RequestMappingManager;
import cn.jants.core.module.ServiceManager;
import cn.jants.core.utils.ScanUtil;
import cn.jants.plugin.cache.EhCachePlugin;
import cn.jants.plugin.cache.RedisPlugin;
import cn.jants.plugin.db.C3p0Plugin;
import cn.jants.plugin.db.DbPlugin;
import cn.jants.plugin.db.DbcpPlugin;
import cn.jants.plugin.db.DruidPlugin;
import cn.jants.plugin.db.HikariCpPlugin;
import cn.jants.plugin.jms.ActiveMqPlugin;
import cn.jants.plugin.jms.ConsumerManager;
import cn.jants.plugin.jms.JmsListener;
import cn.jants.plugin.scheduler.FixedDelay;
import cn.jants.plugin.scheduler.SchedulerBean;
import cn.jants.plugin.scheduler.SchedulerManager;
import cn.jants.plugin.sqlmap.SqlMapPlugin;
import cn.jants.plugin.template.BeetlTpl;
import cn.jants.plugin.template.FreeMarkerTpl;
import cn.jants.plugin.template.VelocityTpl;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;

public class AntsContext {
    private final Constant constant = new Constant();
    private final PluginManager plugins = new PluginManager();
    private final InterceptorManager interceptors = new InterceptorManager();
    private final HandlerManager handlers = new HandlerManager();

    public AntsContext(Class<?> loadClass, ServletContext servletContext) {
        Application application;
        ViewConfiguration tplConfiguration;
        AppConstant.LOAD_CLASS = loadClass;
        PropertyConfiguration propertyConfiguration = loadClass.getDeclaredAnnotation(PropertyConfiguration.class);
        if (propertyConfiguration != null) {
            String[] stringArray;
            String[] props;
            String secretKey = propertyConfiguration.secretKey();
            if (StrUtil.notBlank(secretKey)) {
                if (secretKey.length() != 16) {
                    throw new RuntimeException("secretKey must be 16 digit.");
                }
                AppConstant.SECRET_KEY = secretKey;
            }
            if ((props = propertyConfiguration.value()).length == 0) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = AppConstant.DEFAULT_CONFIG;
            } else {
                stringArray = props;
            }
            Prop.use(stringArray);
            AppConstant.DEBUG = propertyConfiguration.debug();
            this.constant.setError404Page(propertyConfiguration.page404());
            this.constant.setError500Page(propertyConfiguration.page500());
            this.constant.setRegexSuffix(propertyConfiguration.suffix());
            this.constant.setResources(propertyConfiguration.resources());
            this.constant.setEncoding(propertyConfiguration.encoding());
            String regexSuffix = this.constant.getRegexSuffix();
            if (!"{:()}".equals(regexSuffix)) {
                AppConstant.URL_REGEX_SUFFIX = regexSuffix;
            }
        }
        if ((tplConfiguration = loadClass.getDeclaredAnnotation(ViewConfiguration.class)) != null) {
            AppConstant.TPL_CONFIG = tplConfiguration;
            if (tplConfiguration.viewType() == ViewType.FREEMARKER) {
                ServiceManager.setService("plugin_template_FreeMarkerTpl", new FreeMarkerTpl(tplConfiguration));
            } else if (tplConfiguration.viewType() == ViewType.BEETL) {
                ServiceManager.setService("plugin_template_BeetlTpl", new BeetlTpl(tplConfiguration));
            } else if (tplConfiguration.viewType() == ViewType.VELOCITY) {
                ServiceManager.setService("plugin_template_VelocityTpl", new VelocityTpl(tplConfiguration));
            }
        }
        if (loadClass.getSuperclass().equals(AppConfiguration.class)) {
            this.initAppConfiguration(loadClass);
        }
        if ((application = loadClass.getDeclaredAnnotation(Application.class)) == null) {
            throw new RuntimeException("\u542f\u52a8\u7c7b\u7f3a\u5c11@Application\u6ce8\u89e3");
        }
        String[] packages = application.scanPackages();
        String defaultPath = loadClass.getName();
        int lastNum = defaultPath.lastIndexOf(".");
        String[] defaultPackage = new String[]{""};
        if (lastNum != -1) {
            defaultPackage[0] = defaultPath.substring(0, lastNum);
        }
        if (AppConstant.DEBUG.booleanValue()) {
            Log.debug("Loading Plugins .....", new Object[0]);
        }
        String[] pgs = packages.length == 0 ? defaultPackage : packages;
        SchedulerManager schedulers = this.initSchedulerPlugin(pgs);
        if (AppConstant.DEBUG.booleanValue()) {
            Log.debug("\u521d\u59cb\u5316\u6ce8\u89e3\u63d2\u4ef6 .....", new Object[0]);
        }
        this.initAnnotationPlugin(loadClass);
        this.startPlugins();
        if (AppConstant.DEBUG.booleanValue()) {
            Log.debug("Register Service .....", new Object[0]);
        }
        ServiceManager.register(pgs);
        if (AppConstant.DEBUG.booleanValue()) {
            Log.debug("Register Controller .....", new Object[0]);
        }
        RequestMappingManager.register(pgs);
        if (schedulers != null) {
            schedulers.start();
        }
        this.initJmsConsumer(pgs, loadClass);
    }

    public Constant getConstant() {
        return this.constant;
    }

    public HandlerManager getHandlerManager() {
        this.handlers.setConstants(this.constant);
        this.handlers.add(new RenderHandler(this.constant));
        return this.handlers;
    }

    private SchedulerManager initSchedulerPlugin(String[] packages) {
        List<Class<?>> classes = ScanUtil.findScanClass(packages, FixedDelay.class);
        if (classes == null || classes.size() == 0) {
            return null;
        }
        ArrayList<SchedulerBean> schedulers = new ArrayList<SchedulerBean>();
        for (Class<?> cls : classes) {
            FixedDelay fixedDelay = cls.getDeclaredAnnotation(FixedDelay.class);
            schedulers.add(new SchedulerBean(fixedDelay, cls));
        }
        return new SchedulerManager(schedulers);
    }

    private void initAnnotationPlugin(Class<?> loadClass) {
        EnableSQLMapPlugin sqlMapPlugin;
        EnableEhcachePlugin enableEhcachePlugin;
        EnableActiveMQPlugin activeMQPlugin;
        EnableRedisPlugin redisPlugin;
        DbSource[] dbs;
        DbConfiguration dbConfiguration = loadClass.getDeclaredAnnotation(DbConfiguration.class);
        if (dbConfiguration != null && (dbs = dbConfiguration.dbs()).length > 0) {
            for (DbSource db : dbs) {
                if (db.sourceType() == DataSourceType.DRUID) {
                    this.plugins.add(new DruidPlugin(Prop.getKeyStrValue(db.name()), Prop.getKeyStrValue(db.url()), Prop.getKeyStrValue(db.driver()), Prop.getKeyStrValue(db.username()), Prop.getKeyStrValue(db.password())));
                    continue;
                }
                if (db.sourceType() == DataSourceType.C3P0) {
                    this.plugins.add(new C3p0Plugin(Prop.getKeyStrValue(db.name()), Prop.getKeyStrValue(db.url()), Prop.getKeyStrValue(db.driver()), Prop.getKeyStrValue(db.username()), Prop.getKeyStrValue(db.password())));
                    continue;
                }
                if (db.sourceType() == DataSourceType.DBCP) {
                    this.plugins.add(new DbcpPlugin(Prop.getKeyStrValue(db.name()), Prop.getKeyStrValue(db.url()), Prop.getKeyStrValue(db.driver()), Prop.getKeyStrValue(db.username()), Prop.getKeyStrValue(db.password())));
                    continue;
                }
                if (db.sourceType() == DataSourceType.HIKARICP) {
                    this.plugins.add(new HikariCpPlugin(Prop.getKeyStrValue(db.name()), Prop.getKeyStrValue(db.url()), Prop.getKeyStrValue(db.driver()), Prop.getKeyStrValue(db.username()), Prop.getKeyStrValue(db.password())));
                    continue;
                }
                this.plugins.add(new DbPlugin(Prop.getKeyStrValue(db.name()), Prop.getKeyStrValue(db.url()), Prop.getKeyStrValue(db.driver()), Prop.getKeyStrValue(db.username()), Prop.getKeyStrValue(db.password())));
            }
        }
        if ((redisPlugin = loadClass.getDeclaredAnnotation(EnableRedisPlugin.class)) != null) {
            String hostStr = Prop.getKeyStrValue(redisPlugin.host());
            String defaultHostStr = Prop.getStr("ants.redis.host");
            String host = StrUtil.notBlank(hostStr) ? hostStr : defaultHostStr;
            Integer portStr = Prop.getKeyIntValue(redisPlugin.port());
            Integer defaultPortStr = Prop.getInt("ants.redis.port");
            Integer port = StrUtil.notNull(portStr) ? portStr : defaultPortStr;
            Integer dataBaseStr = Prop.getKeyIntValue(redisPlugin.database());
            Integer defaultDataBaseStr = Prop.getInt("ants.redis.database");
            Integer database = StrUtil.notNull(dataBaseStr) ? dataBaseStr : defaultDataBaseStr;
            String passwordStr = Prop.getKeyStrValue(redisPlugin.password());
            String defaultPasswordStr = Prop.getStr("ants.redis.password");
            String password = StrUtil.notBlank(passwordStr) ? passwordStr : defaultPasswordStr;
            this.plugins.add(new RedisPlugin(host, port, database, password));
        }
        if ((activeMQPlugin = loadClass.getDeclaredAnnotation(EnableActiveMQPlugin.class)) != null) {
            String brokerUrlStr = Prop.getKeyStrValue(activeMQPlugin.brokerUrl());
            String defaultBrokerUrlStr = Prop.getStr("ants.jms.activemq.broker-url");
            String brokerUrl = StrUtil.notBlank(brokerUrlStr) ? brokerUrlStr : defaultBrokerUrlStr;
            String userNameStr = Prop.getKeyStrValue(activeMQPlugin.username());
            String defaultUserNameStr = Prop.getStr("ants.jms.activemq.username");
            String username = StrUtil.notBlank(userNameStr) ? userNameStr : defaultUserNameStr;
            String passwordStr = Prop.getKeyStrValue(activeMQPlugin.password());
            String defaultPasswordStr = Prop.getStr("ants.jms.activemq.password");
            String password = StrUtil.notBlank(passwordStr) ? passwordStr : defaultPasswordStr;
            this.plugins.add(new ActiveMqPlugin(brokerUrl, username, password));
        }
        if ((enableEhcachePlugin = loadClass.getDeclaredAnnotation(EnableEhcachePlugin.class)) != null) {
            this.plugins.add(new EhCachePlugin(enableEhcachePlugin.value()));
        }
        if ((sqlMapPlugin = loadClass.getDeclaredAnnotation(EnableSQLMapPlugin.class)) != null) {
            this.plugins.add(new SqlMapPlugin(sqlMapPlugin.value()));
        }
    }

    private void initJmsConsumer(String[] packages, Class<?> loadClass) {
        EnableActiveMQPlugin activeMQPlugin = loadClass.getDeclaredAnnotation(EnableActiveMQPlugin.class);
        if (activeMQPlugin != null) {
            String brokerUrlStr = Prop.getKeyStrValue(activeMQPlugin.brokerUrl());
            String defaultBrokerUrlStr = Prop.getStr("ants.jms.activemq.broker-url");
            String brokerUrl = StrUtil.notBlank(brokerUrlStr) ? brokerUrlStr : defaultBrokerUrlStr;
            String userNameStr = Prop.getKeyStrValue(activeMQPlugin.username());
            String defaultUserNameStr = Prop.getStr("ants.jms.activemq.username");
            String username = StrUtil.notBlank(userNameStr) ? userNameStr : defaultUserNameStr;
            String passwordStr = Prop.getKeyStrValue(activeMQPlugin.password());
            String defaultPasswordStr = Prop.getStr("ants.jms.activemq.password");
            String password = StrUtil.notBlank(passwordStr) ? passwordStr : defaultPasswordStr;
            List<Class<?>> classes = ScanUtil.findScanClass(packages, JmsListener.class);
            if (classes != null && classes.size() > 0) {
                new ConsumerManager(brokerUrl, username, password, classes).start();
            }
        }
    }

    private void initAppConfiguration(Class<?> loadClass) {
        try {
            AppConfiguration appConfiguration = (AppConfiguration)loadClass.newInstance();
            appConfiguration.configConstant(this.constant);
            appConfiguration.configPlugin(this.plugins);
            appConfiguration.configHandler(this.handlers);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void startPlugins() {
        List<Plugin> pluginList = PluginManager.getPluginList();
        if (pluginList == null) {
            return;
        }
        for (Plugin plugin : pluginList) {
            try {
                if (plugin.start()) continue;
                String message = "Plugin start error: " + plugin.getClass().getName();
                Log.error(message, new Object[0]);
                throw new RuntimeException(message);
            }
            catch (Exception e) {
                String message = "Plugin start error: " + plugin.getClass().getName() + ". \n" + e.getMessage();
                Log.error(message, new Object[0]);
                throw new RuntimeException(message, e);
            }
        }
        if (AppConstant.DEBUG.booleanValue()) {
            Log.debug(">>> \u5171\u8ba1 {} \u4e2a\u63d2\u4ef6", pluginList.size());
        }
    }

    private void stopPlugins() {
        List<Plugin> pluginList = PluginManager.getPluginList();
        if (pluginList != null) {
            for (int i = pluginList.size() - 1; i >= 0; --i) {
                boolean success = false;
                try {
                    success = pluginList.get(i).destroy();
                }
                catch (Exception e) {
                    success = false;
                    Log.error(e.getMessage(), new Object[0]);
                }
                if (success) continue;
                System.err.println("Plugin stop error: " + pluginList.get(i).getClass().getName());
            }
        }
    }
}

