/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.module;

import cn.jants.common.enums.ResponseCode;
import cn.jants.common.exception.SQLParamsException;
import cn.jants.common.exception.TipException;
import cn.jants.common.utils.RequestUtil;
import cn.jants.common.utils.StrUtil;
import cn.jants.core.ext.Handler;
import cn.jants.core.module.Constant;
import cn.jants.restful.render.Json;
import com.mysql.jdbc.MysqlDataTruncation;
import com.mysql.jdbc.exceptions.jdbc4.MySQLIntegrityConstraintViolationException;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class HandlerManager {
    private final List<Handler> handlers = new ArrayList<Handler>();
    private Constant constant;

    public HandlerManager add(Handler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler can not be null");
        }
        this.handlers.add(handler);
        return this;
    }

    public boolean execute(String target, HttpServletRequest request, HttpServletResponse response) {
        boolean isHandle = true;
        for (Handler handler : this.handlers) {
            try {
                isHandle = handler.preHandler(target, request, response);
                if (isHandle) continue;
                return false;
            }
            catch (InvocationTargetException e) {
                Throwable ex = e.getTargetException();
                ex.printStackTrace();
                this.errorWrite(request, response, ex);
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errorWrite(request, response, e);
                return false;
            }
        }
        return isHandle;
    }

    private void errorWrite(HttpServletRequest request, HttpServletResponse response, Throwable e) {
        String requestType = request.getHeader("x-requested-with");
        Class<?> cls = e.getClass();
        if (RequestUtil.isAjax(request) || RequestUtil.isApp(request)) {
            if (cls == TipException.class) {
                Json.writeJson(Json.exception(ResponseCode.ARGUMENTS_ERROR, e.getMessage()), response);
            } else if (cls == SQLParamsException.class) {
                Class<?> sqlClass = ((SQLParamsException)e).getSqlException().getClass();
                if (sqlClass == MySQLIntegrityConstraintViolationException.class) {
                    Json.writeJson(Json.exception(ResponseCode.RESTRIC_ERROR, "\u5220\u9664\u5931\u8d25, \u8bf7\u5148\u5220\u9664\u5173\u8054\u5b50\u6570\u636e!"), response);
                } else if (sqlClass == MysqlDataTruncation.class) {
                    Json.writeJson(Json.exception(ResponseCode.COLUMN_LONG_ERROR, "\u67d0\u4e2a\u6570\u636e\u5b57\u6bb5, \u5185\u5bb9\u8d85\u51fa!"), response);
                }
            } else if (cls == NullPointerException.class) {
                Json.writeJson(Json.exception(ResponseCode.NULL_POINT_ERROR), response);
            } else if (cls == IllegalArgumentException.class) {
                Json.writeJson(Json.exception(ResponseCode.ARGUMENTS_ERROR, e.getMessage()), response);
            } else {
                Json.writeJson(Json.exception(ResponseCode.UNKNOWN_ERROR, e.getMessage()), response);
            }
        } else {
            try {
                if (cls == FileNotFoundException.class) {
                    String error404Page = this.constant.getError404Page();
                    if (StrUtil.notBlank(error404Page)) {
                        request.getRequestDispatcher(error404Page).forward((ServletRequest)request, (ServletResponse)response);
                    }
                } else {
                    String error500Page = this.constant.getError500Page();
                    if (StrUtil.notBlank(error500Page)) {
                        request.getRequestDispatcher(error500Page).forward((ServletRequest)request, (ServletResponse)response);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setConstants(Constant constant) {
        this.constant = constant;
    }
}

