/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.proxy;

import cn.jants.common.bean.Log;
import cn.jants.common.utils.StrEncryptUtil;
import cn.jants.common.utils.StrUtil;
import cn.jants.core.module.ServiceManager;
import cn.jants.plugin.cache.CacheEvict;
import cn.jants.plugin.cache.CachePut;
import cn.jants.plugin.cache.Cacheable;
import cn.jants.plugin.cache.EhCacheTpl;
import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.lang.reflect.Method;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;

public class CacheManager {
    private boolean isOpen = false;
    private boolean exist = false;
    private Object result;
    private Cache ehcache;
    private String key;
    private int seconds;

    public CacheManager(Object target, Method method, Object[] args) {
        Cacheable cache = method.getDeclaredAnnotation(Cacheable.class);
        if (cache != null) {
            this.isOpen = true;
            this.key = StrUtil.notBlank(cache.key()) ? cache.key() : this.encodeStr(target, method, args);
            EhCacheTpl ehCacheTpl = ServiceManager.getService(EhCacheTpl.class);
            if (ehCacheTpl == null) {
                throw new RuntimeException("\u83b7\u53d6\u5b9e\u4f8b EhCacheTpl \u5931\u8d25, \u68c0\u67e5Ehcache\u914d\u7f6e!");
            }
            this.ehcache = StrUtil.isBlank(cache.value()) ? ehCacheTpl.getCache() : ehCacheTpl.getCache(cache.value());
            Element element = this.ehcache.get((Serializable)((Object)this.key));
            if (element != null && !this.ehcache.isExpired(element)) {
                this.exist = true;
                Log.debug("ehcache cache key > {}", this.key);
                this.result = this.ehcache.get((Serializable)((Object)this.key)).getObjectValue();
            }
            this.seconds = cache.seconds();
            return;
        }
        CacheEvict cacheEvict = method.getDeclaredAnnotation(CacheEvict.class);
        if (cacheEvict != null) {
            EhCacheTpl ehCacheTpl = ServiceManager.getService(EhCacheTpl.class);
            if (ehCacheTpl == null) {
                throw new RuntimeException("\u83b7\u53d6\u5b9e\u4f8b EhCacheTpl \u5931\u8d25, \u68c0\u67e5Ehcache\u914d\u7f6e!");
            }
            Cache cache2 = this.ehcache = StrUtil.isBlank(cacheEvict.value()) ? ehCacheTpl.getCache() : ehCacheTpl.getCache(cacheEvict.value());
            if (StrUtil.notBlank(cacheEvict.key())) {
                this.ehcache.remove((Serializable)((Object)this.key));
            } else {
                this.ehcache.removeAll();
            }
            return;
        }
        CachePut cachePut = method.getDeclaredAnnotation(CachePut.class);
        if (cachePut != null) {
            EhCacheTpl ehCacheTpl = ServiceManager.getService(EhCacheTpl.class);
            if (ehCacheTpl == null) {
                throw new RuntimeException("\u83b7\u53d6\u5b9e\u4f8b EhCacheTpl \u5931\u8d25, \u68c0\u67e5Ehcache\u914d\u7f6e!");
            }
            Cache cache3 = this.ehcache = StrUtil.isBlank(cachePut.value()) ? ehCacheTpl.getCache() : ehCacheTpl.getCache(cachePut.value());
            if (StrUtil.notBlank(cachePut.key())) {
                this.ehcache.remove((Serializable)((Object)this.key));
            } else {
                this.ehcache.removeAll();
            }
            this.seconds = cachePut.seconds();
            this.isOpen = true;
            return;
        }
    }

    public Object getResult() {
        return this.result;
    }

    public void setCache(Object value) {
        Element element = new Element((Object)this.key, value);
        element.setTimeToIdle(this.seconds);
        this.ehcache.put(element);
    }

    public boolean isOpened() {
        return this.isOpen;
    }

    public boolean existCache() {
        return this.exist;
    }

    private String encodeStr(Object target, Method method, Object ... params) {
        String classesName = target.getClass().getSimpleName();
        String key = "[".concat(classesName).concat(".").concat(method.getName()).concat("(").concat(StrEncryptUtil.md5(JSON.toJSONString((Object)params))).concat(")]");
        Log.debug("create cache key > {}", key);
        return key;
    }
}

