/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.db;

import cn.jants.core.ext.Plugin;
import cn.jants.plugin.db.CommonProperty;
import com.alibaba.fastjson.JSON;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public class HikariCpPlugin
extends CommonProperty
implements Plugin {
    private HikariDataSource dataSource = null;

    public HikariCpPlugin(String url, String driverClassName, String username, String password) {
        super(url, driverClassName, username, password);
    }

    public HikariCpPlugin(String name, String url, String driverClassName, String username, String password) {
        super(name, url, driverClassName, username, password);
    }

    @Override
    public boolean start() throws SQLException {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(this.getDriverClassName());
        hikariConfig.setJdbcUrl(this.getUrl());
        hikariConfig.setUsername(this.getUsername());
        hikariConfig.setPassword(this.getPassword());
        this.dataSource = new HikariDataSource(hikariConfig);
        this.test("HikariCp DataSource", (DataSource)this.dataSource);
        return true;
    }

    @Override
    public boolean destroy() {
        try {
            this.dataSource.getConnection().close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.dataSource = null;
        }
        return true;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DataSource getDataSource(Properties properties) {
        HikariConfig hikariConfig = (HikariConfig)JSON.parseObject((String)JSON.toJSONString((Object)properties), HikariConfig.class);
        hikariConfig.setDriverClassName(this.getDriverClassName());
        hikariConfig.setJdbcUrl(this.getUrl());
        hikariConfig.setUsername(this.getUsername());
        hikariConfig.setPassword(this.getPassword());
        return new HikariDataSource(hikariConfig);
    }
}

