/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.oss;

import cn.jants.common.bean.Log;
import cn.jants.plugin.oss.OssResult;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class AliOssTpl {
    private OSSClient client;
    private String bucketName;
    private String url;

    public AliOssTpl(OSSClient client, String url, String bucketName) {
        this.client = client;
        this.bucketName = bucketName;
        this.url = url;
    }

    public OSSClient getClient() {
        return this.client;
    }

    public boolean createBucket(String bucketName) {
        Bucket bucket = this.client.createBucket(bucketName);
        return bucketName.equals(bucket.getName());
    }

    public void deleteBucket(String bucketName) {
        this.client.deleteBucket(bucketName);
        Log.info("\u5220\u9664" + bucketName + "Bucket\u6210\u529f", new Object[0]);
    }

    public OssResult uploadFile2OSS(File file, String rename, String bucketName, String diskName) {
        try {
            Long fileSize = file.length();
            String fileName = file.getName();
            FileInputStream is = new FileInputStream(file);
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength((long)((InputStream)is).available());
            metadata.setCacheControl("no-cache");
            metadata.setHeader("Pragma", (Object)"no-cache");
            metadata.setContentEncoding("utf-8");
            metadata.setContentType(this.getContentType(fileName));
            metadata.setContentDisposition("filename/filesize=" + fileName + "/" + fileSize + "Byte.");
            String urlStr = this.url.concat("/").concat(diskName).concat(rename);
            PutObjectResult putResult = this.client.putObject(this.bucketName == null ? bucketName : this.bucketName, diskName + (rename == null ? fileName : rename), (InputStream)is, metadata);
            return new OssResult(true, "\u4e0a\u4f20\u6210\u529f > ".concat(file.getName().concat(" !")), urlStr, putResult.getETag());
        }
        catch (Exception e) {
            Log.error("\u4e0a\u4f20\u963f\u91cc\u4e91OSS\u670d\u52a1\u5668\u5f02\u5e38." + e.getMessage(), e);
            return new OssResult(false, "\u4e0a\u4f20\u5931\u8d25 > ".concat(file.getName().concat(" !")), null, null);
        }
    }

    public OssResult uploadFile2OSS(File file, String bucketName, String diskName) {
        return this.uploadFile2OSS(file, null, bucketName, diskName);
    }

    public OssResult uploadFile2OSS(File file, String diskName) {
        return this.uploadFile2OSS(file, null, this.bucketName, diskName);
    }

    public OssResult uploadStream2OSS(InputStream is, String fileName, String bucketName, String diskName) {
        try {
            Integer fileSize = is.available();
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength((long)is.available());
            metadata.setCacheControl("no-cache");
            metadata.setHeader("Pragma", (Object)"no-cache");
            metadata.setContentEncoding("utf-8");
            metadata.setContentType(this.getContentType(fileName));
            metadata.setContentDisposition("filename/filesize=" + fileName + "/" + fileSize + "Byte.");
            PutObjectResult putResult = this.client.putObject(this.bucketName == null ? bucketName : this.bucketName, diskName + fileName, is, metadata);
            String urlStr = this.url.concat("/").concat(diskName).concat(fileName);
            return new OssResult(true, "\u4e0a\u4f20\u6210\u529f > ".concat(fileName.concat(" !")), urlStr, putResult.getETag());
        }
        catch (Exception e) {
            Log.error("\u4e0a\u4f20\u963f\u91cc\u4e91OSS\u670d\u52a1\u5668\u5f02\u5e38." + e.getMessage(), e);
            return new OssResult(false, "\u4e0a\u4f20\u5931\u8d25 > ".concat(fileName.concat(" !")), null, null);
        }
    }

    public OssResult uploadStream2OSS(InputStream is, String fileName, String diskName) {
        return this.uploadStream2OSS(is, fileName, null, diskName);
    }

    public InputStream getOSS2InputStream(String bucketName, String diskName, String key) {
        OSSObject ossObj = this.client.getObject(this.bucketName == null ? bucketName : this.bucketName, diskName + key);
        return ossObj.getObjectContent();
    }

    public InputStream getOSS2InputStream(String diskName, String key) {
        return this.getOSS2InputStream(null, diskName, key);
    }

    public OssResult delete(String bucketName, String objectName) {
        boolean exist = this.client.doesObjectExist(this.bucketName == null ? bucketName : this.bucketName, objectName);
        if (exist) {
            this.client.deleteObject(this.bucketName == null ? bucketName : this.bucketName, objectName);
            return new OssResult(true, "\u6587\u4ef6\u5220\u9664\u6210\u529f > ".concat(objectName));
        }
        return new OssResult(false, "\u6587\u4ef6\u4e0d\u5b58\u5728, \u5220\u9664\u5931\u8d25!");
    }

    public OssResult delete(String objectName) {
        return this.delete(null, objectName);
    }

    public String getContentType(String fileName) {
        Path path = Paths.get(fileName, new String[0]);
        String contentType = null;
        try {
            contentType = Files.probeContentType(path);
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.debug("File content type is : " + contentType, new Object[0]);
        }
        return contentType;
    }
}

