/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.restful.render;

import cn.jants.common.exception.TipException;
import cn.jants.common.utils.StrUtil;
import cn.jants.core.context.AppConstant;
import cn.jants.core.utils.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Resource {
    private String resName;
    private Object data;

    public Resource(String resName) {
        this.resName = StrUtil.delFirstInitial(resName, Character.valueOf('/'));
    }

    public Resource(String resName, Object data) {
        this.resName = StrUtil.delFirstInitial(resName, Character.valueOf('/'));
        this.data = data;
    }

    public void render(HttpServletRequest request, HttpServletResponse response) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.resName);
        if (in == null) {
            throw new TipException(this.resName + " \u8d44\u6e90\u6587\u4ef6\u672a\u627e\u5230 NotFound !");
        }
        this.write(request, response, in);
    }

    public void write(HttpServletRequest request, HttpServletResponse response, InputStream in) {
        try {
            String contentType = request.getServletContext().getMimeType(this.resName);
            if (contentType == null) {
                contentType = "text/html";
            }
            response.setContentType(contentType);
            if (contentType.startsWith("image/")) {
                int count;
                ServletOutputStream output = response.getOutputStream();
                byte[] buffer = new byte[2048];
                while ((count = in.read(buffer)) > 0) {
                    output.write(buffer, 0, count);
                }
                in.close();
                output.close();
                return;
            }
            String content = FileUtil.read(in, AppConstant.DEFAULT_ENCODING);
            if (contentType.startsWith("text/html")) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>(10);
                dataMap.put("ctx", request.getContextPath());
                dataMap.put("JS_PATH", "/static/js");
                dataMap.put("IMG_PATH", "/static/images");
                dataMap.put("CSS_PATH", "/static/css");
                dataMap.put("SWF_PATH", "/static/swf");
                dataMap.put("UE_PATH", "/static/ueditor");
                if (dataMap != null) {
                    content = this.replace(content, dataMap);
                }
            }
            response.getWriter().write(content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String replace(String content, Map<String, Object> map) {
        if (map == null || content == null) {
            return content;
        }
        Set<Map.Entry<String, Object>> sets = map.entrySet();
        for (Map.Entry<String, Object> entry : sets) {
            String key = entry.getKey();
            String regex = "${" + key + "}";
            content = content.replace(regex, String.valueOf(entry.getValue()));
        }
        return content;
    }
}

