/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.common.utils;

import java.text.SimpleDateFormat;
import java.util.Date;

public class DateUtil {
    public static String toTips(Date date, Date now, String formatStr) {
        long l = now.getTime() - date.getTime();
        long day = l / 86400000L;
        long hour = l / 3600000L - day * 24L;
        long min = l / 60000L - day * 24L * 60L - hour * 60L;
        long s = l / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        if (day > 0L) {
            if (day == 1L) {
                return "\u6628\u5929";
            }
            if (day < 30L) {
                return day + "\u5929\u524d";
            }
            SimpleDateFormat df = new SimpleDateFormat(formatStr);
            return df.format(date);
        }
        if (hour > 0L) {
            return hour + "\u5c0f\u65f6\u524d";
        }
        if (min > 0L) {
            return min + "\u5206\u949f\u524d";
        }
        return s + "\u79d2\u524d";
    }

    public static String toMsTips(Date startDate, Date endDate) {
        long toDay = System.currentTimeMillis();
        StringBuffer sb = new StringBuffer();
        if (startDate == null && endDate == null) {
            return "";
        }
        if (startDate == null) {
            long endTime = endDate.getTime();
            if (toDay > endTime) {
                return "\u5df2\u7ed3\u675f";
            }
            long l = endTime - toDay;
            long day = l / 86400000L;
            long hour = l / 3600000L - day * 24L;
            long min = l / 60000L - day * 24L * 60L - hour * 60L;
            if (day > 0L) {
                sb.append(day + "\u5929");
            }
            if (hour > 0L) {
                sb.append(hour + "\u65f6");
            }
            if (min > 0L) {
                sb.append(min + "\u5206");
            }
            return sb.toString();
        }
        if (endDate == null) {
            long startTime = startDate.getTime();
            if (toDay > startTime) {
                return "\u8fdb\u884c\u4e2d";
            }
            return "\u5df2\u7ed3\u675f";
        }
        long startTime = startDate.getTime();
        long endTime = endDate.getTime();
        if (toDay < startTime) {
            sb.append("\u672a\u5f00\u59cb");
        } else if (toDay >= startTime && toDay <= endTime) {
            sb.append("\u5269 ");
            long l = endTime - toDay;
            long day = l / 86400000L;
            long hour = l / 3600000L - day * 24L;
            long min = l / 60000L - day * 24L * 60L - hour * 60L;
            if (day > 0L) {
                sb.append(day + "\u5929");
            }
            if (hour > 0L) {
                sb.append(hour + "\u65f6");
            }
            if (min > 0L) {
                sb.append(min + "\u5206");
            }
        } else if (toDay > endTime) {
            sb.append("\u5df2\u7ed3\u675f");
        }
        return sb.toString();
    }

    public static boolean isDay(Date date, Date now) {
        long l = now.getTime() - date.getTime();
        long day = l / 86400000L;
        return day <= 0L;
    }

    public static String getDataTime(String formatStr) {
        SimpleDateFormat df = new SimpleDateFormat(formatStr);
        return df.format(new Date());
    }

    public static String toStrDate(Date date, String formatStr) {
        SimpleDateFormat df = new SimpleDateFormat(formatStr);
        return df.format(date);
    }
}

