/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.common.utils;

import cn.jants.common.bean.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

public class FileUtil {
    public static String read(String fileName, boolean isBuff) {
        StringBuffer data = new StringBuffer();
        try {
            BufferedReader in = isBuff ? new BufferedReader(new FileReader(fileName), 0x500000) : new BufferedReader(new FileReader(fileName));
            String line = "";
            while ((line = in.readLine()) != null) {
                data.append(line);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data.toString();
    }

    public static String read(String fileName) {
        return FileUtil.read(fileName, false);
    }

    public static String read(InputStream inputStream, String encoding) {
        try {
            String line;
            if (inputStream == null) {
                return null;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, encoding));
            StringBuffer sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean move(String oldFile, String newFile, boolean isCover) {
        File file = new File(oldFile);
        if (file.exists()) {
            File neile = new File(newFile);
            if (isCover) {
                file.renameTo(neile);
            } else if (neile.exists()) {
                Log.info(newFile + " > \u6587\u4ef6\u5df2\u7ecf\u5b58\u5728!", new Object[0]);
            } else {
                file.renameTo(neile);
            }
            return true;
        }
        return false;
    }

    public static boolean move(String oldFile, String newFile) {
        return FileUtil.move(oldFile, newFile, true);
    }

    public static boolean download(String urlString, String filename) {
        try {
            int len;
            URL url = new URL(urlString);
            URLConnection con = url.openConnection();
            InputStream is = con.getInputStream();
            byte[] bs = new byte[1024];
            File file = new File(filename.substring(0, filename.lastIndexOf("/")));
            if (!file.exists()) {
                file.mkdirs();
            }
            FileOutputStream os = new FileOutputStream(filename);
            while ((len = is.read(bs)) != -1) {
                ((OutputStream)os).write(bs, 0, len);
            }
            ((OutputStream)os).close();
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void download(String path, HttpServletResponse response) {
        FileUtil.download(path, null, response);
    }

    public static void download(String path, String newName, HttpServletResponse response) {
        try {
            File file = new File(path);
            String filename = file.getName();
            String ext = filename.substring(filename.lastIndexOf(".") + 1);
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(path));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            response.reset();
            response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(newName == null ? filename : newName, response.getCharacterEncoding()));
            response.addHeader("Content-Length", "" + file.length());
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setContentType("application/octet-stream");
            ((OutputStream)toClient).write(buffer);
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static boolean copyFile(String currentFile, String targetFile) {
        FileInputStream in = null;
        try {
            int c;
            in = new FileInputStream(currentFile);
            FileOutputStream out = new FileOutputStream(FileUtil.create(targetFile));
            byte[] buffer = new byte[1024];
            while ((c = in.read(buffer)) != -1) {
                for (int i = 0; i < c; ++i) {
                    out.write(buffer[i]);
                }
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static File create(String filePath) {
        File file = new File(filePath);
        if (file.isDirectory()) {
            if (!file.exists()) {
                file.mkdirs();
            }
        } else if (!file.exists()) {
            String path = file.getPath();
            path = path.substring(0, path.lastIndexOf("\\"));
            new File(path).mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static void copyFolder(String currentFolder, String targetFolder) {
        ArrayList<File> list = new ArrayList<File>();
        FileUtil.iterator(currentFolder, true, "", list);
        for (File f : list) {
            String currentFile = f.getPath();
            String targetFile = targetFolder + currentFile.replace(currentFolder, "");
            FileUtil.copyFile(currentFile, targetFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean write(String fileName, String content, boolean isAppend) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName, isAppend)));
            out.write(content);
            out.write("\r\n");
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static boolean write(InputStream inputStream, String filePath) {
        boolean check = false;
        try {
            FileOutputStream out = new FileOutputStream(filePath);
            byte[] buffer = new byte[1024];
            int length = -1;
            while ((length = inputStream.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            inputStream.close();
            ((OutputStream)out).close();
            check = true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return check;
    }

    public static boolean write(String fileName, String content) {
        return FileUtil.write(fileName, content, false);
    }

    public static boolean rename(String path, String oldName, String newName) {
        File file = new File(path + File.separator + oldName);
        if (file.exists()) {
            file.renameTo(new File(path + File.separator + newName));
            return true;
        }
        return false;
    }

    public static void iterator(String filePath, Boolean isLoop, String type, List<File> fileList) {
        File dir = new File(filePath);
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    if (!isLoop.booleanValue()) continue;
                    FileUtil.iterator(file.getAbsolutePath(), isLoop, type, fileList);
                    continue;
                }
                if (file.getAbsolutePath().indexOf(type) == -1) continue;
                fileList.add(file);
            }
        }
    }

    public static void delete(String filePath) {
        File file = new File(filePath);
        if (file != null && file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    FileUtil.delete(files[i].getPath());
                }
            }
            file.delete();
        }
    }

    public static void existCreate(String fileDir) {
        File file = new File(fileDir);
        if (!file.exists()) {
            file.mkdirs();
        }
    }
}

